/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class TETL1IgmpMemfullEventNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        String slotAid = "";
        String memnum = "";
        int neID = (int)neid;
        Part part = null;
        OutMsg[] output = oper.getOutMsg();
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int len = output.length;
        for (int i = 0; i < len; ++i) {
            HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[i]);
            part = (Part)partMap.get("AID");
            slotAid = part.getValue();
            part = (Part)partMap.get("MEMNUM");
            if (part != null && part.getValue() != null) {
                memnum = part.getValue();
            }
            TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
            abnormalEvent.eventID = 55126;
            abnormalEvent.eventName = "The number of the dynamic members in IGMP is full";
            abnormalEvent.location = "-";
            abnormalEvent.direction = "-";
            abnormalEvent.objStr = ne.getNEName();
            abnormalEvent.severityStr = "Not Reported";
            abnormalEvent.severityLevel = 5;
            abnormalEvent.nodeType = ne.getNEType();
            abnormalEvent.evtType = 2;
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(oper.getDate());
            abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
            StringBuffer sb = new StringBuffer();
            String[] aid = TETL1CommonUtil.parseAID(slotAid, neID);
            int slotNMID = TETL1CommonUtil.getNMSlotStr(slotAid, neID);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotNMID);
            String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
            sb.append("Slot: ");
            sb.append(slotNMID);
            sb.append("-");
            sb.append(boardName);
            sb.append(",");
            int portID = Integer.parseInt(aid[3]);
            int pathID = Integer.parseInt(aid[4]);
            if (portID != -1) {
                String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neID);
                sb.append("Port: ");
                sb.append(portName);
                sb.append(",");
            }
            if (pathID != -1) {
                sb.append("Path: ");
                sb.append(pathID);
                sb.append(",");
            }
            sb.append("Detail Description: ");
            sb.append("The number of the dynamic members in IGMP is full, the number of the dynamic members in IGMP is ").append(memnum);
            abnormalEvent.comment = sb.toString();
            TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
        }
    }
}

