/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.GregorianCalendar;

public class TETL1IPAAbnormalEvent {
    private static final String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
    private static TETL1IPAAbnormalEvent instance = null;
    private TL1Operation oper = null;
    private TL1Definitions definitions = null;
    private TETL1IPAEventNoticeHandler eventNoticeHandler = new TETL1IPAEventNoticeHandler();

    private TETL1IPAAbnormalEvent() {
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TETL1IPAAbnormalEvent.TETL1IPAAbnormalEvent() fail!", (Throwable)ex);
        }
    }

    public static synchronized TETL1IPAAbnormalEvent getInstance() {
        if (instance == null) {
            instance = new TETL1IPAAbnormalEvent();
        }
        return instance;
    }

    public void registerTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_EVT_IPA");
        TETL1NECommMgr.getInstance().registerListener(this.oper, (TL1NoticeHandler)this.eventNoticeHandler);
    }

    public void unregisterTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_EVT_IPA");
        TETL1NECommMgr.getInstance().unregisterListener(this.oper, (TL1NoticeHandler)this.eventNoticeHandler);
    }

    class TETL1IPAEventNoticeHandler
    implements TL1NoticeHandler {
        TETL1IPAEventNoticeHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            try {
                OutMsg[] output = oper.getOutMsg();
                String dectAid = output[0].getMsgBlock().getDataBlock(0).getPart(0).getValue();
                String oprtAid = output[0].getMsgBlock().getDataBlock(0).getPart(1).getValue();
                String ipaState = output[0].getMsgBlock().getDataBlock(1).getPart(0).getValue();
                int eventID = TETL1EventConstants.IPAEVENT;
                TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(eventID);
                if (eventData == null) {
                    return;
                }
                TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
                if (ne == null) {
                    return;
                }
                int evtSeverity = eventData.getEvtSeverity();
                TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
                abnormalEvent.eventID = eventID;
                abnormalEvent.eventName = eventData.getEvtName();
                abnormalEvent.location = "-";
                abnormalEvent.direction = "-";
                abnormalEvent.objStr = ne.getNEName();
                abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(evtSeverity);
                abnormalEvent.severityLevel = evtSeverity;
                abnormalEvent.nodeType = ne.getNEType();
                abnormalEvent.evtType = eventData.getEvtType();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(oper.getDate());
                abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
                abnormalEvent.comment = this.parseComment(dectAid, oprtAid, neID, ipaState);
                TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETL1IPAEventNoticeHandler fail!", (Throwable)e);
            }
        }

        private String parseComment(String dectfac, String oprtfac, int neid, String state) {
            StringBuffer sb = new StringBuffer();
            String[] aid = TETL1CommonUtil.parseAID(dectfac, neid);
            int slotNMID = TETL1CommonUtil.getNMSlotStr(dectfac, neid);
            String showSlot = TETL1CommonUtil.getShelfSlotName(neid, slotNMID);
            int portID = Integer.parseInt(aid[3]);
            String[] oprtaid = TETL1CommonUtil.parseAID(oprtfac, neid);
            int oprtslotNMID = TETL1CommonUtil.getNMSlotStr(oprtfac, neid);
            String showOprtslot = TETL1CommonUtil.getShelfSlotName(neid, oprtslotNMID);
            int opertportID = Integer.parseInt(oprtaid[3]);
            if (slotNMID == -1) {
                sb.append("IPA Pair(Detection Board: <Blank>");
            } else {
                sb.append("IPA Pair(Detection Board:" + showSlot + " " + "Port:" + portID);
            }
            sb.append(" /Control Implementation:" + showOprtslot + " Port:" + opertportID + ")");
            String ipaState = "";
            if (state.equals("START")) {
                ipaState = "IPA begin";
            } else if (state.equals("END")) {
                ipaState = "IPA stop";
            } else if (state.equals("LSRON")) {
                ipaState = "Laser open";
            } else if (state.equals("LSROFF")) {
                ipaState = "Laser close";
            } else if (state.equals("ABNSTOP")) {
                ipaState = "IPA abnormal stop";
            } else if (state.equals("ALM")) {
                ipaState = "Alarm exists";
            } else if (state.equals("RESTART")) {
                ipaState = "IPA restarts";
            } else if (state.equals("SAFEDECT")) {
                ipaState = "IPA detect";
            } else if (state.equals("ENABLE")) {
                ipaState = "IPA enable";
            }
            sb.append("Status-").append(ipaState);
            return sb.toString();
        }
    }
}

