/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

public class TETL1DstChangeEvent {
    private String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
    private static TETL1DstChangeEvent instance = null;
    private TL1Operation operStart = null;
    private TL1Operation operEnd = null;
    private TL1Definitions definitions = null;
    private TEDstChangeEventNoticeHandler mod2EventNoticeHandler = new TEDstChangeEventNoticeHandler();
    private static final String STARTDST = "STARTDSTADJ";
    private static final String ENDDST = "ENDDSTADJ";

    private TETL1DstChangeEvent() {
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", this.TL1_DES_PATH_MAIN);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TETL1DstChangeEvent.TETL1DstChangeEvent() fail!", (Throwable)ex);
        }
    }

    public static synchronized TETL1DstChangeEvent getInstance() {
        if (instance == null) {
            instance = new TETL1DstChangeEvent();
        }
        return instance;
    }

    public void registerTL1Event() {
        this.operStart = this.definitions.getTL1Operation("REPT_EVT_STARTDSTADJ");
        this.operEnd = this.definitions.getTL1Operation("REPT_EVT_ENDDSTADJ");
        TETL1NECommMgr.getInstance().registerListener(this.operStart, (TL1NoticeHandler)this.mod2EventNoticeHandler);
        TETL1NECommMgr.getInstance().registerListener(this.operEnd, (TL1NoticeHandler)this.mod2EventNoticeHandler);
    }

    public void unregisterTL1Event() {
        TETL1NECommMgr.getInstance().unregisterListener(this.operStart, (TL1NoticeHandler)this.mod2EventNoticeHandler);
        TETL1NECommMgr.getInstance().unregisterListener(this.operEnd, (TL1NoticeHandler)this.mod2EventNoticeHandler);
    }

    class TEDstChangeEventNoticeHandler
    implements TL1NoticeHandler {
        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            try {
                TETL1EventData eventData;
                Part part = null;
                OutMsg[] output = oper.getOutMsg();
                TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
                if (ne == null) {
                    return;
                }
                TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
                HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[0]);
                if (oper.getMod2().equals(TETL1DstChangeEvent.STARTDST)) {
                    ne.setDstEnable(true);
                    abnormalEvent.eventID = TETL1EventConstants.DAYLIGHTSTART;
                } else if (oper.getMod2().equals(TETL1DstChangeEvent.ENDDST)) {
                    ne.setDstEnable(false);
                    abnormalEvent.eventID = TETL1EventConstants.DAYLIGHTEND;
                }
                part = (Part)partMap.get("ADJUST_VALUE");
                if (part != null && part.getValue() != null) {
                    ne.setDstOffset(Integer.parseInt(part.getValue()));
                }
                if ((eventData = TEParseEventDatasXml.getInstance().getEventData(abnormalEvent.eventID)) == null) {
                    return;
                }
                abnormalEvent.eventName = eventData.getEvtName();
                abnormalEvent.location = TETL1FaultUtil.converAlarmLocation(null);
                abnormalEvent.direction = TETL1FaultUtil.convertAlarmDirection(null);
                abnormalEvent.objStr = ne.getNEName();
                abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(eventData.getEvtSeverity());
                abnormalEvent.nodeType = ne.getNEType();
                abnormalEvent.severityLevel = eventData.getEvtSeverity();
                abnormalEvent.evtType = eventData.getEvtType();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(oper.getDate());
                TETimeTocalizationSwitchBean.getTimeZoneDateInstance(neID).getNETimeZone();
                Calendar cal = TEDateUtils.getTL1NMTimeFromNETime(neID, calendar.getTimeInMillis());
                abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(cal);
                abnormalEvent.comment = "Adjust Value: " + ne.getDstOffset() + " Minute";
                TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEDstChangeEventNoticeHandler fail!", (Throwable)e);
            }
        }
    }
}

