/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DBCHGData;
import com.huawei.nglct.tl1.eventinterpret.TEDbchgDataEventHandle;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1QueryLogicPort;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;

public class TETL1DBCHGEventNoticeHandler
implements TL1NoticeHandler {
    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        int neID = (int)neid;
        Part part = oper.getOutMsg()[0].getMsgBlock().getPart("COMMAND");
        if (part == null || part.getValue() == null) {
            return;
        }
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null || ne.getLogStatus() == 0) {
            return;
        }
        TETL1DBCHGData data = this.setDataToDBCHGData(oper.getOutMsg()[0].getMsgBlock());
        if (data.getDbchgCMDCode().equalsIgnoreCase("ENT-EQPT") || data.getDbchgCMDCode().equalsIgnoreCase("ED-EQPT") || data.getDbchgCMDCode().equalsIgnoreCase("DLT-EQPT")) {
            TELogFactory.getNormalLogger().info("DBCHG EVENT: " + ne.getNEName() + " " + data.getDbchgDateStr() + " " + data.getDbchgTimeStr() + " " + data.getDbchgStrInfo());
            ne.update(data);
        }
        if (data.getDbchgCMDCode().equalsIgnoreCase("ED-CLNT")) {
            String fac = data.getDbchgAID();
            int slotId = TETL1CommonUtil.getNMSlotStr(fac, neID);
            TETL1QueryLogicPort.queryRealMod2(neID, slotId);
        }
        if (data.getDbchgCMDCode().equalsIgnoreCase("ent-user-secu") || data.getDbchgCMDCode().equalsIgnoreCase("ed-user-secu") || data.getDbchgCMDCode().equalsIgnoreCase("dlt-user-secu")) {
            TEDbchgDataEventHandle.handleNEUserEvent(data, neID);
        }
        if (data.getDbchgCMDCode().equalsIgnoreCase("INH-USER-SECU") || data.getDbchgCMDCode().equalsIgnoreCase("ALW-USER-SECU")) {
            TEDbchgDataEventHandle.lockUnlcokNEUserEvent(data, neID);
        }
        if (data.getDbchgCMDCode().equalsIgnoreCase("ED-SYS") && data.getDbchgParam().indexOf("ASON") != -1) {
            try {
                String dbStr = data.getDbchgParam();
                String[] nameStr = dbStr.split(",");
                String flag = "";
                int len = nameStr.length;
                for (int i = 0; i < len; ++i) {
                    String[] param = nameStr[i].split("=");
                    if (!param[0].equalsIgnoreCase("ASON")) continue;
                    flag = param[1];
                    break;
                }
                TETL1NE tl1ne = ne;
                tl1ne.setStartAsonFlag(flag);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETL1DBCHGEventNoticeHandler.handleNotice fail!", (Throwable)e);
            }
        }
    }

    private TETL1DBCHGData setDataToDBCHGData(MsgBlock msgBlock) {
        TETL1DBCHGData data = new TETL1DBCHGData();
        data.setDbchgDateStr(msgBlock.getPart("DATE").getValue());
        data.setDbchgTimeStr(msgBlock.getPart("TIME").getValue());
        data.setDbchgSource(msgBlock.getPart("SOURCE").getValue());
        data.setUserID(msgBlock.getPart("USERID").getValue());
        data.setDbchgSEQ(msgBlock.getPart("DBCHGSEQ").getValue());
        data.setDbchgCMDCode(msgBlock.getPart("COMMAND").getValue());
        data.setDbchgAID(msgBlock.getPart("AID").getValue());
        return data;
    }
}

