/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.GregorianCalendar;

public class TETL11P1SwitchEvent {
    private static final String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
    private static TETL11P1SwitchEvent instance = null;
    private TL1Operation oper = null;
    private TL1Definitions definitions = null;
    private TETL11P1SwitchEventNoticeHandler eventNoticeHandler = new TETL11P1SwitchEventNoticeHandler();

    private TETL11P1SwitchEvent() {
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TETL11P1SwitchEvent.TETL11P1SwitchEvent() IOException!", (Throwable)ex);
        }
    }

    public static synchronized TETL11P1SwitchEvent getInstance() {
        if (instance == null) {
            instance = new TETL11P1SwitchEvent();
        }
        return instance;
    }

    public void registerTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_SW");
        TETL1NECommMgr.getInstance().registerListener(this.oper, (TL1NoticeHandler)this.eventNoticeHandler);
    }

    public void unregisterTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_SW");
        TETL1NECommMgr.getInstance().unregisterListener(this.oper, (TL1NoticeHandler)this.eventNoticeHandler);
    }

    class TETL11P1SwitchEventNoticeHandler
    implements TL1NoticeHandler {
        TETL11P1SwitchEventNoticeHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            try {
                OutMsg[] output = oper.getOutMsg();
                String actSlot = output[0].getMsgBlock().getDataBlock(0).getPart(0).getValue();
                String standbySlot = output[0].getMsgBlock().getDataBlock(0).getPart(1).getValue();
                int eventID = TETL1EventConstants.BOARD1PLUS1;
                TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
                if (ne == null) {
                    return;
                }
                int evtSeverity = 1;
                TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
                abnormalEvent.eventID = eventID;
                abnormalEvent.eventName = "Board 1+1 protection switching";
                abnormalEvent.location = "-";
                abnormalEvent.direction = "-";
                abnormalEvent.objStr = ne.getNEName();
                abnormalEvent.severityStr = TETL1FaultUtil.convertAlarmLevel(evtSeverity);
                abnormalEvent.severityLevel = evtSeverity;
                abnormalEvent.nodeType = ne.getNEType();
                abnormalEvent.evtType = 2;
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(oper.getDate());
                abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
                abnormalEvent.comment = "Act slot: " + actSlot + "," + "Standby slot: " + standbySlot;
                TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETL11P1SwitchEventNoticeHandler fail!", (Throwable)e);
            }
        }
    }
}

