/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TEPingTestReport {
    private static TEStateReportHandler handlereventrespond = new TEStateReportHandler();
    private final int neID;
    private final int slotid;
    private static Map reportMap = new HashMap();
    private static BussinessParams bussinessParams = new BussinessParams();
    RowParams rowparams = null;
    private final Datainterface reportedData = new Datainterface();

    private TEPingTestReport(int neID, int slotid) {
        this.neID = neID;
        this.slotid = slotid;
        this.reportedData.setBussinessParams(bussinessParams);
    }

    public static void register() {
        try {
            String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
            TL1Operation timeoutOper = definitions.getTL1Operation("OAM_PING_TIMEOUT");
            TL1Operation resOper = definitions.getTL1Operation("OAM_PING_RESPONSE");
            TL1Operation statisOper = definitions.getTL1Operation("OAM_PING_STATISTICS");
            TETL1NECommMgr.getInstance().registerListener(timeoutOper, (TL1NoticeHandler)handlereventrespond);
            TETL1NECommMgr.getInstance().registerListener(resOper, (TL1NoticeHandler)handlereventrespond);
            TETL1NECommMgr.getInstance().registerListener(statisOper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEScanStateReport registerListener error", (Throwable)e);
        }
    }

    public static void unregister(int neid) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            TL1Operation timeoutOper = definitions.getTL1Operation("OAM_PING_TIMEOUT");
            TL1Operation resOper = definitions.getTL1Operation("OAM_PING_RESPONSE");
            TL1Operation statisOper = definitions.getTL1Operation("OAM_PING_STATISTICS");
            TETL1NECommMgr.getInstance().unregisterListener(timeoutOper, (TL1NoticeHandler)handlereventrespond);
            TETL1NECommMgr.getInstance().unregisterListener(resOper, (TL1NoticeHandler)handlereventrespond);
            TETL1NECommMgr.getInstance().unregisterListener(statisOper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public Datainterface getReportData() {
        return this.reportedData;
    }

    public static TEPingTestReport getTthTestReport(int neid, int slotid) {
        String key = String.valueOf(neid) + String.valueOf(slotid);
        TEPingTestReport ptr = null;
        if (null != reportMap.get(key)) {
            return (TEPingTestReport)reportMap.get(key);
        }
        ptr = new TEPingTestReport(neid, slotid);
        reportMap.put(key, ptr);
        return ptr;
    }

    public static void clearEthTestReport(int neid, int slotid) {
        String key = String.valueOf(neid) + String.valueOf(slotid);
        bussinessParams = new BussinessParams();
        if (null != reportMap.get(key)) {
            reportMap.remove(key);
        }
    }

    static class TEStateReportHandler
    implements TL1NoticeHandler {
        Part part = null;
        Param param = null;

        TEStateReportHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            RowParams row = new RowParams();
            bussinessParams.addRowParams(row);
            int n = oper.getOutMsgCount();
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart(oper.getOutMsg(i));
                if (oper.getName().equals("OAM_PING_TIMEOUT")) {
                    this.addParamStr("1", "eventType", row);
                } else if (oper.getName().equals("OAM_PING_RESPONSE")) {
                    this.addParamStr("0", "eventType", row);
                } else if (oper.getName().equals("OAM_PING_STATISTICS")) {
                    this.addParamStr("2", "eventType", row);
                }
                Part AIDPart = (Part)hm.get("AID");
                this.addParam(AIDPart, "AID", row);
                String srcMpID = TETL1CommonUtil.parseAID(AIDPart.getValue(), neID)[3];
                srcMpID = Long.toHexString(Long.parseLong(srcMpID));
                srcMpID = this.fillMpId(srcMpID);
                srcMpID = srcMpID.toUpperCase();
                this.addParamStr(srcMpID, "SRCMPID", row);
                String snkMpID = ((Part)hm.get("DSTMPIP")).getValue();
                this.addParamStr(snkMpID, "DSTMPID", row);
                this.addParam((Part)hm.get("FRAMELENGTH"), "FRAMELENGTH", row);
                this.addParam((Part)hm.get("DELAYTIME"), "DELAYTIME", row);
                this.addParam((Part)hm.get("TTL"), "TTL", row);
                this.addParam((Part)hm.get("SENDPACKETS"), "SENDPACKETS", row);
                this.addParam((Part)hm.get("RECEIVEPACKETS"), "RECEIVEPACKETS", row);
                this.addParam((Part)hm.get("LOSTRATE"), "LOSTRATE", row);
                this.addParam((Part)hm.get("MINDELAY"), "MINDELAY", row);
                this.addParam((Part)hm.get("MAXDELAY"), "MAXDELAY", row);
                this.addParam((Part)hm.get("EVERAGEDELAY"), "EVERAGEDELAY", row);
            }
        }

        void addParam(Part part, String retrunParam, RowParams row) {
            if (part == null) {
                return;
            }
            if (null == row.getParam(retrunParam)) {
                this.param = new Param(retrunParam, part.getValue());
                row.addParam(this.param);
            } else {
                row.getParam(retrunParam).setValue(part.getValue());
            }
        }

        void addParamStr(String str, String retrunParam, RowParams row) {
            if (null == row.getParam(retrunParam)) {
                this.param = new Param(retrunParam, str);
                row.addParam(this.param);
            } else {
                row.getParam(retrunParam).setValue(str);
            }
        }

        private String fillMpId(String mpid) {
            int len = mpid.length();
            StringBuilder mpids = new StringBuilder("");
            for (int i = 0; i < 8 - len; ++i) {
                mpids.append('0');
            }
            return mpids.toString() + mpid;
        }
    }
}

