/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEParseEventDatasXml {
    private static TEParseEventDatasXml instance = null;
    private ArrayList eventDataList = new ArrayList();

    private TEParseEventDatasXml() {
        this.eventDataList.clear();
        this.parseXML();
    }

    public static synchronized TEParseEventDatasXml getInstance() {
        if (instance == null) {
            instance = new TEParseEventDatasXml();
        }
        return instance;
    }

    private void parseXML() {
        StringBuffer tl1Path = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append("conf").append(File.separator).append("eventDatas").append(".xml");
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            File f = TEResourceManager.getFileByName(tl1Path.toString());
            sp.parse(f, (DefaultHandler)new PaserAlarmHandler());
        }
        catch (SAXException e) {
            TELogFactory.getNormalLogger().error("TEParseEventDatasXml.parseXML() SAXException!", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            TELogFactory.getNormalLogger().error("TEParseEventDatasXml.parseXML() ParserConfigurationException!", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEParseEventDatasXml.parseXML() IOException!", (Throwable)e);
        }
    }

    public TETL1EventData getEventData(int eventID) {
        int size = this.eventDataList.size();
        for (int i = 0; i < size; ++i) {
            TETL1EventData eventData = (TETL1EventData)this.eventDataList.get(i);
            if (eventData.getEventID() != eventID) continue;
            return eventData;
        }
        return null;
    }

    public ArrayList getEventDataList() {
        return this.eventDataList;
    }

    class PaserAlarmHandler
    extends DefaultHandler {
        PaserAlarmHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("param")) {
                int evtID = Integer.parseInt(attributes.getValue("EvtID"));
                int evtType = Integer.parseInt(attributes.getValue("EvtType"));
                int aidType = Integer.parseInt(attributes.getValue("AIDType"));
                int location = Integer.parseInt(attributes.getValue("Location"));
                int direction = Integer.parseInt(attributes.getValue("Direction"));
                int evtSeverity = Integer.parseInt(attributes.getValue("EvtSeverity"));
                int effectState = Integer.parseInt(attributes.getValue("EffectState"));
                int evtDomain = Integer.parseInt(attributes.getValue("EvtDomain"));
                String evtName = attributes.getValue("EvtName");
                String evtUnit = attributes.getValue("EvtUnit");
                TETL1EventData eventData = new TETL1EventData(evtID, evtType, aidType, location, direction, evtSeverity, effectState, evtDomain, evtName, evtUnit);
                if (!TEParseEventDatasXml.this.eventDataList.contains(eventData)) {
                    TEParseEventDatasXml.this.eventDataList.add(eventData);
                }
            }
        }
    }
}

