/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.GregorianCalendar;

public class TEMofifyInitPwdEvent {
    private static final String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
    private static TEMofifyInitPwdEvent instance = null;
    private TL1Operation oper = null;
    private TL1Definitions definitions = null;
    private TL1NoticeHandler eventNoticeHandler = new TETL1ModifyInitPwdEventNoticeHandler();

    private TEMofifyInitPwdEvent() {
        try {
            this.definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TEMofifyInitPwdEvent.TEMofifyInitPwdEvent() fail!", (Throwable)ex);
        }
    }

    public static synchronized TEMofifyInitPwdEvent getInstance() {
        if (instance == null) {
            instance = new TEMofifyInitPwdEvent();
        }
        return instance;
    }

    public void registerTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_MODIFYPASSWORD_NOTIFY");
        TETL1NECommMgr.getInstance().registerListener(this.oper, this.eventNoticeHandler);
    }

    public void unregisterTL1Event() {
        this.oper = this.definitions.getTL1Operation("REPT_MODIFYPASSWORD_NOTIFY");
        TETL1NECommMgr.getInstance().unregisterListener(this.oper, this.eventNoticeHandler);
    }

    class TETL1ModifyInitPwdEventNoticeHandler
    implements TL1NoticeHandler {
        TETL1ModifyInitPwdEventNoticeHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            try {
                OutMsg[] output = oper.getOutMsg();
                String value = output[0].getMsgBlock().getDataBlock(1).getPart(0).getValue();
                int eventID = TETL1EventConstants.MODIFYPASSWD;
                TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(eventID);
                if (eventData == null) {
                    return;
                }
                TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
                if (ne == null) {
                    return;
                }
                int evtSeverity = eventData.getEvtSeverity();
                TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
                abnormalEvent.eventID = eventID;
                abnormalEvent.eventName = eventData.getEvtName();
                abnormalEvent.location = "-";
                abnormalEvent.direction = "-";
                abnormalEvent.objStr = TEConfigurationDataMgr.getInstance().getNEName(neID);
                abnormalEvent.severityStr = "Not Alarmed";
                abnormalEvent.severityLevel = evtSeverity;
                abnormalEvent.nodeType = ne.getNEType();
                abnormalEvent.evtType = eventData.getEvtType();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(oper.getDate());
                abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
                abnormalEvent.comment = value;
                TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TETL1ModifyInitPwdEventNoticeHandler fail!", (Throwable)e);
            }
        }
    }
}

