/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TEEtherTestReport {
    private static TEStateReportHandler handlereventrespond = new TEStateReportHandler();
    private final int neID;
    private final int slotid;
    private static Map reportMap = new HashMap();
    private static ArrayList ethTestReportList = new ArrayList();
    private final HashMap reportedData = new HashMap();

    private TEEtherTestReport(int neID, int slotid, int portid, int channel) {
        this.neID = neID;
        this.slotid = slotid;
        this.reportedData.put(String.valueOf(neID) + String.valueOf(slotid) + String.valueOf(portid) + String.valueOf(channel), ethTestReportList);
    }

    public static void register() {
        try {
            String TL1_DES_PATH_MAIN = "conf" + File.separator + "eventtl1describ.xml";
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile("com.huawei.weblct.common", TL1_DES_PATH_MAIN);
            TL1Operation ethTestOper = definitions.getTL1Operation("REPT_EVT_PING");
            TETL1NECommMgr.getInstance().registerListener(ethTestOper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Ethernet Test registerListener error", (Throwable)e);
        }
    }

    public static void unregister(int neid) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            TL1Operation timeoutOper = definitions.getTL1Operation("REPT_EVT_PING");
            TETL1NECommMgr.getInstance().unregisterListener(timeoutOper, (TL1NoticeHandler)handlereventrespond);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Ethernet Test registerListener error", (Throwable)e);
        }
    }

    public HashMap getReportData() {
        return this.reportedData;
    }

    public static TEEtherTestReport getTthTestReport(int neid, int slotid, int portid, int channel) {
        String key = String.valueOf(neid) + String.valueOf(slotid) + String.valueOf(portid) + String.valueOf(channel);
        TEEtherTestReport ptr = null;
        if (null != reportMap.get(key)) {
            return (TEEtherTestReport)reportMap.get(key);
        }
        ptr = new TEEtherTestReport(neid, slotid, portid, channel);
        reportMap.put(key, ptr);
        return ptr;
    }

    public static class EthTestReport {
        private String aid;
        private String portid;
        private String RESPONDRECV;
        private String NORMALRECV;
        private String TOTALSEND;
        private String IPFLAG;

        public String getAid() {
            return this.aid;
        }

        public void setAid(String aid) {
            this.aid = aid;
        }

        public String getPortid() {
            return this.portid;
        }

        public void setPortid(String portid) {
            this.portid = portid;
        }

        public String getRESPONDRECV() {
            return this.RESPONDRECV;
        }

        public void setRESPONDRECV(String respondrecv) {
            this.RESPONDRECV = respondrecv;
        }

        public String getNORMALRECV() {
            return this.NORMALRECV;
        }

        public void setNORMALRECV(String normalrecv) {
            this.NORMALRECV = normalrecv;
        }

        public String getTOTALSEND() {
            return this.TOTALSEND;
        }

        public void setTOTALSEND(String totalsend) {
            this.TOTALSEND = totalsend;
        }

        public String getIPFLAG() {
            return this.IPFLAG;
        }

        public void setIPFLAG(String ipflag) {
            this.IPFLAG = ipflag;
        }
    }

    static class TEStateReportHandler
    implements TL1NoticeHandler {
        Param param = null;

        TEStateReportHandler() {
        }

        public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
            int neID = (int)neid;
            EthTestReport report = new EthTestReport();
            int n = oper.getOutMsgCount();
            for (int i = 0; i < n; ++i) {
                HashMap hm = TETL1CommonUtil.getOutMsgPart(oper.getOutMsg(i));
                Part temp = (Part)hm.get("AID");
                report.setAid(temp.getValue());
                int portid = TETL1CommonUtil.getNMPortNOFromAidStruct(temp.getValue(), neID);
                report.setPortid(String.valueOf(portid));
                temp = (Part)hm.get("RESPONDRECV");
                if (temp != null) {
                    report.setRESPONDRECV(temp.getValue());
                }
                if ((temp = (Part)hm.get("NORMALRECV")) != null) {
                    report.setNORMALRECV(temp.getValue());
                }
                if ((temp = (Part)hm.get("TOTALSEND")) != null) {
                    report.setTOTALSEND(temp.getValue());
                }
                if ((temp = (Part)hm.get("IPFLAG")) == null) continue;
                report.setIPFLAG(temp.getValue());
            }
            ethTestReportList.add(report);
        }

        void addReport(Part part, String retrunParam, RowParams row) {
            if (part == null) {
                return;
            }
            if (null == row.getParam(retrunParam)) {
                this.param = new Param(retrunParam, part.getValue());
                row.addParam(this.param);
            } else {
                row.getParam(retrunParam).setValue(part.getValue());
            }
        }

        void addParamStr(String str, String retrunParam, RowParams row) {
            if (null == row.getParam(retrunParam)) {
                this.param = new Param(retrunParam, str);
                row.addParam(this.param);
            } else {
                row.getParam(retrunParam).setValue(str);
            }
        }
    }
}

