/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1DBCHGData;
import com.huawei.nglct.tl1.eventinterpret.TEParseEventDatasXml;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventData;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.util.Calendar;

public class TEDbchgDataEventHandle {
    public static void handleNEUserEvent(TETL1DBCHGData data, int neID) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int eventID = -1;
        if (data.getDbchgCMDCode().equalsIgnoreCase("ent-user-secu")) {
            eventID = TETL1EventConstants.NEUSERADD;
        } else if (data.getDbchgCMDCode().equalsIgnoreCase("ed-user-secu")) {
            eventID = TETL1EventConstants.NEUSERINFORMATIONMODIFY;
        } else if (data.getDbchgCMDCode().equalsIgnoreCase("dlt-user-secu")) {
            eventID = TETL1EventConstants.NEUSERDELETE;
        }
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(eventID);
        if (eventData == null) {
            return;
        }
        int evtSeverity = eventData.getEvtSeverity();
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = eventID;
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = "-";
        abnormalEvent.direction = "-";
        abnormalEvent.objStr = ne.getNEName();
        abnormalEvent.severityStr = "Not Alarmed";
        abnormalEvent.severityLevel = evtSeverity;
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        Calendar calendar = TETL1FaultUtil.strToCalendarDateTime(data.getDbchgTimeStr(), data.getDbchgDateStr());
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        abnormalEvent.comment = TEDbchgDataEventHandle.splitCtag(data.getDbchgSEQ());
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
    }

    private static String splitCtag(String str) {
        int firstindex = str.indexOf(":");
        return str.substring(firstindex + 1, str.length());
    }

    public static void lockUnlcokNEUserEvent(TETL1DBCHGData data, int neID) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        if (ne == null) {
            return;
        }
        int eventID = -1;
        if (data.getDbchgCMDCode().equalsIgnoreCase("INH-USER-SECU")) {
            eventID = TETL1EventConstants.NEUSERLOCK;
        } else if (data.getDbchgCMDCode().equalsIgnoreCase("ALW-USER-SECU")) {
            eventID = TETL1EventConstants.NEUSERUNLOCK;
        }
        TETL1EventData eventData = TEParseEventDatasXml.getInstance().getEventData(eventID);
        if (eventData == null) {
            return;
        }
        int evtSeverity = eventData.getEvtSeverity();
        TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
        abnormalEvent.eventID = eventID;
        abnormalEvent.eventName = eventData.getEvtName();
        abnormalEvent.location = "-";
        abnormalEvent.direction = "-";
        abnormalEvent.objStr = ne.getNEName();
        abnormalEvent.severityStr = "Not Alarmed";
        abnormalEvent.severityLevel = evtSeverity;
        abnormalEvent.nodeType = ne.getNEType();
        abnormalEvent.evtType = eventData.getEvtType();
        Calendar calendar = TETL1FaultUtil.strToCalendarDateTime(data.getDbchgTimeStr(), data.getDbchgDateStr());
        abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
        if (data.getDbchgCMDCode().equalsIgnoreCase("INH-USER-SECU")) {
            abnormalEvent.comment = "Inhibit \"" + data.getDbchgParam() + "\" to log in the NE";
        } else if (data.getDbchgCMDCode().equalsIgnoreCase("ALW-USER-SECU")) {
            abnormalEvent.comment = "Allow \"" + data.getDbchgParam() + "\" to log in the NE";
        }
        TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
    }
}

