/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1.eventinterpret;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEEventBrowseMgr;
import com.huawei.nglct.nelist.model.TETL1AbNormalEvent;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventConstants;
import com.huawei.nglct.tl1.nemanager.TETL1Alarm;
import com.huawei.nglct.tl1.nemanager.TETL1AlarmKey;
import com.huawei.nglct.tl1.nemanager.TETL1FaultUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;

public class TECommonMOD2EventNoticeHandler
implements TL1NoticeHandler {
    String slotAid = "";
    String slotAidType = "";
    String eventName = "";
    String condeff = "";
    String eventDate = "";
    String eventTime = "";
    String location = "";
    String direction = "";
    String comment = "";
    String eventSN = "";
    String monval = "";
    String thlev = "";
    String temper = "";
    String aidDet = "";
    TEAlarmData almData = null;
    TETL1AlarmKey alarmKey = null;
    String alarmReason = "";
    int alarmType = 0;
    private Vector alarmList = null;

    public void handleNotice(String cmdKey, long neid, TL1Operation oper) {
        int neID = (int)neid;
        try {
            Part part = null;
            OutMsg[] output = oper.getOutMsg();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
            boolean flag = false;
            if (ne == null) {
                return;
            }
            this.alarmList = ne.getAlarmList();
            int len = output.length;
            for (int i = 0; i < len; ++i) {
                HashMap partMap = TETL1CommonUtil.getOutMsgPart(output[i]);
                part = (Part)partMap.get("AID");
                this.slotAid = part.getValue();
                this.slotAidType = oper.getMod2();
                part = (Part)partMap.get("CONDTYPE");
                if (part != null && part.getValue() != null) {
                    this.eventName = part.getValue();
                }
                if ((part = (Part)partMap.get("CONDEFF")) != null && part.getValue() != null) {
                    this.condeff = part.getValue();
                }
                if ((part = (Part)partMap.get("OCRDAT")) != null && part.getValue() != null) {
                    this.eventDate = part.getValue();
                }
                if ((part = (Part)partMap.get("OCRTM")) != null && part.getValue() != null) {
                    this.eventTime = part.getValue();
                }
                if ((part = (Part)partMap.get("LOCN")) != null && part.getValue() != null) {
                    this.location = part.getValue();
                }
                if ((part = (Part)partMap.get("DIRN")) != null && part.getValue() != null) {
                    this.direction = part.getValue();
                }
                if ((part = (Part)partMap.get("CONDDESCR")) != null && part.getValue() != null) {
                    this.comment = TETL1FaultUtil.subStringSpecial(part.getValue());
                }
                if ((part = (Part)partMap.get("AIDDET")) != null && part.getValue() != null) {
                    this.aidDet = TETL1FaultUtil.subStringSpecial(part.getValue());
                }
                if ((part = (Part)partMap.get("SN")) != null && part.getValue() != null) {
                    this.eventSN = part.getValue();
                }
                int almlocation = TETL1FaultUtil.getTL1AlarmLocation(this.location);
                int almdirection = TETL1FaultUtil.getTL1AlarmDirection(this.direction);
                this.almData = this.condeff.equals("TC") ? TETL1FaultUtil.getAlarmDataFromStatic(almlocation, almdirection, this.eventName) : TETL1FaultUtil.getAlarmDataFromStatic(this.slotAidType, almlocation, almdirection, this.eventName);
                int fbType = -1;
                if (null == this.almData) continue;
                this.alarmReason = this.almData.getAeReasion();
                this.alarmType = this.almData.getAeType();
                fbType = this.almData.getAIDType();
                if (this.condeff.equals("TC")) {
                    TETL1AbNormalEvent abnormalEvent = new TETL1AbNormalEvent();
                    int eventID = -1;
                    abnormalEvent.evtType = this.alarmType;
                    abnormalEvent.eventName = this.eventName;
                    eventID = this.eventName.equals("WKSWBK-VLAN") || this.eventName.equals("WKSWBR-VLAN") ? TETL1EventConstants.VLANSNCP : (this.eventName.indexOf("CONT-") != -1 ? TETL1EventConstants.CONTROLALARM : (this.eventName.equals("SECU-ALM") ? TETL1EventConstants.ILLEGALLOGIN : (this.eventName.equals("WKSWBK") || this.eventName.equals("WKSWPR") ? TETL1EventConstants.SNCPSWITCH : (this.eventName.equals("RMV-TO-MT") || this.eventName.equals("RST-FROM-MT") || this.eventName.equals("RMV_TO_MT_SONET") || this.eventName.equals("RST_FROM_MT_SONET") ? TETL1EventConstants.MASTATECHANGE : TETL1EventConstants.PERFORMTHREVENT))));
                    abnormalEvent.eventID = eventID;
                    abnormalEvent.location = TETL1FaultUtil.converAlarmLocation(this.location);
                    abnormalEvent.direction = TETL1FaultUtil.convertAlarmDirection(this.direction);
                    abnormalEvent.objStr = this.slotAid == null ? "" : ne.getNEName();
                    abnormalEvent.severityStr = "Not Alarmed";
                    abnormalEvent.severityLevel = 4;
                    abnormalEvent.nodeType = ne.getNEType();
                    Calendar calendar = TETL1FaultUtil.strToCalendarDateTime(this.eventTime, this.eventDate);
                    abnormalEvent.timeRiseStr = TEDateUtils.calendarToStr(calendar);
                    abnormalEvent.comment = this.parseComment(this.comment, this.slotAid, neID, this.aidDet);
                    TEEventBrowseMgr.getInstance().addTL1AbNormalEvent(neID, abnormalEvent);
                    continue;
                }
                if (this.condeff.equals("SC")) {
                    this.condeff = "NA";
                }
                TETL1Alarm alarm = new TETL1Alarm(this.slotAid, this.slotAidType, this.eventName, this.condeff, "", this.eventDate, this.eventTime, this.location, this.direction, this.eventSN, this.comment, this.alarmReason, this.alarmType, fbType, neID);
                TETL1Alarm.parseAlarmParam(alarm, neID);
                if (alarm.getAlarmSN().equals("-1")) continue;
                TETL1Alarm tmpAlm = null;
                int size2 = this.alarmList.size();
                for (int n = 0; n < size2; ++n) {
                    tmpAlm = (TETL1Alarm)this.alarmList.get(n);
                    if (!tmpAlm.getAlarmSN().equals(alarm.getAlarmSN())) continue;
                    if (alarm.getAlarmLevel().equals("CL")) {
                        this.alarmList.remove(alarm);
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.alarmList.add(alarm);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("handleNotice fail!", (Throwable)e);
        }
    }

    private String parseComment(String strDes, String fac, int neid, String aiddet) {
        StringBuffer sb = new StringBuffer();
        String[] aid = TETL1CommonUtil.parseAID(fac, neid);
        int slotNMID = TETL1CommonUtil.getNMSlotStr(fac, neid);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
        String showslotID = TETL1CommonUtil.getShelfSlotName(neid, slotNMID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        sb.append("Slot: ");
        sb.append(showslotID);
        sb.append("-");
        sb.append(boardName);
        sb.append(",");
        int portID = Integer.parseInt(aid[3]);
        int pathID = Integer.parseInt(aid[4]);
        if (portID != -1) {
            String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
            sb.append("Port: ");
            sb.append(portName);
            sb.append(",");
        }
        if (pathID != -1) {
            sb.append("Path: ");
            sb.append(pathID);
            sb.append(",");
        }
        sb.append("Comment: ");
        sb.append(strDes);
        if (!aiddet.equals("")) {
            sb.append(",");
            sb.append(aiddet);
        }
        return sb.toString();
    }
}

