/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1LogUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class TETL1NEExplorerBean
implements TENEMgrInterface {
    protected int TIME_OUT = 60;
    protected Datainterface outputData = null;
    protected ArrayList tl1OperList = null;
    protected int neid;
    protected SubFunc subfunc = null;
    protected Datainterface inputData = null;
    protected boolean msgBlockFlag = true;
    protected ArrayList cloneTL1OperationList = new ArrayList();
    protected TEAIDAndTypeList aidAndTypeList = null;
    protected HashSet slotIDList = null;
    protected boolean bQueryAidAndType = false;
    public static final String REMOVE_COMMAND = "RMV";
    public static final String RESTORE_COMMAND = "RST";
    public static final String OPR_LPBK_CMMAND = "OPR-LPBK";
    public static final String RLS_LPBK_CMMAND = "RLS-LPBK";
    protected TL1Operation curTL1Operation = null;
    protected String curUser;
    protected String curIpAddress;
    private static TESysManagerBean sysManager = TESysManagerBean.getInstance();
    protected int neType = -1;
    private static final int LOGMAXLENGTH = 255;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.curUser = user;
            this.curIpAddress = ipAddress;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neid);
            this.neType = ne.getNEType();
            if (this.bQueryAidAndType) {
                this.slotIDList = this.getSlotIDFromInputDdata(inputData);
                if (!this.slotIDList.isEmpty()) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType(neid, this.slotIDList);
                    if (this.aidAndTypeList == null) {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
                        return this.outputData;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        this.addRTRVPORTError(neid, ne);
                        return this.outputData;
                    }
                }
            }
            this.tl1OperList = this.getTL1Operation(neid, subFunc, inputData, memeryData);
            if (null == this.tl1OperList || this.tl1OperList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                return this.outputData;
            }
            int result = this.sendMessage(neid, this.tl1OperList);
            if (result == 0) {
                this.handleMessage(neid, this.tl1OperList, subFunc, this.getFilterErrorCodeList());
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
            }
            this.printLog();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NEExplorerBean.performBussinessProcess() fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected void addRTRVPORTError(int neid, TENE ne) {
        Object[] slotIDArr = this.slotIDList.toArray();
        int slotID = (Integer)slotIDArr[0];
        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        RowErrors errorRowparams = new RowErrors();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        errorRowparams.setErrorMessage(errorMessage);
        errorparam = new Param("nename", ne.getNEName());
        errorRowparams.addParam(errorparam);
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(errorRowparams);
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.getBussinessParams().addRowParams(rowparams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
    }

    protected void addRTRVPORTError(int neid, TETL1NE ne, Datainterface tempOutput) {
        Object[] slotIDArr = this.slotIDList.toArray();
        int slotID = (Integer)slotIDArr[0];
        Fault fault = this.aidAndTypeList.getFaultInfo(slotID);
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        RowErrors errorRowparams = new RowErrors();
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        errorRowparams.setErrorMessage(errorMessage);
        errorparam = new Param("nename", ne.getNEName());
        errorRowparams.addParam(errorparam);
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(errorRowparams);
        tempOutput.setBussinessParams(new BussinessParams());
        tempOutput.getBussinessParams().addRowParams(rowparams);
        tempOutput.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
    }

    protected void printLog() {
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.curUser, this.curIpAddress, this.cloneTL1OperationList);
        }
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            return this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    protected HashSet getSlotIDFromInputDdata(Datainterface inputData) {
        HashSet<Integer> set = new HashSet<Integer>();
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            Param tmpParam = rowparams.getParam("slotid");
            if (tmpParam == null) continue;
            try {
                int slotID = Integer.parseInt(tmpParam.getValue());
                set.add(slotID);
                continue;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("getSlotIDFromInputDdata fail!", (Throwable)e);
            }
        }
        return set;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                String tl1Mod2 = TETL1CommonUtil.getTL1CmdMod2(subfunc.getQxMapping(i).getContent());
                tl1List.add(tl1Mod2);
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = TECreateObjectFactory.getTL1Operation(this.neid, (String)tl1List.get(i));
                if (null == tl1Operation) continue;
                this.changeMod2(tl1Operation, rowparams);
                this.curTL1Operation = tl1Operation;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    public ArrayList convertToTL1Operation(TETL1GenCfgFunAttr funAttr, Datainterface inputData, TL1Definitions definitions, TEAIDAndTypeList aidAndTypeList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> operationNameList = new ArrayList<String>();
        String operationName = funAttr.getTl1cmdcode();
        String modName = funAttr.getMod();
        operationNameList.add(modName);
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            if (this.isFilterParam(rowparams, funAttr)) continue;
            int size = operationNameList.size();
            for (int i = 0; i < size; ++i) {
                int neid;
                String str = (String)operationNameList.get(i);
                if (str.equals("mod2")) {
                    if (!funAttr.getObjectType().equals("ID_OBJECT_TYPE_NE_BOARD")) {
                        if (null != rowparams.getParam("specmode2")) {
                            String mode2 = rowparams.getParam("specmode2").getValue();
                            operationName = this.changeOperationName(operationName, rowparams);
                            str = operationName + "-" + mode2;
                        } else if (null != rowparams.getParam("DWDMTL1_ATTRPORT_BOARD_PST") || null != rowparams.getParam("DWDMTL1_ATTRPORT_BOARD_SST")) {
                            str = operationName + "-" + "EQPT";
                        } else if (null != rowparams.getParam("mode2")) {
                            Param tmpAdvanceParam;
                            String mode2Str = rowparams.getParam("mode2").getValue();
                            String mode2 = "";
                            mode2 = this.parseMode2Str(mode2Str = this.modifyMod2ColumnValue(mode2Str, funAttr.getAttrId()), funAttr.getAttrId());
                            if (mode2.equals("") && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_LOOPBACK")) {
                                mode2 = this.parseMode2Str(mode2Str, "DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK");
                                if (rowparams.getParam("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") != null && rowparams.getParam("DWDMTL1_ATTRPORT_LOOPBACK") != null) {
                                    tmpAdvanceParam = rowparams.getParam("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK");
                                    tmpAdvanceParam.setValue(rowparams.getParam("DWDMTL1_ATTRPORT_LOOPBACK").getValue());
                                }
                            }
                            if (mode2.equals("") && funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_SVTIMER")) {
                                mode2 = this.parseMode2Str(mode2Str, "DWDMTL1_ATTRPORT_ADVANCED_SVTIMER");
                                if (rowparams.getParam("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER") != null && rowparams.getParam("DWDMTL1_ATTRPORT_SVTIMER") != null) {
                                    tmpAdvanceParam = rowparams.getParam("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER");
                                    tmpAdvanceParam.setValue(rowparams.getParam("DWDMTL1_ATTRPORT_SVTIMER").getValue());
                                }
                            }
                            operationName = this.changeOperationName(operationName, rowparams);
                            str = operationName + "-" + mode2;
                            str = this.getExtendOperName(str, rowparams);
                        } else if (null != rowparams.getParam("slotid")) {
                            int pathid = -1;
                            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                            int portid = Integer.parseInt(rowparams.getParam("port").getValue());
                            neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                            int grade = 0;
                            if (rowparams.getParam("grade") != null && !"".equals(rowparams.getParam("grade").getValue())) {
                                grade = Integer.parseInt(rowparams.getParam("grade").getValue());
                            }
                            String mod2 = "";
                            if (null != rowparams.getParam("path")) {
                                pathid = Integer.parseInt(rowparams.getParam("path").getValue());
                            }
                            String tempMod2 = "";
                            if (rowparams.getParam("SETMODE2") != null) {
                                tempMod2 = rowparams.getParam("SETMODE2").getValue();
                            }
                            mod2 = !tempMod2.equals("") ? tempMod2 : (funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER") ? this.getMod2(neid, slotid, portid, pathid, funAttr.getAttrId(), grade) : this.getMod2(neid, slotid, portid, pathid, funAttr.getAttrId()));
                            str = operationName + "-" + mod2;
                            str = this.getExtendOperName(str, rowparams);
                        }
                    }
                } else {
                    if (operationName.equals("RTRV") && !str.equals("EQPT")) {
                        String strTemp;
                        int pathid = -1;
                        int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                        int portid = Integer.parseInt(rowparams.getParam("port").getValue());
                        neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                        String mod2 = "";
                        if (null != rowparams.getParam("path")) {
                            pathid = Integer.parseInt(rowparams.getParam("path").getValue());
                        }
                        if ((mod2 = this.getMod2(neid, slotid, portid, pathid, funAttr.getAttrId())).equals("NA") || funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_CLIENTPRO") && mod2.equals("UNKNOWN") || funAttr.getAttrId().equals("DWDMTL1_ATTRPORT_LPTENABLE") && (mod2.equals("EC") || mod2.equals("UNEQ"))) continue;
                        if (str.equals("CLNT") && null != (operation = definitions.getTL1Operation(strTemp = operationName + "-" + mod2))) {
                            inputMsg = operation.getInMsg();
                            if (null == inputMsg) {
                                operationList.add(operation);
                                continue;
                            }
                            fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), aidAndTypeList);
                            if (fillComplete && this.isFillMsgBlock(operationName, rowparams, inputMsg.getMsgBlock())) {
                                fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                            }
                            if (fillComplete) {
                                operationList.add(operation);
                            }
                        }
                    }
                    if (!str.equals("CLNT") && !str.equals("EQPT") && !str.equals("LPT") && !str.equals("CLIENT") && !str.equals("OSNREN") && !this.existDynPort(rowparams, funAttr)) continue;
                    str = operationName + "-" + str;
                }
                String strCmd = this.getTL1Cmd(str);
                String realMod2 = this.getRealMod2(str);
                str = this.neType == 66 && realMod2.equals("ANY") ? operationName + "-" + "ANY" : operationName + "-" + strCmd;
                operation = definitions.getTL1Operation(str);
                if (null == operation) {
                    try {
                        int neid2 = Integer.parseInt(rowparams.getParam("neid").getValue());
                        operation = TECreateObjectFactory.getTL1Operation(neid2, str);
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("", (Throwable)e);
                    }
                }
                if (null == operation) continue;
                if (this.neType != 66 && this.isNotSupportSST(strCmd)) {
                    this.removeSSTPart(operation);
                }
                TETL1CommonUtil.modifyMOD2(operation, realMod2);
                inputMsg = operation.getInMsg();
                if (null == inputMsg) {
                    operationList.add(operation);
                    continue;
                }
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock(), aidAndTypeList);
                if (fillComplete && this.isFillMsgBlock(operationName, rowparams, inputMsg.getMsgBlock())) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!fillComplete) continue;
                operationList.add(operation);
            }
        }
        return operationList;
    }

    private void removeSSTPart(TL1Operation operation) {
        try {
            if (operation.getInMsg() != null && operation.getInMsg().getPart("SST") != null) {
                int count = operation.getInMsg().getMsgBlock().getDataBlockCount();
                block2: for (int i = 0; i < count; ++i) {
                    int partCount = operation.getInMsg().getMsgBlock().getDataBlock(i).getPartCount();
                    for (int j = 0; j < partCount; ++j) {
                        Part part = operation.getInMsg().getMsgBlock().getDataBlock(i).getPart(j);
                        if (!part.getName().equalsIgnoreCase("SST")) continue;
                        operation.getInMsg().getMsgBlock().getDataBlock(i).removePart(part);
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("removeSSTPart fail!", (Throwable)e);
        }
    }

    private boolean isNotSupportSST(String strCmd) {
        return strCmd.indexOf("OCN") != -1 || strCmd.indexOf("FCMOD2") != -1 || strCmd.indexOf("TRAFFICMOD2") != -1;
    }

    private boolean existDynPort(RowParams rowparams, TETL1GenCfgFunAttr funAttr) {
        int pathid = -1;
        try {
            String mod2;
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int portid = Integer.parseInt(rowparams.getParam("port").getValue());
            int neid = Integer.parseInt(rowparams.getParam("neid").getValue());
            if (null != rowparams.getParam("path")) {
                pathid = Integer.parseInt(rowparams.getParam("path").getValue());
            }
            return !(mod2 = this.getMod2(neid, slotid, portid, pathid, funAttr.getAttrId())).equals("UNEQ") && !mod2.equals("NA");
        }
        catch (Exception ex) {
            return true;
        }
    }

    protected String getRealMod2(String str) {
        String[] cmdBlock = str.split("-");
        String mod2 = cmdBlock[cmdBlock.length - 1];
        String[] cmdMod2 = mod2.split("&&");
        return cmdMod2[cmdMod2.length - 1];
    }

    protected String getTL1Cmd(String str) {
        String[] cmdBlock = str.split("-");
        String mod2 = cmdBlock[cmdBlock.length - 1];
        String[] cmdMod2 = mod2.split("&&");
        return cmdMod2[0];
    }

    public boolean isFillMsgBlock(String operationName, RowParams rowparams, MsgBlock msgBlock) {
        return true;
    }

    public String changeOperationName(String operationName, RowParams rowparams) {
        return operationName;
    }

    public String getExtendOperName(String name, RowParams rowparams) {
        return name;
    }

    protected String modifyMod2ColumnValue(String cellValue, String attribute) {
        return cellValue;
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID, int grade) {
        return "";
    }

    protected String getMod2(int neid, int slotid, int portid, int pathid, String attrID) {
        String mod2 = "";
        mod2 = pathid > 0 ? this.aidAndTypeList.getMod2(neid, slotid, portid, pathid) : this.aidAndTypeList.getMod2(neid, slotid, portid);
        return mod2;
    }

    protected boolean isFilterParam(RowParams rowparams, TETL1GenCfgFunAttr funAttr) {
        return false;
    }

    public boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock, TEAIDAndTypeList aidAndTypeList) {
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            int slotid = -1;
            int portid = -1;
            int neid = -1;
            int pathid = -1;
            String aid = "";
            if (null != rowparams.getParam("mode2") && !rowparams.getParam("mode2").getValue().equals("SUPPORTAINS")) {
                String mode2Str = rowparams.getParam("mode2").getValue();
                aid = this.parseMode2Str(mode2Str, "AID");
            } else if (null != rowparams.getParam("srcObjType") && rowparams.getParam("srcObjType").getValue().equals("ID_OBJECT_TYPE_NE_BOARD")) {
                slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                StringBuffer tmp = new StringBuffer();
                tmp.append("SLOT");
                String shelf_slot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotid);
                tmp.append('-').append(shelf_slot);
                aid = tmp.toString();
            } else if (null != rowparams.getParam("BOARD_PST") || null != rowparams.getParam("BOARD_SST")) {
                slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                aid = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(this.neid, slotid);
                aid = "SLOT-" + aid;
            } else if (null != rowparams.getParam("slotid")) {
                if (null == rowparams.getParam("port")) {
                    slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                    aid = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(this.neid, slotid);
                    aid = "SLOT-" + aid;
                } else {
                    slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                    portid = Integer.parseInt(rowparams.getParam("port").getValue());
                    neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                    aid = null != rowparams.getParam("path") ? ((pathid = Integer.parseInt(rowparams.getParam("path").getValue())) <= 0 ? aidAndTypeList.getAID(neid, slotid, portid) : aidAndTypeList.getAID(neid, slotid, portid, pathid)) : aidAndTypeList.getAID(neid, slotid, portid);
                    int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    if ((bdtype == 60016 || bdtype == 60017 || bdtype == 2355) && pathid > 0) {
                        String tempaid = aid.substring(0, aid.lastIndexOf("-"));
                        aid = tempaid + "-" + "ALL";
                    }
                }
            } else if (null != rowparams.getParam("FACAID")) {
                aid = rowparams.getParam("FACAID").getValue();
            }
            part.setValue(aid);
        }
        return null != part && !part.getValue().equals("");
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (this.convertPartValue(part, rowparams)) continue;
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tmpParam = rowparams.getParam(part.getName());
        if (tmpParam == null) {
            tmpParam = TETL1CommonUtil.getParam(rowparams.getParam(), part.getConvert());
        }
        if (tmpParam != null && !tmpParam.getModifyFlag()) {
            return false;
        }
        if (null != tmpParam) {
            part.setValue(tmpParam.getValue());
        } else {
            flag = false;
        }
        return flag;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (!this.convertPartValue(part, rowparams)) {
                    if (null == part.getDefault() || part.getDefault().isEmpty()) continue;
                    part.setValue(part.getDefault());
                    ++num;
                    continue;
                }
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }

    public int sendMessage(int neid, ArrayList tl1OperList) {
        int retCode = 0;
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)tl1OperList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public ArrayList getFilterErrorCodeList() {
        return null;
    }

    public void handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, tl1OperList, filterErrorCodeList);
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = 0;
        if (tl1OperList != null) {
            tl1OperSize = tl1OperList.size();
        }
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        if (null == tl1OperList || tl1OperList.isEmpty()) {
            if (null == errorData || errorData.isEmpty()) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else if (errorData.size() >= tl1OperSize) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
            } else {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
            }
            return outputData;
        }
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                rowparams = new RowParams();
                output = tl1Operation.getOutMsg(row);
                if (!this.handleRowData(neid, subfunc, rowparams, input, output)) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (!errorData.isEmpty()) {
            rowparams = new RowParams();
            int sizei = errorData.size();
            for (int ii = 0; ii < sizei; ++ii) {
                rowparams.addRowErrors((RowErrors)errorData.get(ii));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (errorData.isEmpty()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        Part tmpPart = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart(output);
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Param param = null;
        ArrayList<Param> paramList = new ArrayList<Param>();
        Param newParam = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            if (null != input) {
                tmpPart = input.getPart(param.getName());
            }
            if (null != tmpPart) {
                param.setValue(tmpPart.getValue());
            }
            if ((newParam = this.convertParamValue(param, partmap)) == null) continue;
            paramList.add(newParam);
        }
        int len2 = paramList.size();
        if (len2 != 0) {
            for (int j = 0; j < len2; ++j) {
                rowparams.addParam((Param)paramList.get(j));
            }
        } else {
            return false;
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
        return true;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        return false;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap) {
        Param param = null;
        Part part = (Part)partmap.get(oldParam.getName());
        if (part == null) {
            part = TETL1CommonUtil.getPart(partmap.values(), oldParam.getName());
        }
        if (part != null && part.getValue() != null) {
            param = (Param)oldParam.clone();
            param.setValue(part.getValue());
        }
        if (part == null || part.getValue() == null) {
            param = (Param)oldParam.clone();
            param.setValue("");
        }
        return param;
    }

    public ArrayList joinTL1Operation(int neid, SubFunc subfunc, ArrayList tl1OperationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList tl1OperObject = TETL1DataConverter.getTL1OperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        TL1Operation tl1Oper = null;
        TL1Operation tmpTL1Oper = null;
        OutMsg curOutput = null;
        OutMsg tmpOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || tl1OperationList.isEmpty()) {
            return errorDataList;
        }
        this.cloneTL1OperationList.clear();
        for (int i = tl1OperationList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i);
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = String.valueOf(curOutput.getFault().getCompletionCode());
                if (!"0".equals(errorCode)) {
                    tl1Oper.addCmdFault(curOutput.getFault());
                }
                if (filterErrorCodeList.contains(curOutput.getFault().getErrDesc())) {
                    tl1Oper.removeOutMsg(curOutput);
                    continue;
                }
                if ("0".equals(errorCode)) continue;
                errorDataList.add(0, this.handleErrorData(neid, subfunc, tl1Oper, curOutput));
                tl1Oper.removeOutMsg(curOutput);
            }
            this.cloneTL1OperationList.add(tl1Oper.clone());
            if (tl1Oper.getOutMsgCount() != 0) continue;
            tl1OperationList.remove(i);
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        if (null != tl1OperObject && !tl1OperObject.isEmpty()) {
            for (int i = 0; i < operSize; ++i) {
                tl1Oper = (TL1Operation)tl1OperationList.get(i);
                TETL1DataConverter.copyInDataToOutData(tl1Oper);
                int ouputlen = tl1Oper.getOutMsgCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = tl1Oper.getOutMsg(outputIndex);
                    operObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tl1Oper.getInMsg(), curOutput);
                    for (int j = i + 1; j < operSize; ++j) {
                        tmpTL1Oper = (TL1Operation)tl1OperationList.get(j);
                        TETL1DataConverter.copyInDataToOutData(tmpTL1Oper);
                        for (int tmpOutputIndex = tmpTL1Oper.getOutMsgCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpTL1Oper.getOutMsg(tmpOutputIndex);
                            tmpoperObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tmpTL1Oper.getInMsg(), tmpOutput);
                            if (!TETL1DataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                            TETL1DataConverter.joinTL1OperationOutput(curOutput, tmpOutput);
                            tmpTL1Oper.removeOutMsg(tmpOutput);
                        }
                        if (0 != tmpTL1Oper.getOutMsgCount()) continue;
                        tl1OperationList.remove(tmpTL1Oper);
                        --operSize;
                        --j;
                    }
                }
            }
        }
        return errorDataList;
    }

    public void writeLog(int neid, SubFunc subfunc, String user, String ipAddress, ArrayList tl1OperList) {
        try {
            String operSuccess = TEErrorResourceUtil.getErrCodeResWithDot(0);
            String operPartSuccess = TEErrorResourceUtil.getErrCodeResWithDot(1);
            String operFailSuccess = TEErrorResourceUtil.getErrCodeResWithDot(2);
            DeploymentMode runningStatus = sysManager.getSysStauts();
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int len = tl1OperList.size();
            for (int i = 0; i < len; ++i) {
                loginfo = new TELogInfo();
                TL1Operation tl1Oper = (TL1Operation)tl1OperList.get(i);
                ArrayList faultList = tl1Oper.getCmdFaultList();
                boolean hasSuccess = false;
                boolean hasFail = false;
                StringBuilder errInfo = new StringBuilder("");
                int size = faultList.size();
                for (int j = 0; j < size; ++j) {
                    Fault fault = (Fault)faultList.get(j);
                    if (fault.getCompletionCode() != 0) {
                        hasFail = true;
                        if ("".equals(errInfo.toString())) {
                            errInfo.append(TETL1CommonUtil.getOperationResult(fault));
                            continue;
                        }
                        errInfo.append("\n").append(TETL1CommonUtil.getOperationResult(fault));
                        continue;
                    }
                    hasSuccess = true;
                }
                String operateDesc = tl1Oper.getCmdDetail();
                if (TETL1LogUtil.getFilterCmdSet().contains(tl1Oper.getName())) {
                    operateDesc = tl1Oper.getName();
                }
                if (!hasFail) {
                    loginfo.setErrCode(0);
                    loginfo.setResult(0);
                    loginfo.setOperateResult(operSuccess);
                    loginfo.setErrInfo(operSuccess);
                    loginfo.setOperateDesc(operateDesc);
                } else if (hasSuccess) {
                    loginfo.setErrCode(1);
                    loginfo.setResult(1);
                    loginfo.setOperateResult(operPartSuccess);
                    loginfo.setErrInfo(errInfo.toString());
                    loginfo.setOperateDesc(operateDesc);
                } else {
                    loginfo.setErrCode(1107329312);
                    loginfo.setResult(2);
                    loginfo.setOperateResult(operFailSuccess);
                    loginfo.setErrInfo(errInfo.toString());
                    loginfo.setOperateDesc(operateDesc + "Result Desc:" + loginfo.getErrInfo());
                }
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(operateName);
                loginfo.setOperateObject(operObj);
                String operDesc = loginfo.getOperateDesc();
                if (TESysManagerConstants.SYS_SINGLE_STATUS != runningStatus && operDesc.length() > 255) {
                    String temp;
                    do {
                        temp = operDesc;
                        String firstLog = temp.substring(0, 255);
                        loginfo.setOperateDesc(firstLog);
                        loginfoList.add(loginfo);
                    } while ((operDesc = temp.substring(255, temp.length())).length() > 255);
                }
                loginfo.setOperateDesc(operDesc);
                loginfoList.add(loginfo);
            }
            TELogMgr.writeLog(loginfoList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean isNeedOperationlog() {
        return true;
    }

    public int getTimeOut() {
        return this.TIME_OUT;
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        OperObject operObj = this.subfunc.getOperObject();
        if (null == operObj) {
            return 0;
        }
        RowErrors rowErrors = null;
        Param tmpParam1 = null;
        Param tmpParam2 = null;
        boolean succFlag = false;
        int errorCount = errorRowParams.getRowErrorsCount();
        for (int index = 0; index < errorCount; ++index) {
            rowErrors = errorRowParams.getRowErrors(index);
            succFlag = false;
            int size = operObj.getParamCount();
            for (int i = 0; i < size; ++i) {
                tmpParam1 = rowparams.getParam(operObj.getParam(i).getName());
                tmpParam2 = rowErrors.getParam(operObj.getParam(i).getName());
                if (tmpParam1 == null || tmpParam2 == null || tmpParam1.getValue().equals(tmpParam2.getValue())) continue;
                succFlag = true;
                break;
            }
            if (succFlag) continue;
            return Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
        }
        return 0;
    }

    protected boolean isMsgBlockFlag() {
        return this.msgBlockFlag;
    }

    protected void setMsgBlockFlag(boolean msgBlockFlag) {
        this.msgBlockFlag = msgBlockFlag;
    }

    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        MsgBlock outputBlock1;
        int j;
        int size;
        int i;
        int len;
        ArrayList operObjct = this.getTL1OperationObject(subfunc);
        InMsg input = oper.getInMsg();
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError_co1 = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError_co1.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError_co1.addParam(errorparam);
        DataBlock dataBlock = null;
        if (null != input) {
            AID aid = input.getStagBlock().getAID();
            len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                errorparam = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                rowError_co1.addParam(errorparam);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    String partName = dataBlock.getPart(j).getConvert();
                    if (partName == null || partName.equals("")) {
                        partName = dataBlock.getPart(j).getName();
                    }
                    if ((errorparam = new Param(partName, dataBlock.getPart(j).getValue())).getValue() != null) {
                        rowError_co1.addParam(errorparam);
                    }
                    if (operObjct.contains(errorparam.getName()) || errorparam.getValue() == null) continue;
                    errorparam = new Param("attrId", partName);
                    rowError_co1.addParam(errorparam);
                }
            }
        }
        if ((outputBlock1 = output.getMsgBlock()) != null) {
            len = outputBlock1.getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = output.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    errorparam = new Param("attrId", dataBlock.getPart(j).getName());
                    if (null != rowError_co1.getParam(dataBlock.getPart(j).getName())) continue;
                    rowError_co1.addParam(errorparam);
                }
            }
        }
        this.addErrorParam(neid, rowError_co1);
        return rowError_co1;
    }

    public void addErrorParam(int neid, RowErrors rowError1) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param1 = null;
        int shelfID1 = 0;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null != rowError1.getParam("neid") && null == rowError1.getParam("nename")) {
            param1 = new Param("nename", neObj.getNEName());
            rowError1.addParam(param1);
        }
        if (null != rowError1.getParam("AID")) {
            try {
                String[] aid = TETL1CommonUtil.parseAID(rowError1.getParam("AID").getValue(), neid);
                shelfID1 = Integer.parseInt(aid[1]);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (shelfID1 != -1) {
                param1 = new Param("subrackID", "Subrack" + shelfID1);
                rowError1.addParam(param1);
            }
            try {
                slotid = TETL1CommonUtil.getNMSlotStr(rowError1.getParam("AID").getValue(), neid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (slotid != -1) {
                if (null != rowError1.getParam("boardtype")) {
                    try {
                        boardtype = Integer.parseInt(rowError1.getParam("boardtype").getValue());
                    }
                    catch (NumberFormatException e) {
                        boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                        rowError1.getParam("boardtype").setValue(boardtype + "");
                    }
                } else {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    param1 = new Param("boardtype", boardtype + "");
                    rowError1.addParam(param1);
                }
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                if (boardName.indexOf("UNKNOWN") == -1) {
                    String showSlot = TETL1CommonUtil.getShelfSlotName(neid, slotid);
                    param1 = new Param("boardname", showSlot + "-" + boardName);
                }
                rowError1.addParam(param1);
            }
            try {
                String aidvar = rowError1.getParam("AID").getValue();
                String[] str = TETL1CommonUtil.parseAID(aidvar, neid);
                port = str.length > 3 && !str[3].equals("ALL") ? TETL1CommonUtil.getNMPortNOFromAidStruct(aidvar, neid) : -1;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (port != -1) {
                param1 = new Param("portid", String.valueOf(port));
                rowError1.addParam(param1);
                String[] str = TETL1CommonUtil.parseAID(rowError1.getParam("AID").getValue(), neid);
                if (str[3].equalsIgnoreCase("ALL")) {
                    return;
                }
                String portName = TETL1CommonUtil.getPortNameFromNEPort(str[0], slotid, Integer.parseInt(str[3]), neid);
                param1 = new Param("portname", portName);
                rowError1.addParam(param1);
                param1 = new Param("pathid", str[4]);
                rowError1.addParam(param1);
            }
        }
    }

    public ArrayList getTL1OperationObject(SubFunc subfunc) {
        ArrayList<String> list = new ArrayList<String>();
        OperObject operObj = subfunc.getOperObject();
        if (null == operObj) {
            return list;
        }
        for (int i = 0; i < operObj.getParamCount(); ++i) {
            list.add(operObj.getParam(i).getName().toLowerCase());
        }
        return list;
    }

    public String parseMode2Str(String mode2Str, String attrID) {
        String[] str = mode2Str.split(",");
        if (str.length == 1) {
            return mode2Str;
        }
        int size = str.length - 1;
        for (int i = 0; i < size; ++i) {
            if (!str[i].equals(attrID)) continue;
            return str[i + 1];
        }
        return "";
    }
}

