/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.cbb.log.TETL1OperateLogInfo;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class TETL1LogUtil {
    public static Set<String> getFilterCmdSet() {
        HashSet<String> filterCmdSet = new HashSet<String>();
        filterCmdSet.add("ACT-USER-EMS");
        filterCmdSet.add("ENT-NTP-AUTHPARA");
        filterCmdSet.add("ENT-USER-SECU");
        filterCmdSet.add("ED-USER-SECU");
        filterCmdSet.add("ED-SNMP-TRAPINFO");
        filterCmdSet.add("ENT-SNMP-TRAPINFO");
        filterCmdSet.add("RTRV-SNMP-TRAPINFO");
        return filterCmdSet;
    }

    public static void writeLog(int neid, SubFunc subfunc, String operateDesc, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TETL1OperateLogInfo> loginfoList = new ArrayList<TETL1OperateLogInfo>();
            TETL1OperateLogInfo loginfo = new TETL1OperateLogInfo();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                loginfo.setUserID(userID);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject("");
            loginfo.setOperateDesc(operateDesc);
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                loginfo.setOperateObject(String.valueOf(neid));
            } else {
                loginfo.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            } else if (errorCode == 2 || errorCode == 1) {
                loginfo.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginfo.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginfo.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginfo);
                    break;
                }
            } else {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

