/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TETL1DataConverter {
    public static ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions) {
        return TETL1DataConverter.convertToTL1Operation(subfunc, inputData, tl1Definitions, null);
    }

    public static ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                tl1List.add(subfunc.getQxMapping(i).getContent());
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                fillComplete = TETL1DataConverter.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = TETL1DataConverter.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    private static boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        Param tmpParam = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            tmpParam = rowparams.getParam(part.getName());
            if (null != tmpParam) {
                part.setValue(tmpParam.getValue());
                continue;
            }
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    private static boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        Param tmpParam = null;
        boolean modifyFlag = false;
        int len = msgBlock.getDataBlockCount();
        block0: for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                tmpParam = rowparams.getParam(part.getName());
                modifyFlag = false;
                if (tmpParam != null && tmpParam.getModifyFlag()) {
                    modifyFlag = true;
                }
                if (!modifyFlag) continue;
                if (null != tmpParam) {
                    part.setValue(tmpParam.getValue());
                    continue;
                }
                if (null != part.getDefault()) {
                    part.setValue(part.getDefault());
                    continue;
                }
                flag = false;
                continue block0;
            }
        }
        return flag;
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = TETL1DataConverter.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        if (0 == tl1OperList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        InMsg input = null;
        OutMsg output = null;
        outputData.setBussinessParams(new BussinessParams());
        int len = tl1OperList.size();
        for (i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                rowparams = new RowParams();
                TETL1DataConverter.handleRowData(neid, subfunc, rowparams, input, output);
                if (0 == rowparams.getParamCount()) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (0 != errorData.size()) {
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    public static void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        String tmpValue = "";
        String tmpName = "";
        Part tmpPart = null;
        Param param = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            if (null != input) {
                tmpPart = input.getPart(param.getName());
            }
            if (null != tmpPart) {
                param.setValue(tmpPart.getValue());
            }
            DataBlock dataBlock = null;
            block1: for (int tmpCol = output.getMsgBlock().getDataBlockCount() - 1; tmpCol >= 0; --tmpCol) {
                dataBlock = output.getMsgBlock().getDataBlock(tmpCol);
                for (int index = dataBlock.getPartCount() - 1; index >= 0; --index) {
                    tmpName = dataBlock.getPart(index).getName();
                    if (!tmpName.equalsIgnoreCase(param.getName())) continue;
                    tmpValue = dataBlock.getPart(index).getValue();
                    if (null != tmpValue) {
                        param.setValue(tmpValue);
                    }
                    dataBlock.removePart(dataBlock.getPart(index));
                    continue block1;
                }
            }
            rowparams.addParam(param);
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
    }

    public static ArrayList joinTL1Operation(int neid, SubFunc subfunc, ArrayList tl1OperationList, ArrayList filterErrorCodeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList tl1OperObject = TETL1DataConverter.getTL1OperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        TL1Operation descTL1Oper = null;
        TL1Operation tl1Oper = null;
        TL1Operation tmpTL1Oper = null;
        OutMsg curOutput = null;
        OutMsg tmpOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || 0 == tl1OperationList.size()) {
            return errorDataList;
        }
        for (int i2 = tl1OperationList.size() - 1; i2 >= 0; --i2) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i2);
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = curOutput.getFault().getErrCode();
                if (filterErrorCodeList.contains(errorCode)) {
                    tl1Oper.removeOutMsg(curOutput);
                    continue;
                }
                if ("".equals(errorCode)) continue;
                errorDataList.add(0, TETL1DataConverter.handleErrorData(neid, subfunc, tl1Oper.getInMsg(), curOutput));
                tl1Oper.removeOutMsg(curOutput);
            }
            if (tl1Oper.getOutMsgCount() != 0) continue;
            tl1OperationList.remove(i2);
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        if (null != tl1OperObject && 0 != tl1OperObject.size()) {
            for (i = 0; i < operSize; ++i) {
                tl1Oper = (TL1Operation)tl1OperationList.get(i);
                TETL1DataConverter.copyInDataToOutData(tl1Oper);
                int ouputlen = tl1Oper.getOutMsgCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = tl1Oper.getOutMsg(outputIndex);
                    operObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tl1Oper.getInMsg(), curOutput);
                    for (int j = i + 1; j < operSize; ++j) {
                        tmpTL1Oper = (TL1Operation)tl1OperationList.get(j);
                        TETL1DataConverter.copyInDataToOutData(tmpTL1Oper);
                        for (int tmpOutputIndex = tmpTL1Oper.getOutMsgCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpTL1Oper.getOutMsg(tmpOutputIndex);
                            tmpoperObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tmpTL1Oper.getInMsg(), tmpOutput);
                            if (!TETL1DataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                            TETL1DataConverter.joinTL1OperationOutput(curOutput, tmpOutput);
                            tmpTL1Oper.removeOutMsg(tmpOutput);
                        }
                        if (0 != tmpTL1Oper.getOutMsgCount()) continue;
                        tl1OperationList.remove(tmpTL1Oper);
                        --operSize;
                        --j;
                    }
                }
            }
        } else {
            descTL1Oper = (TL1Operation)tl1OperationList.get(0);
            for (i = tl1OperationList.size() - 1; i > 0; --i) {
                tmpTL1Oper = (TL1Operation)tl1OperationList.get(i);
                int size = descTL1Oper.getOutMsgCount();
                for (int j = 0; j < size; ++j) {
                    curOutput = descTL1Oper.getOutMsg(j);
                    int tmpSize = tmpTL1Oper.getOutMsgCount();
                    for (int k = 0; k < tmpSize; ++k) {
                        tmpOutput = tmpTL1Oper.getOutMsg(k);
                        TETL1DataConverter.joinTL1OperationOutput(curOutput, tmpOutput);
                    }
                }
                tl1OperationList.remove(tmpTL1Oper);
            }
        }
        return errorDataList;
    }

    public static boolean compareOperObj(ArrayList operObj, ArrayList otherOperObj) {
        Part part = null;
        Part otherPart = null;
        boolean flag = true;
        if (null != operObj && null != otherOperObj) {
            int size = operObj.size();
            for (int i = 0; i < size; ++i) {
                part = (Part)operObj.get(i);
                int len = otherOperObj.size();
                for (int j = 0; j < len; ++j) {
                    otherPart = (Part)otherOperObj.get(j);
                    if (!part.getName().equalsIgnoreCase(otherPart.getName()) || part.getValue().equals(otherPart.getValue())) continue;
                    return false;
                }
            }
        }
        return flag;
    }

    public static boolean compareGencfgOperObj(ArrayList operObj, ArrayList otherOperObj) {
        Part part = null;
        Part otherPart = null;
        boolean flag = true;
        if (null != operObj && null != otherOperObj) {
            if (operObj.size() == otherOperObj.size()) {
                int size = operObj.size();
                for (int i = 0; i < size; ++i) {
                    part = (Part)operObj.get(i);
                    int len = otherOperObj.size();
                    for (int j = 0; j < len; ++j) {
                        String otherValue;
                        String value;
                        otherPart = (Part)otherOperObj.get(j);
                        if (!part.getName().equalsIgnoreCase(otherPart.getName()) || (value = part.getValue()).equals(otherValue = otherPart.getValue())) continue;
                        return false;
                    }
                }
                return true;
            }
            int size = operObj.size();
            for (int i = 0; i < size; ++i) {
                part = (Part)operObj.get(i);
                int len = otherOperObj.size();
                for (int j = 0; j < len; ++j) {
                    String otherValue;
                    String value;
                    otherPart = (Part)otherOperObj.get(j);
                    if (part.getName().equalsIgnoreCase(otherPart.getName()) && !(value = part.getValue()).equals(otherValue = otherPart.getValue())) {
                        return false;
                    }
                    if (!otherPart.getName().equals("mod2") || otherPart.getValue().indexOf("ODU") == -1) continue;
                    return false;
                }
                if (!part.getName().equals("mod2") || part.getValue().indexOf("ODU") == -1) continue;
                return false;
            }
        }
        return flag;
    }

    public static ArrayList getTL1OperationObject(SubFunc subfunc) {
        ArrayList<String> list = new ArrayList<String>();
        OperObject operObj = subfunc.getOperObject();
        if (null == operObj) {
            return list;
        }
        for (int i = 0; i < operObj.getParamCount(); ++i) {
            list.add(operObj.getParam(i).getName().toLowerCase());
        }
        return list;
    }

    public static ArrayList getTL1OperObjData(ArrayList tl1OperationObject, InMsg input, OutMsg output) {
        ArrayList<Part> operObjDataArr = new ArrayList<Part>();
        Part curPart = null;
        Part containedPart = null;
        boolean flag = false;
        DataBlock dataBlock = null;
        if (null != input) {
            int i;
            AID aid = input.getStagBlock().getAID();
            int size = aid.getPartCount();
            for (i = 0; i < size; ++i) {
                if (!tl1OperationObject.contains(aid.getPart(i).getName().toLowerCase())) continue;
                operObjDataArr.add(aid.getPart(i));
            }
            size = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < size; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                int len = dataBlock.getPartCount();
                for (int j = 0; j < len; ++j) {
                    if (!tl1OperationObject.contains(dataBlock.getPart(j).getName().toLowerCase())) continue;
                    operObjDataArr.add(dataBlock.getPart(j));
                }
            }
        }
        int size = output.getMsgBlock().getDataBlockCount();
        for (int i = 0; i < size; ++i) {
            dataBlock = output.getMsgBlock().getDataBlock(i);
            int len = dataBlock.getPartCount();
            for (int j = 0; j < len; ++j) {
                curPart = dataBlock.getPart(j);
                if (!tl1OperationObject.contains(dataBlock.getPart(j).getName().toLowerCase())) continue;
                flag = false;
                int operObjLen = operObjDataArr.size();
                for (int index = 0; index < operObjLen; ++index) {
                    containedPart = (Part)operObjDataArr.get(index);
                    if (!containedPart.getName().equalsIgnoreCase(curPart.getName()) || null == curPart.getValue()) continue;
                    containedPart.setValue(curPart.getValue());
                    flag = true;
                    break;
                }
                if (flag) continue;
                operObjDataArr.add(curPart);
            }
        }
        return operObjDataArr;
    }

    public static ArrayList getTL1OperObjData(ArrayList tl1OperationObject, TL1Operation oper, OutMsg output) {
        ArrayList<Part> operObjDataArr = new ArrayList<Part>();
        InMsg input = oper.getInMsg();
        Part curPart = null;
        Part containedPart = null;
        boolean flag = false;
        DataBlock dataBlock = null;
        if (null != input) {
            int i;
            AID aid = input.getStagBlock().getAID();
            int size = aid.getPartCount();
            for (i = 0; i < size; ++i) {
                if (!tl1OperationObject.contains(aid.getPart(i).getName().toLowerCase())) continue;
                operObjDataArr.add(aid.getPart(i));
            }
            size = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < size; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                int len = dataBlock.getPartCount();
                for (int j = 0; j < len; ++j) {
                    if (!tl1OperationObject.contains(dataBlock.getPart(j).getName().toLowerCase())) continue;
                    operObjDataArr.add(dataBlock.getPart(j));
                }
            }
        }
        int size = output.getMsgBlock().getDataBlockCount();
        for (int i = 0; i < size; ++i) {
            dataBlock = output.getMsgBlock().getDataBlock(i);
            int len = dataBlock.getPartCount();
            for (int j = 0; j < len; ++j) {
                curPart = dataBlock.getPart(j);
                if (!tl1OperationObject.contains(dataBlock.getPart(j).getName().toLowerCase())) continue;
                flag = false;
                int operObjLen = operObjDataArr.size();
                for (int index = 0; index < operObjLen; ++index) {
                    containedPart = (Part)operObjDataArr.get(index);
                    if (!containedPart.getName().equalsIgnoreCase(curPart.getName()) || null == curPart.getValue()) continue;
                    containedPart.setValue(curPart.getValue());
                    flag = true;
                    break;
                }
                if (flag) continue;
                operObjDataArr.add(curPart);
            }
        }
        if (!(!tl1OperationObject.contains("mod2") || TETL1CommonUtil.getRealMod2(oper).equals("CLNT") || TETL1CommonUtil.getRealMod2(oper).equals("LPT") || TETL1CommonUtil.getRealMod2(oper).equals("CLIENT") || TETL1CommonUtil.getRealMod2(oper).equals("OSNREN"))) {
            Part mod2Part = new Part();
            mod2Part.setName("mod2");
            mod2Part.setValue(TETL1CommonUtil.getRealMod2(oper));
            operObjDataArr.add(mod2Part);
        }
        return operObjDataArr;
    }

    public static void joinTL1OperationInput(TL1Operation desOperation, TL1Operation srcOperation) {
        int index;
        AID desAID = desOperation.getInMsg().getStagBlock().getAID();
        AID srcAID = srcOperation.getInMsg().getStagBlock().getAID();
        MsgBlock desMsgBlock = desOperation.getInMsg().getMsgBlock();
        MsgBlock srcMsgBlock = srcOperation.getInMsg().getMsgBlock();
        for (index = 0; index < srcAID.getPartCount(); ++index) {
            desAID.addPart(srcAID.getPart(index));
        }
        for (index = 0; index < srcMsgBlock.getDataBlockCount(); ++index) {
            desMsgBlock.addDataBlock(srcMsgBlock.getDataBlock(index));
        }
    }

    public static void joinTL1OperationOutput(OutMsg desOutput, OutMsg srcOutput) {
        MsgBlock desMsgBlock = desOutput.getMsgBlock();
        MsgBlock srcMsgBlock = srcOutput.getMsgBlock();
        int size = srcMsgBlock.getDataBlockCount();
        for (int i = 0; i < size; ++i) {
            desMsgBlock.addDataBlock(srcMsgBlock.getDataBlock(i));
        }
    }

    public static RowErrors handleErrorData(int neid, SubFunc subfunc, InMsg input, OutMsg output) {
        MsgBlock outputBlock;
        int j;
        int size;
        int i;
        int len;
        ArrayList operObjct = TETL1DataConverter.getTL1OperationObject(subfunc);
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        DataBlock dataBlock = null;
        if (null != input) {
            AID aid = input.getStagBlock().getAID();
            len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                errorparam = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                rowError.addParam(errorparam);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    errorparam = new Param(dataBlock.getPart(j).getName(), dataBlock.getPart(j).getValue());
                    if (errorparam.getValue() != null) {
                        rowError.addParam(errorparam);
                    }
                    if (operObjct.contains(errorparam.getName())) continue;
                    errorparam = new Param("attrId", dataBlock.getPart(j).getName());
                    rowError.addParam(errorparam);
                }
            }
        }
        if ((outputBlock = output.getMsgBlock()) != null) {
            len = outputBlock.getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = output.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    errorparam = new Param("attrId", dataBlock.getPart(j).getName());
                    if (null != rowError.getParam(dataBlock.getPart(j).getName())) continue;
                    rowError.addParam(errorparam);
                }
            }
        }
        TETL1DataConverter.addErrorParam(neid, rowError);
        return rowError;
    }

    public static void copyInDataToOutData(TL1Operation tl1Operation) {
        InMsg input = tl1Operation.getInMsg();
        if (input == null) {
            return;
        }
        OutMsg output = null;
        int size = tl1Operation.getOutMsgCount();
        for (int i = 0; i < size; ++i) {
            output = tl1Operation.getOutMsg(i);
            int len = output.getMsgBlock().getDataBlockCount();
            for (int j = 0; j < len; ++j) {
                DataBlock dataBlock = output.getMsgBlock().getDataBlock(j);
                int partCount = dataBlock.getPartCount();
                for (int k = 0; k < partCount; ++k) {
                    if (dataBlock.getPart(k).getValue() != null || null == input.getPart(dataBlock.getPart(k).getName())) continue;
                    dataBlock.getPart(k).setValue(input.getPart(dataBlock.getPart(k).getName()).getValue());
                }
            }
        }
    }

    public static void addReturnParam(int neid, RowParams rowparams) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param = null;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null != rowparams.getParam("neid") && null == rowparams.getParam("nename")) {
            param = new Param("nename", neObj.getNEName());
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("slotid")) {
            try {
                String slotStr = rowparams.getParam("slotid").getValue();
                if (slotStr.indexOf("-") != -1) {
                    slotid = TETL1CommonUtil.getNMSlotStr(slotStr, neid);
                } else if (TETL1DataConverter.isNumber(slotStr)) {
                    slotid = Integer.parseInt(slotStr);
                }
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (null != rowparams.getParam("boardtype")) {
                try {
                    boardtype = Integer.parseInt(rowparams.getParam("boardtype").getValue());
                }
                catch (NumberFormatException e) {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    rowparams.getParam("boardtype").setValue(boardtype + "");
                }
            } else {
                boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                param = new Param("boardtype", boardtype + "");
                rowparams.addParam(param);
            }
            param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
            rowparams.addParam(param);
        }
        if (null != rowparams.getParam("port")) {
            try {
                port = -1;
                String portStr = rowparams.getParam("port").getValue();
                if (TETL1DataConverter.isNumber(portStr)) {
                    port = Integer.parseInt(portStr);
                }
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port));
            rowparams.addParam(param);
        }
    }

    protected static boolean isNumber(String str) {
        if (null == str || str.isEmpty()) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void addErrorParam(int neid, RowErrors rowParamError) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param = null;
        int shelfID = 0;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null != rowParamError.getParam("neid")) {
            param = new Param("nename", neObj.getNEName());
            rowParamError.addParam(param);
        }
        if (null != rowParamError.getParam("AID")) {
            try {
                String[] aid = TETL1CommonUtil.parseAID(rowParamError.getParam("AID").getValue(), neid);
                shelfID = Integer.parseInt(aid[1]);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (shelfID != -1) {
                param = new Param("subrackID", "Subrack" + shelfID);
                rowParamError.addParam(param);
            }
            try {
                slotid = TETL1CommonUtil.getNMSlotStr(rowParamError.getParam("AID").getValue(), neid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (slotid != -1) {
                if (null != rowParamError.getParam("boardtype")) {
                    try {
                        boardtype = Integer.parseInt(rowParamError.getParam("boardtype").getValue());
                    }
                    catch (NumberFormatException e) {
                        boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                        rowParamError.getParam("boardtype").setValue(boardtype + "");
                    }
                } else {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    param = new Param("boardtype", boardtype + "");
                    rowParamError.addParam(param);
                }
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                if (boardName.indexOf("UNKNOWN") == -1) {
                    param = new Param("boardname", slotid + "-" + boardName);
                }
                rowParamError.addParam(param);
            }
            try {
                String[] str = TETL1CommonUtil.parseAID(rowParamError.getParam("AID").getValue(), neid);
                if (str.length > 3 && str[3].equals("ALL")) {
                    port = Integer.parseInt(str[3]);
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (port != -1) {
                param = new Param("portid", String.valueOf(port));
                rowParamError.addParam(param);
                param = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, port));
                rowParamError.addParam(param);
            }
        }
    }
}

