/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;

public class TETL1DBCHGData {
    private String dbchgDateStr = "";
    private String dbchgTimeStr = "";
    private String dbchgSource = "";
    private String userID = "";
    private String dbchgCMDCode = "";
    private String dbchgSEQ = "";
    private int dbchgCTag = -1;
    private String dbchgAID = "";
    private String dbchgParam = "";
    private String dbchgStrInfo = "";
    public static final int DATE_POS = 0;
    public static final int TIME_POS = 1;
    public static final int SOURCE_POS = 2;
    public static final int USERID_POS = 3;
    public static final int DBCHGSEQ_POS = 4;
    public static final int NAME_POS = 0;
    public static final int VALUE_POS = 1;
    public static final String NAME_DATE = "DATE";
    public static final String NAME_TIME = "TIME";
    public static final String NAME_SOURCE = "SOURCE";
    public static final String NAME_USERID = "USERID";

    public String getDbchgAID() {
        return this.dbchgAID;
    }

    public void setDbchgAID(String dbchgAID) {
        this.dbchgAID = dbchgAID;
    }

    public String getDbchgCMDCode() {
        return this.dbchgCMDCode;
    }

    public void setDbchgCMDCode(String dbchgCMDCode) {
        this.dbchgCMDCode = dbchgCMDCode;
    }

    public int getDbchgCTag() {
        return this.dbchgCTag;
    }

    public void setDbchgCTag(int dbchgCTag) {
        this.dbchgCTag = dbchgCTag;
    }

    public String getDbchgDateStr() {
        return this.dbchgDateStr;
    }

    public void setDbchgDateStr(String dbchgDateStr) {
        this.dbchgDateStr = dbchgDateStr;
    }

    public String getDbchgParam() {
        return this.dbchgParam;
    }

    public void setDbchgParam(String dbchgParam) {
        this.dbchgParam = dbchgParam;
    }

    public String getDbchgSEQ() {
        return this.dbchgSEQ;
    }

    public void setDbchgSEQ(String dbchgSEQ) {
        this.dbchgSEQ = dbchgSEQ;
    }

    public String getDbchgSource() {
        return this.dbchgSource;
    }

    public void setDbchgSource(String dbchgSource) {
        this.dbchgSource = dbchgSource;
    }

    public String getDbchgTimeStr() {
        return this.dbchgTimeStr;
    }

    public void setDbchgTimeStr(String dbchgTimeStr) {
        this.dbchgTimeStr = dbchgTimeStr;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getDbchgStrInfo() {
        return this.dbchgStrInfo;
    }

    public void setDbchgStrInfo(String dbchgStrInfo) {
        this.dbchgStrInfo = dbchgStrInfo;
    }

    public void parseDBCHGInfo(String info) {
        try {
            int pos = info.indexOf("DBCHGSEQ=");
            String nameParamStr = info.substring(0, pos);
            for (String paramStr : nameParamStr.split(",")) {
                String[] strNameParam = paramStr.split("=");
                if (strNameParam[0].equals(NAME_DATE)) {
                    this.dbchgDateStr = strNameParam[1];
                    continue;
                }
                if (strNameParam[0].equals(NAME_TIME)) {
                    this.dbchgTimeStr = strNameParam[1];
                    continue;
                }
                if (strNameParam[0].equals(NAME_SOURCE)) {
                    this.dbchgSource = strNameParam[1];
                    continue;
                }
                if (!strNameParam[0].equals(NAME_USERID)) continue;
                this.userID = strNameParam[1];
            }
            this.dbchgStrInfo = info;
            this.dbchgSEQ = info.substring(pos + "DBCHGSEQ=".length(), info.length());
            String dbchgValue = info.substring(pos + "DBCHGSEQ=".length(), info.length());
            String[] infoArr = this.getDBCHGData(dbchgValue);
            if (infoArr.length < 4) {
                TELogFactory.getNormalLogger().error("DBCHG Data Error.");
                return;
            }
            try {
                this.dbchgCTag = Integer.parseInt(infoArr[0]);
            }
            catch (Exception e) {
                this.dbchgCTag = 0;
            }
            this.dbchgCMDCode = infoArr[1];
            this.dbchgAID = infoArr[2];
            this.dbchgParam = infoArr[3];
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("DBCHG exception:" + info);
        }
    }

    private String[] getDBCHGData(String dbchgValue) {
        String[] dbchgSeq;
        block3: {
            int index = -1;
            int i = 0;
            dbchgSeq = new String[4];
            while ((index = dbchgValue.indexOf(":")) != -1) {
                dbchgSeq[i] = dbchgValue.substring(0, index);
                if (i > 2) {
                    if (dbchgSeq[i].equals("")) {
                        dbchgValue = dbchgValue.substring(index + 1, dbchgValue.length());
                        continue;
                    }
                    dbchgSeq[i] = dbchgValue;
                    break block3;
                }
                dbchgValue = dbchgValue.substring(index + 1, dbchgValue.length());
                ++i;
            }
            dbchgSeq[i] = dbchgValue;
        }
        return dbchgSeq;
    }

    public static void main(String[] args) {
        TETL1DBCHGData data = new TETL1DBCHGData();
        data.parseDBCHGInfo("DATE=2009-01-06,TIME=10-42-34,SOURCE=504,USERID=luzhaopeng1,DBCHGSEQ=202:ENT-EQPT:SLOT-1-4-4:OC");
    }
}

