/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.ngwdm_pub.TESimpleModelUtil;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.SlotObject;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.cache.TETimeStatMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.TL1NoticeHandler;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import com.huawei.uflight.tl1.tl1operation.types.ParamType;
import com.huawei.uflight.tl1.tl1operation.types.PartType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class TETL1CommonUtil {
    private static final int SLOTCONSTATNS = 100;
    private static final String newVersion = "51";
    private static final String newVersion_1800NA = "67";
    public static final int OSN_6800_A = 71;
    public static final int OSN_3800_A = 70;
    public static final int OSN_1800_A = 66;
    public static final int OSN_8800_A = 73;
    public static final int OSN_8800_A_II = 75;
    public static final int OSN_8800T16A = 85;
    public static final int OSN8800A_I_DEVTYPE = 2043;
    public static final int OSN8800EA_I_DEVTYPE = 2044;
    public static final int OSN8800A_II_DEVTYPE = 1975;
    public static final int OSN8800EA_II_DEVTYPE = 101;
    public static final int OSN8800T16A_DEVTYPE = 1985;
    public static final int OSN6800A_DEVTYPE = 136;
    public static final int PFE = 72;
    public static final int PFEG4 = 113;
    public static final String TL1_DES_PATH = "nemgr" + File.separator + "device" + File.separator + "tl1ngwdm" + File.separator + "conf" + File.separator + "tl1describ.xml";
    public static final int INDEXPOS = 0;
    public static final int SHELFPOS = 1;
    public static final int SLOTIDPOS = 2;
    public static final int PORTIDPOS = 3;
    public static final int VBPOS = 3;
    public static final int VBLPPOS = 4;
    public static final int CHANNELIDPOS = 4;
    public static final String AIDSPERATOR = "-";
    public static final int VCTRUNK_NM_BASE_NUM = 32768;
    public static final String OLDNEVERSION_6800NA = "5.71.01.19";
    public static final String OLDNEVERSION_3800NA = "5.70.01.19";
    public static final String OLDNEVERSION_1800NA = "5.66.02.99";
    public static final String NEWNEVERSION_1800NA = "5.67.03.20";
    public static final String OLDNEVERSION_PFE = "5.72.01.10";
    public static final String OLDNEVERSION_PFEG4 = "5.113.01.10";
    public static final String OSN8800A = "SHELF8800T32";
    public static final String OSN8800EA = "SHELF8800T32E";
    public static final String OSN8800AII = "SHELF8800T64";
    public static final String OSN8800EAII = "SHELF8800T64E";
    public static final String OSN8800T16 = "SHELF8800T16";
    public static final String USETYPESTR = "USETYPESTR";
    public static final int VCTRUNK_3 = 32771;
    public static final int VCTRUNK_4 = 32772;
    private static TETimeBuffer<SlotObject, TEAIDAndTypeList> slotAIDBuffer = new TETimeBuffer();

    public static void refreshSlotAIDBuffer(int neid, int slotid) {
        try {
            slotAIDBuffer.refreshTimeBuffer(new SlotObject(neid, slotid));
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("refresh slot AID buffer failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("refresh slot AID buffer failed!", (Throwable)e);
        }
    }

    public static HashMap getOutMsgPart(OutMsg outmsg) {
        MsgBlock block = outmsg.getMsgBlock();
        HashMap<String, Part> partMap = new HashMap<String, Part>();
        if (block == null) {
            return partMap;
        }
        for (DataBlock datablock : block.getDataBlock()) {
            for (Part part : datablock.getPart()) {
                Part tempPart = (Part)partMap.get(part.getName());
                if (tempPart != null) continue;
                partMap.put(part.getName(), part);
            }
        }
        return partMap;
    }

    public static ArrayList createQueryFACAttrTL1Operation(int neid, String mod2, String[] facAid) {
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        ArrayList<TL1Operation> tl1List = new ArrayList<TL1Operation>();
        String cmdType = "RTRV";
        TL1Operation tl1Op = tl1definitions.getTL1Operation("CMDCODE");
        int len = facAid.length;
        for (int i = 0; i < len; ++i) {
            TL1Operation operation = (TL1Operation)tl1Op.clone();
            operation.setCmdCode(cmdType);
            operation.setMod1(mod2);
            operation.setName(cmdType + AIDSPERATOR + mod2);
            AID aid = operation.getInMsg().getStagBlock().getAID();
            Part part = aid.getPart(0);
            part.setValue(facAid[i]);
            tl1List.add(operation);
        }
        return tl1List;
    }

    public static Part getPart(Collection partmap, String name) {
        Part retPart = null;
        for (Part part : partmap) {
            if (part.getConvert() == null || !TETL1CommonUtil.parseString(part.getConvert(), ",").contains(name)) continue;
            return part;
        }
        return retPart;
    }

    public static Param getParam(Param[] parammap, String convertName) {
        Param retPart = null;
        if (convertName == null) {
            return retPart;
        }
        for (int i = 0; i < parammap.length; ++i) {
            if (!TETL1CommonUtil.parseString(convertName, ",").contains(parammap[i].getName())) continue;
            return parammap[i];
        }
        return retPart;
    }

    public static ArrayList parseString(String parsedStr, String delim) {
        ArrayList<String> tmpList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(parsedStr, delim);
        while (st.hasMoreTokens()) {
            String key = st.nextToken().trim();
            tmpList.add(key);
        }
        return tmpList;
    }

    public static String getOperationResult(Fault fault) {
        String result = "";
        String tmpStr = fault.getErrDesc();
        if (tmpStr != null && !tmpStr.equals("")) {
            return tmpStr;
        }
        tmpStr = fault.getErrCode();
        try {
            if (!tmpStr.equals("")) {
                TEErrorResourceUtil.getErrCodeResWithDot(new Integer(tmpStr));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Operation Result Fault:\n", (Throwable)e);
        }
        return result;
    }

    public static boolean hasShelfNE(int neid) {
        TENE ne = !TESysManagerBean.getInstance().isIntegratedStatus() ? TENEListMgr.getInstance().getNE(neid) : TENEListMgr.getInstance().getInterNE(neid);
        return ne.getNEType() == 71 || ne.getNEType() == 66 || ne.getNEType() == 73 || ne.getNEType() == 75 || ne.getNEType() == 85;
    }

    public static String slotIDNMToNEShelfIDSlotID(int neid, int slotID) {
        int slot = TEBoardUtil.getSlotIDFromSlot(neid, slotID);
        int shelfID = TEBoardUtil.getSubrackIDFromSlot(neid, slotID);
        if (TETL1CommonUtil.hasShelfNE(neid)) {
            return shelfID + AIDSPERATOR + slot;
        }
        return "" + slot;
    }

    public static int neShelfIDSlotIDToSlotIDNM(String shelfslotID) {
        String[] str = shelfslotID.split(AIDSPERATOR);
        int slot = 0;
        try {
            if (str.length == 1) {
                slot = Integer.parseInt(shelfslotID);
            } else if (str[0].equals("-1")) {
                slot = new Integer(str[1]);
            } else {
                int shelfID = new Integer(str[0]);
                int slotID = new Integer(str[1]);
                slot = shelfID * 65536 + slotID;
            }
        }
        catch (Exception e) {
            slot = -1;
            return slot;
        }
        return slot;
    }

    public static int slotIDNMToNEShelfID(int slotID) {
        int shelfID = slotID / TETL1CommonUtil.getSlotOffset(slotID);
        return shelfID <<= 5;
    }

    public static int slotIDNMToNESlotID(int slotID) {
        return TEBoardUtil.getSlotIDFromSlot(-1, slotID);
    }

    private static int getSlotOffset(int slotID) {
        if (slotID > 1000) {
            return 1000;
        }
        return 100;
    }

    public static TEAIDAndTypeList queryPortTypeFromBuffer(int neID, HashSet slotIDSet) throws TEUnknowmKeyTypeException, UnkownRefresherException {
        Object[] slotIDList = slotIDSet.toArray();
        TEAIDAndTypeList portType = new TEAIDAndTypeList();
        for (int i = 0; i < slotIDList.length; ++i) {
            int slotID = (Integer)slotIDList[i];
            SlotObject keyObj = new SlotObject(neID, slotID);
            TEAIDAndTypeList aidList = slotAIDBuffer.get(keyObj);
            portType.getAidAndTypeMap().putAll(aidList.getAidAndTypeMap());
        }
        return portType;
    }

    public static TEAIDAndTypeList queryPortType(int neID, HashSet slotIDSet) {
        ArrayList<TEErrInfo> errInfoList = new ArrayList<TEErrInfo>();
        return TETL1CommonUtil.queryPortType(neID, slotIDSet, errInfoList);
    }

    public static TEAIDAndTypeList queryPortType(int neID, HashSet slotIDSet, List<TEErrInfo> errInfoList) {
        TEAIDAndTypeList portType = null;
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neID);
        }
        catch (Exception e) {
            if (null != errInfoList) {
                TEErrInfo errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID});
                errInfo.setErrorCode(1090646019);
                errInfoList.add(errInfo);
            }
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return null;
        }
        ArrayList<Object> tl1OperList = new ArrayList<Object>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-PORT");
        Object[] slotIDList = slotIDSet.toArray();
        for (int i = 0; i < slotIDList.length; ++i) {
            int slotID = (Integer)slotIDList[i];
            String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neID, slotID);
            TL1Operation tmpTl1Operation = tl1Operation;
            InMsg inputMsg = tmpTl1Operation.getInMsg();
            StagBlock stagBlock = inputMsg.getStagBlock();
            AID aid = stagBlock.getAID();
            Part part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList.add(tmpTl1Operation.clone());
        }
        TETimeStatMgr timer = new TETimeStatMgr(TETimeStatMgr.FLAG_LOG);
        timer.startStat("get tl1 52tom service type. size->" + tl1OperList.size());
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neID, tl1OperList, 60);
        timer.stopStat();
        if (result.retCode == 0) {
            portType = new TEAIDAndTypeList();
            int errCode = -1;
            int shelfID = -1;
            int relativeSlotID = -1;
            int slotID = -1;
            for (int i = 0; i < tl1OperList.size(); ++i) {
                TL1Operation tOper = (TL1Operation)tl1OperList.get(i);
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    OutMsg output = tOper.getOutMsg(row);
                    errCode = output.getFault().getCompletionCode();
                    if (0 == errCode) {
                        HashMap partMap = TETL1CommonUtil.getOutMsgPart(output);
                        String aidStr = ((Part)partMap.get("AID")).getValue();
                        String actTypeStr = "";
                        Part phyPart = (Part)partMap.get("ACTTYPE");
                        if (phyPart != null) {
                            actTypeStr = TETL1CommonUtil.isNull(phyPart.getValue());
                        }
                        String pldTypeStr = "";
                        Part pldPart = (Part)partMap.get("PLDTYPE");
                        if (pldPart != null) {
                            pldTypeStr = TETL1CommonUtil.isNull(pldPart.getValue());
                        }
                        String typeStr = "";
                        Part typePart = (Part)partMap.get("TYPE");
                        if (typePart != null) {
                            typeStr = TETL1CommonUtil.isNull(typePart.getValue());
                        }
                        TEAIDAndType aidType = null;
                        ArrayList<String> newAidList = TESimpleModelUtil.handleTL1SimpleModelPath(aidStr, typeStr, neID);
                        int aidSize = newAidList.size();
                        for (int j = 0; j < aidSize; ++j) {
                            String newaidStr = newAidList.get(j);
                            aidType = actTypeStr.equals("") && pldTypeStr.equals("") ? (!typeStr.isEmpty() && TESimpleModelUtil.isUseTypeStr(aidStr, neID) ? new TEAIDAndType(newaidStr, aidStr, USETYPESTR, USETYPESTR, typeStr) : new TEAIDAndType(newaidStr, aidStr, "UNEQ", "UNEQ", typeStr)) : new TEAIDAndType(newaidStr, aidStr, actTypeStr, pldTypeStr, typeStr);
                            portType.add(neID, aidType);
                        }
                        continue;
                    }
                    slotID = (Integer)slotIDList[i];
                    portType.addFaultInfo(slotID, output.getFault());
                    if (null == errInfoList) continue;
                    shelfID = TEBoardUtil.getRelativeShelfID(slotID);
                    relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
                    TEErrInfo errInfo = new TEErrInfo();
                    errInfo.setObjID(new int[]{neID, shelfID, relativeSlotID});
                    errInfo.setErrorCode(errCode);
                    errInfoList.add(errInfo);
                }
            }
        } else if (null != errInfoList) {
            TEErrInfo errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neID});
            errInfo.setErrorCode(result.retCode);
            errInfoList.add(errInfo);
        }
        return portType;
    }

    public static TEAIDAndTypeList queryPortType(int neID, HashSet slotIDSet, Datainterface outputData) {
        TEAIDAndTypeList portType = null;
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return null;
        }
        ArrayList<Object> tl1OperList = new ArrayList<Object>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-PORT");
        Object[] slotIDList = slotIDSet.toArray();
        String boardMode = "";
        for (int i = 0; i < slotIDList.length; ++i) {
            int slotID = (Integer)slotIDList[i];
            String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neID, slotID);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            if (boardType == 2294 || boardType == 2293 || boardType == 2310 || boardType == 2311) {
                boardMode = TETL1CommonUtil.queryBoardMode(neID, slotID);
            }
            TL1Operation tmpTl1Operation = tl1Operation;
            InMsg inputMsg = tmpTl1Operation.getInMsg();
            StagBlock stagBlock = inputMsg.getStagBlock();
            AID aid = stagBlock.getAID();
            Part part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList.add(tmpTl1Operation.clone());
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neID, tl1OperList, 60);
        if (result.retCode == 0) {
            portType = new TEAIDAndTypeList();
            for (int i = 0; i < tl1OperList.size(); ++i) {
                TL1Operation tOper = (TL1Operation)tl1OperList.get(i);
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    OutMsg output = tOper.getOutMsg(row);
                    if (output.getFault().getCompletionCode() == 0) {
                        HashMap partMap = TETL1CommonUtil.getOutMsgPart(output);
                        String aidStr = ((Part)partMap.get("AID")).getValue();
                        String actTypeStr = "";
                        Part phyPart = (Part)partMap.get("ACTTYPE");
                        if (phyPart != null) {
                            actTypeStr = TETL1CommonUtil.isNull(phyPart.getValue());
                        }
                        String pldTypeStr = "";
                        Part pldPart = (Part)partMap.get("PLDTYPE");
                        if (pldPart != null) {
                            pldTypeStr = TETL1CommonUtil.isNull(pldPart.getValue());
                        }
                        String typeStr = "";
                        Part typePart = (Part)partMap.get("TYPE");
                        if (typePart != null) {
                            typeStr = TETL1CommonUtil.isNull(typePart.getValue());
                        }
                        if (!(!boardMode.equalsIgnoreCase("REG") && !boardMode.equalsIgnoreCase("OREG") || !typeStr.equalsIgnoreCase("ODU2") && !typeStr.equalsIgnoreCase("ODU1") && !typeStr.equalsIgnoreCase("ODU0") && !typeStr.equalsIgnoreCase("ODUFLEX"))) continue;
                        TEAIDAndType aidType = null;
                        ArrayList<String> newAidList = TESimpleModelUtil.handleTL1SimpleModelPath(aidStr, typeStr, neID);
                        int aidSize = newAidList.size();
                        for (int j = 0; j < aidSize; ++j) {
                            String newaidStr = newAidList.get(j);
                            aidType = actTypeStr.equals("") && pldTypeStr.equals("") ? (TESimpleModelUtil.isUseTypeStr(aidStr, neID) && !typeStr.isEmpty() ? new TEAIDAndType(newaidStr, aidStr, USETYPESTR, USETYPESTR, typeStr) : new TEAIDAndType(newaidStr, aidStr, "UNEQ", "UNEQ", typeStr)) : new TEAIDAndType(newaidStr, aidStr, actTypeStr, pldTypeStr, typeStr);
                            portType.add(neID, aidType);
                        }
                        continue;
                    }
                    portType.addFaultInfo((Integer)slotIDList[i], output.getFault());
                }
            }
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
        }
        return portType;
    }

    public static String queryBoardMode(int neid, int slotID) {
        TL1Definitions tl1definitions = null;
        String boardMode = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return boardMode;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-EQPT");
        String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotID);
        TL1Operation tmpTl1Operation = (TL1Operation)tl1Operation.clone();
        InMsg inputMsg = tmpTl1Operation.getInMsg();
        StagBlock stagBlock = inputMsg.getStagBlock();
        AID aid = stagBlock.getAID();
        Part part = aid.getPart(0);
        part.setValue(tmpAid);
        tl1OperList.add(tmpTl1Operation);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 30);
        if (result.retCode == 0) {
            TL1Operation tOper = (TL1Operation)tl1OperList.get(0);
            int size = tOper.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                Part phyPart;
                HashMap partMap;
                String aidStr;
                OutMsg output = tOper.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap = TETL1CommonUtil.getOutMsgPart(output)).get("slotID")).getValue()).equals(tmpAid) || (phyPart = (Part)partMap.get("WORKMODE")) == null) continue;
                boardMode = TETL1CommonUtil.isNull(phyPart.getValue());
            }
        }
        return boardMode;
    }

    public static Object[] getPorts(String ports) {
        String[] splitBetween = ports.split("&&");
        HashSet<String> returnSet = new HashSet<String>();
        String begin = "0";
        String end = "0";
        boolean flag = false;
        for (int i = 0; i < splitBetween.length; ++i) {
            String[] split = splitBetween[i].split("&");
            for (int j = 0; j < split.length; ++j) {
                if (i != 0 && j == 0) {
                    end = split[j];
                    flag = true;
                } else if (i != splitBetween.length - 1 && j == split.length - 1) {
                    begin = split[j];
                    flag = false;
                } else {
                    returnSet.add(split[j]);
                    flag = false;
                }
                if (!flag) continue;
                TETL1CommonUtil.setBetween(Integer.parseInt(begin), Integer.parseInt(end), returnSet);
            }
        }
        Object[] result = returnSet.toArray();
        Arrays.sort(result);
        return result;
    }

    public static void setBetween(int begin, int end, Set result) {
        while (begin < end + 1) {
            result.add(String.valueOf(begin));
            ++begin;
        }
    }

    public static void registerMod2Listener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        ArrayList mod2 = TETL1CommonUtil.getAllMOD2List();
        int size = mod2.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation operation = (TL1Operation)oper.clone();
            String mod2Name = (String)mod2.get(i);
            operation.setMod2(mod2Name);
            operation.setName(operation.getCmdCode() + "_" + operation.getMod1() + "_" + operation.getMod2());
            TETL1NECommMgr.getInstance().registerListener(operation, rspHandler);
        }
    }

    public static void registerAlmMod2Listener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        ArrayList mod2 = TETL1CommonUtil.getAllMOD2List();
        int size = mod2.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation operation = (TL1Operation)oper.clone();
            String mod2Name = (String)mod2.get(i);
            if (mod2Name.equals("ENV")) continue;
            operation.setMod2(mod2Name);
            operation.setName(operation.getCmdCode() + "_" + operation.getMod1() + "_" + operation.getMod2());
            TETL1NECommMgr.getInstance().registerListener(operation, rspHandler);
        }
    }

    public static void unregisterMod2Listener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        ArrayList mod2 = TETL1CommonUtil.getAllMOD2List();
        int size = mod2.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation operation = (TL1Operation)oper.clone();
            String mod2Name = (String)mod2.get(i);
            operation.setMod2(mod2Name);
            operation.setName(operation.getCmdCode() + "_" + operation.getMod1() + "_" + operation.getMod2());
            TETL1NECommMgr.getInstance().unregisterListener(operation, rspHandler);
        }
    }

    public static void unregisterAlmMod2Listener(TL1Operation oper, TL1NoticeHandler rspHandler) {
        ArrayList mod2 = TETL1CommonUtil.getAllMOD2List();
        int size = mod2.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation operation = (TL1Operation)oper.clone();
            String mod2Name = (String)mod2.get(i);
            if (mod2Name.equals("ENV")) continue;
            operation.setMod2(mod2Name);
            operation.setName(operation.getCmdCode() + "_" + operation.getMod1() + "_" + operation.getMod2());
            TETL1NECommMgr.getInstance().unregisterListener(operation, rspHandler);
        }
    }

    public static ArrayList getAllMOD2List() {
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        ArrayList modList = fbDesc.getMod2List();
        return modList;
    }

    public static String parseMode2Str(String mode2Str, String attrID) {
        String[] str = mode2Str.split(",");
        if (str.length == 1) {
            return mode2Str;
        }
        int size = str.length - 1;
        for (int i = 0; i < size; ++i) {
            if (!str[i].equals(attrID)) continue;
            return str[i + 1];
        }
        return "";
    }

    public static String[] parseAID(String commonAid, int neid) {
        String[] slot_array = new String[5];
        if (null == commonAid || commonAid.isEmpty()) {
            TELogFactory.getNormalLogger().error("commonAid is null!");
            return slot_array;
        }
        String[] str = commonAid.split(AIDSPERATOR);
        try {
            if (TETL1CommonUtil.hasShelfNE(neid)) {
                TETL1CommonUtil.copyString(str, slot_array);
            } else {
                TETL1CommonUtil.copyString(str, slot_array, 1);
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("NEID:" + neid + " AID: " + commonAid + " Error.", (Throwable)ex);
        }
        return slot_array;
    }

    private static void copyString(String[] str, String[] slot_array) {
        TETL1CommonUtil.copyString(str, slot_array, -1);
    }

    private static void copyString(String[] str, String[] slot_array, int pos) {
        int length = str.length;
        int k = 0;
        for (int i = 0; i < 5; ++i) {
            if (pos == -1) {
                if (i < length) {
                    slot_array[i] = str[i];
                    continue;
                }
                slot_array[i] = "-1";
                continue;
            }
            if (i == pos) {
                slot_array[i] = "-1";
                ++length;
                continue;
            }
            if (i < length) {
                slot_array[i] = str[k];
                ++k;
                continue;
            }
            slot_array[i] = "-1";
        }
    }

    public static int getNMSlotStr(String fac, int neid) {
        String[] str = TETL1CommonUtil.parseAID(fac, neid);
        if (str.length > 1) {
            String neSlot = str[1] + AIDSPERATOR + str[2];
            if (str[1].equals("-1")) {
                neSlot = str[2];
            }
            return TETL1CommonUtil.neShelfIDSlotIDToSlotIDNM(neSlot);
        }
        return -1;
    }

    public static String getBoardStructFromAID(String fac, int neid, boolean isShowNE) {
        String[] aid = TETL1CommonUtil.parseAID(fac, neid);
        int slotNMID = TETL1CommonUtil.getNMSlotStr(fac, neid);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neid, slotNMID);
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neid, slotNMID);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardType);
        int portID = -1;
        if (!aid[3].equals("ALL")) {
            portID = Integer.parseInt(aid[3]);
        }
        int pathID = Integer.parseInt(aid[4]);
        if (isShowNE) {
            StringBuffer sb = new StringBuffer();
            String neName = TEConfigurationDataMgr.getInstance().getNE(neid).getNEName();
            sb.append(neName);
            sb.append(AIDSPERATOR);
            if (!shelfName.equals("")) {
                sb.append(shelfName).append(AIDSPERATOR);
            }
            sb.append(showSlot).append(AIDSPERATOR);
            sb.append(boardName);
            if (portID != -1) {
                String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
                sb.append(AIDSPERATOR);
                if (portName.equals("")) {
                    sb.append(portID);
                } else {
                    sb.append(portName);
                }
            }
            if (pathID != -1) {
                sb.append(AIDSPERATOR);
                sb.append(pathID);
            }
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        if (!shelfName.equals("")) {
            sb.append(shelfName).append(AIDSPERATOR);
        }
        sb.append(showSlot).append(AIDSPERATOR);
        sb.append(boardName);
        if (portID != -1) {
            String portName = TETL1CommonUtil.getPortNameFromNEPort(aid[0], slotNMID, portID, neid);
            sb.append(AIDSPERATOR);
            sb.append(portName);
        }
        if (pathID != -1) {
            sb.append(AIDSPERATOR);
            sb.append(pathID);
        }
        return sb.toString();
    }

    public static int getPortIDFromAID(String fac, int neid) {
        String[] aid = TETL1CommonUtil.parseAID(fac, neid);
        int portID = -1;
        if (!aid[3].equals("ALL")) {
            portID = Integer.parseInt(aid[3]);
        }
        return portID;
    }

    public static String getPortNameFromNEPort(String prefix, int slotNM, int portID, int neID) {
        int portNMNO = TETL1CommonUtil.getNMPortNOFromNEPort(prefix, slotNM, portID, neID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotNM);
        if (portNMNO == -1) {
            return "";
        }
        return TEConfigurationDataMgr.getInstance().getPortName(neID, slotNM, boardType, portNMNO);
    }

    public static String getPortNameFromNEPort(String prefix, int slotNM, int portID, int neID, int boardtype) {
        int portNMNO = TETL1CommonUtil.getNMPortNOFromNEPort(prefix, slotNM, portID, neID);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotNM);
        if (portNMNO == -1) {
            return "";
        }
        return TEConfigurationDataMgr.getInstance().getPortName(neID, slotNM, boardType, portNMNO);
    }

    public static int getNMPortNOFromNEPort(String prefix, int slotNM, int portID, int neID) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotNM);
        TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neID, boardType);
        if (boardTypePro == null) {
            return -1;
        }
        if (prefix.equalsIgnoreCase("FAC")) {
            return portID;
        }
        TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(prefix);
        if (portPro == null) {
            return -1;
        }
        int offset = portPro.portOffset;
        if ((boardType == 60031 || boardType == 2109) && offset == 0) {
            offset = 32768;
        }
        int portNO = portID - offset;
        return portNO;
    }

    public static int getNMPortNOFromNEPhyPort(String prefix, int slotNM, int portID, int neID) {
        TENE neObj = null;
        neObj = TENEListMgr.getInstance().getNE(neID);
        int portNO = -1;
        if (neObj != null && neObj.getPhyBoard(slotNM) != null) {
            int phyBoardType = neObj.getPhyBoard(slotNM).getBoardType();
            TESDCircuitPackRecord phyBoardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neID, phyBoardType);
            if (phyBoardTypePro != null) {
                if (prefix.equals("FAC")) {
                    portNO = portID;
                } else {
                    TEInstallCPPortRecord phyPortPro = phyBoardTypePro.getPortProperty(prefix);
                    if (phyPortPro != null) {
                        int offset = phyPortPro.portOffset;
                        if (phyBoardType == 60031 && offset == 0) {
                            offset = 32768;
                        }
                        portNO = portID - offset;
                    }
                }
            }
        }
        return portNO;
    }

    public static String getGencfgObjFromAID(int neID, String AID2) {
        String[] tmpStr = TETL1CommonUtil.parseAID(AID2, neID);
        String aidPref = tmpStr[0];
        String portStr = tmpStr[3];
        String pathStr = tmpStr[4];
        StringBuffer buffer = new StringBuffer();
        String neName = TEConfigurationDataMgr.getInstance().getNEName(neID);
        buffer.append(neName).append(AIDSPERATOR);
        int slot = TETL1CommonUtil.getNMSlotStr(AID2, neID);
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neID, slot);
        if (!shelfName.equals("")) {
            buffer.append(shelfName).append(AIDSPERATOR);
        }
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neID, slot);
        buffer.append(showSlot).append(AIDSPERATOR);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slot);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        buffer.append(boardName).append(AIDSPERATOR);
        String portName = TETL1CommonUtil.getPortNameFromNEPort(aidPref, slot, Integer.valueOf(portStr), neID);
        buffer.append(portName);
        if (new Integer(pathStr) > 0) {
            buffer.append(AIDSPERATOR);
            buffer.append(pathStr);
        }
        return buffer.toString();
    }

    public static String getGencfgObjFromAID(int neID, String AID2, String mode2) {
        TETL1SimpleAID sAid = new TETL1SimpleAID(AID2, neID);
        String aidPref = sAid.getAidPre();
        int slot = sAid.getNmSlotID();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slot);
        int port = sAid.getPortID();
        int path = sAid.getNmPath(mode2);
        StringBuffer buffer = new StringBuffer();
        String neName = TEConfigurationDataMgr.getInstance().getNEName(neID);
        buffer.append(neName).append(AIDSPERATOR);
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neID, slot);
        if (!shelfName.isEmpty()) {
            buffer.append(shelfName).append(AIDSPERATOR);
        }
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neID, slot);
        buffer.append(showSlot).append(AIDSPERATOR);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        buffer.append(boardName).append(AIDSPERATOR);
        String portName = TETL1CommonUtil.getPortNameFromNEPort(aidPref, slot, port, neID);
        buffer.append(portName);
        if ((mode2.indexOf("OTU") != -1 || mode2.indexOf("ODU") != -1 || mode2.equalsIgnoreCase("OCH")) && sAid.isSimplesBoard() && sAid.getAidPre().equalsIgnoreCase("FAC") && path > 0) {
            buffer.append(AIDSPERATOR);
            String showPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(path);
            buffer.append(showPath);
        } else {
            if (!mode2.equals("")) {
                buffer.append(AIDSPERATOR);
                buffer.append(mode2);
            }
            if (path > 0) {
                buffer.append(AIDSPERATOR);
                buffer.append(path);
            }
        }
        return buffer.toString();
    }

    public static String getGencfgObjFromAIDBymode(int neID, String AID2, int boardtype) {
        String[] tmpStr = TETL1CommonUtil.parseAID(AID2, neID);
        String aidPref = tmpStr[0];
        String portStr = tmpStr[3];
        String pathStr = tmpStr[4];
        StringBuffer buffer = new StringBuffer();
        String neName = TEConfigurationDataMgr.getInstance().getNEName(neID);
        buffer.append(neName).append(AIDSPERATOR);
        int slot = TETL1CommonUtil.getNMSlotStr(AID2, neID);
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neID, slot);
        if (!shelfName.equals("")) {
            buffer.append(shelfName).append(AIDSPERATOR);
        }
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neID, slot);
        buffer.append(showSlot).append(AIDSPERATOR);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slot);
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType);
        buffer.append(boardName).append(AIDSPERATOR);
        String portName = TETL1CommonUtil.getPortNameFromNEPort(aidPref, slot, Integer.valueOf(portStr), neID, boardtype);
        buffer.append(portName);
        if (new Integer(pathStr) > 0) {
            buffer.append(AIDSPERATOR);
            buffer.append(pathStr);
        }
        return buffer.toString();
    }

    public static String getShelfSlotName(int neid, int slot) {
        String shelfName = TEBoardUtil.getSubrackNameFromSlot(neid, slot);
        int showSlot = TEBoardUtil.getSlotIDFromSlot(neid, slot);
        if (shelfName.equals("")) {
            return String.valueOf(showSlot);
        }
        return shelfName + AIDSPERATOR + showSlot;
    }

    public static String getAIDPrefix(int portid) {
        String prefix = "UNKNOWN";
        if (portid < 51 && portid > 0) {
            prefix = "FAC";
        }
        if (portid < 201 && portid >= 101) {
            prefix = "ACC";
        }
        if (portid < 300 && portid >= 201) {
            prefix = "CLNT";
        }
        if (portid < 60 && portid >= 51) {
            prefix = "SRV1";
        }
        if (portid < 80 && portid >= 71) {
            prefix = "SRV2";
        }
        if (portid < 90 && portid >= 81) {
            prefix = "SRV1";
        }
        return prefix;
    }

    public static void modifyMOD2(TL1Operation tl1Operation, String newMod2) {
        String[] temp = tl1Operation.getName().split(AIDSPERATOR);
        if (temp.length == 2) {
            tl1Operation.setMod1(newMod2);
            tl1Operation.setName(tl1Operation.getCmdCode() + AIDSPERATOR + newMod2);
        } else if (temp.length == 3) {
            tl1Operation.setMod2(newMod2);
            tl1Operation.setName(tl1Operation.getCmdCode() + AIDSPERATOR + tl1Operation.getMod1() + AIDSPERATOR + newMod2);
        }
    }

    public static String getAIDFromPort(int neid, String soltStr, String portStr, String pathStr) {
        StringBuffer sb = new StringBuffer();
        String aidPre = "";
        aidPre = !(!portStr.equals("") && !portStr.equals("0") || !pathStr.equals("") && !pathStr.equals("0")) ? "SLOT" : TETL1CommonUtil.getAIDFrefix(neid, Integer.parseInt(soltStr), Integer.parseInt(portStr));
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.parseInt(soltStr));
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, Integer.parseInt(soltStr));
        sb.append(aidPre);
        sb.append(AIDSPERATOR);
        sb.append(neSlot);
        if (!portStr.equals("") && !portStr.equals("0")) {
            int nePort = TETL1CommonUtil.getAIDPortNo(neid, Integer.parseInt(soltStr), Integer.parseInt(portStr));
            sb.append(AIDSPERATOR);
            sb.append(nePort);
        }
        if (!pathStr.equals("") && !pathStr.equals("0")) {
            int path = Integer.parseInt(pathStr);
            if (path > 1200) {
                String tl1Path = TETL1AIDTranslateRuleMgr.getInstance().getTL1Path(boardType, pathStr);
                if (!tl1Path.isEmpty()) {
                    sb.append(AIDSPERATOR);
                    sb.append(tl1Path);
                }
            } else {
                sb.append(AIDSPERATOR);
                sb.append(pathStr);
            }
        }
        return sb.toString();
    }

    public static String combineAID(int neid, int slot, int port, int path) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        return TETL1CommonUtil.combineAID(neid, slot, port, path, boardType);
    }

    public static String combineAID(int neid, int slot, int port, int path, int boardType) {
        String tl1Path;
        StringBuffer sb = new StringBuffer();
        String aidPre = "";
        aidPre = port < 1 ? "SLOT" : TETL1CommonUtil.getAIDFrefix(neid, slot, port, boardType);
        String neSlot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot);
        sb.append(aidPre);
        sb.append(AIDSPERATOR);
        sb.append(neSlot);
        if (port > 0) {
            int nePort = TETL1CommonUtil.getAIDPortNo(neid, slot, port, boardType);
            sb.append(AIDSPERATOR);
            sb.append(nePort);
        }
        if (path > 0 && path <= 1200) {
            sb.append(AIDSPERATOR);
            sb.append(path);
        } else if (path > 1200 && !(tl1Path = TETL1AIDTranslateRuleMgr.getInstance().getTL1Path(boardType, String.valueOf(path))).isEmpty()) {
            sb.append(AIDSPERATOR);
            sb.append(tl1Path);
        }
        return sb.toString();
    }

    public static String isNull(String temp) {
        if (temp == null) {
            temp = "";
        }
        return temp;
    }

    public static String getAIDFrefix(int neid, int slotid, int portno) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        return TETL1CommonUtil.getAIDFrefix(neid, slotid, portno, boardType);
    }

    public static String getAIDFrefix(int neid, int slotid, int portno, int boardType) {
        TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, boardType);
        if (boardTypePro == null) {
            return "";
        }
        TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(portno);
        if (portPro != null && !portPro.aidFrefix.equals("")) {
            return portPro.aidFrefix;
        }
        if (portno < 50) {
            return "FAC";
        }
        return "";
    }

    public static int getAIDPortNo(int neid, int slotid, int portno) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        return TETL1CommonUtil.getAIDPortNo(neid, slotid, portno, boardType);
    }

    public static int getAIDPortNo(int neid, int slotid, int portno, int boardType) {
        TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, boardType);
        if (boardTypePro == null) {
            return portno;
        }
        TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(portno);
        int returnPortNo = 0;
        if (portPro != null) {
            returnPortNo = portno > 32768 ? Short.MIN_VALUE + portno : portPro.portOffset + portno;
        } else {
            TEPortParaRecord portPara = TEConfigurationDataMgr.getInstance().getPortParaRecord(neid, boardType, portno);
            if (portPara != null) {
                return portno;
            }
        }
        return returnPortNo;
    }

    public static String getPortShowStr(int neid, int slotid, int portno) {
        String portShowStr = "";
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        TESDCircuitPackRecord boardTypePro = TEConfigurationDataMgr.getInstance().getBoardTypeProperty(neid, boardType);
        if (boardTypePro == null) {
            return portShowStr;
        }
        TEInstallCPPortRecord portPro = boardTypePro.getPortProperty(portno);
        if (portPro != null) {
            portShowStr = portPro.aidFrefix;
            portShowStr = portShowStr + (portPro.portOffset + portno);
        }
        return portShowStr;
    }

    public static int getNMPortNOFromAidStruct(String aidSturct, int neID) {
        int portID;
        String[] aid = TETL1CommonUtil.parseAID(aidSturct, neID);
        int slotNMID = TETL1CommonUtil.getNMSlotStr(aidSturct, neID);
        try {
            portID = Integer.parseInt(aid[3]);
        }
        catch (Exception e) {
            portID = -1;
        }
        return TETL1CommonUtil.getNMPortNOFromNEPort(aid[0], slotNMID, portID, neID);
    }

    public static int getPathIDFromAidStruct(String aidSturct, int neID) {
        String[] aid = TETL1CommonUtil.parseAID(aidSturct, neID);
        int pathID = -1;
        try {
            pathID = Integer.parseInt(aid[4]);
        }
        catch (Exception e) {
            pathID = -1;
        }
        return pathID;
    }

    public static RowErrors createRowErrors(int neid, Fault fault, String monObj) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neid);
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = errorinfo.indexOf("LOGIN NOT ACTIVE") != -1 ? new Param("neObj", ne.getNEName()) : new Param("neObj", monObj);
        rowError.addParam(errorparam);
        return rowError;
    }

    public static RowErrors createRowErrors(Fault fault, String oper, String monObj) {
        String errorCode = fault.getErrCode();
        String errorinfo = fault.getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param(oper, monObj);
        rowError.addParam(errorparam);
        return rowError;
    }

    public static boolean isOperSuccess(TL1Operation operation, boolean isNullOutMsgValid) {
        OutMsg curOutput = null;
        String errorCode = "";
        int outMsgCount = operation.getOutMsgCount();
        if (outMsgCount == 0 && !isNullOutMsgValid) {
            return false;
        }
        int size = operation.getOutMsgCount();
        for (int i = 0; i < size; ++i) {
            curOutput = operation.getOutMsg(i);
            errorCode = curOutput.getFault().getErrCode();
            if (errorCode.equals("")) continue;
            return false;
        }
        return true;
    }

    public static void addErrorParams(Datainterface inputData, Datainterface outputData, int neid) {
        RowParams rowparams = null;
        Param param = null;
        RowErrors rowerror = null;
        if (outputData == null || outputData.getBussinessParams() == null || inputData == null) {
            return;
        }
        int rowCount = outputData.getBussinessParams().getRowParamsCount();
        if (rowCount == 0) {
            return;
        }
        rowparams = outputData.getBussinessParams().getRowParams(rowCount - 1);
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        String nename = neObj.getNEName();
        RowParams inputRow = inputData.getBussinessParams().getRowParams(0);
        String slotid = "UNKNOWN";
        String boardType = "";
        String boardname = "UNKNOWN";
        TEBoard board = null;
        if (inputRow != null && (param = inputRow.getParam("slotid")) != null && param.getValue() != null) {
            slotid = param.getValue();
            board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid));
            if (board != null) {
                boardname = board.getBoardName();
            } else {
                param = inputRow.getParam("boardType");
                if (param != null && param.getValue() != null) {
                    boardType = param.getValue();
                    boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, Integer.parseInt(boardType));
                }
            }
        }
        int size = rowparams.getRowErrorsCount();
        for (int i = 0; i < size; ++i) {
            rowerror = rowparams.getRowErrors(i);
            param = rowerror.getParam("nename");
            if (param == null) {
                param = new Param();
                param.setName("nename");
                param.setValue(nename);
                rowerror.addParam(param);
            } else {
                param.setValue(nename);
            }
            param = rowerror.getParam("slotid");
            if (param == null) {
                param = new Param();
                param.setName("slotid");
                param.setValue(TETL1CommonUtil.getShelfSlotName(neid, Integer.valueOf(slotid)));
                rowerror.addParam(param);
            } else {
                param.setValue(boardname);
            }
            param = rowerror.getParam("boardname");
            if (param == null) {
                param = new Param();
                param.setName("boardname");
                param.setValue(boardname);
                rowerror.addParam(param);
                continue;
            }
            param.setValue(boardname);
        }
    }

    public static ArrayList getCvlanRange(String cvlanInfo) {
        ArrayList<String> cvlanRange = new ArrayList<String>();
        if ("".equals(cvlanInfo) || AIDSPERATOR.equals(cvlanInfo)) {
            return null;
        }
        String[] str = cvlanInfo.split(",");
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            boolean b;
            boolean bl = b = str[i].indexOf(AIDSPERATOR) != -1;
            if (b) {
                String[] range = str[i].split(AIDSPERATOR);
                int rangeStart = Integer.parseInt(range[0]);
                int rangeEnd = Integer.parseInt(range[1]);
                for (int j = rangeStart; j <= rangeEnd; ++j) {
                    cvlanRange.add("" + j);
                }
                continue;
            }
            cvlanRange.add(str[i]);
        }
        return cvlanRange;
    }

    public static void addOperList(List list, TL1Operation operClone) {
        boolean flag = false;
        String mod1 = operClone.getMod1();
        String mod2 = operClone.getMod2();
        String aid = operClone.getInMsg().getStagBlock().getAID().getPart(0).getValue();
        MsgBlock operMsg = operClone.getInMsg().getMsgBlock();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)list.get(i);
            String operMod1 = oper.getMod1();
            String operMod2 = oper.getMod2();
            if (operMod2 == null || mod2 == null) {
                if (!operMod1.equals(mod1) || !oper.getInMsg().getStagBlock().getAID().getPart(0).getValue().equals(aid) || !TETL1CommonUtil.isMsgBlockEqual(operMsg, oper.getInMsg().getMsgBlock())) continue;
                flag = true;
                break;
            }
            if (!operMod1.equals(mod1) || !operMod2.equals(mod2) || !oper.getInMsg().getStagBlock().getAID().getPart(0).getValue().equals(aid) || !TETL1CommonUtil.isMsgBlockEqual(operMsg, oper.getInMsg().getMsgBlock())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            list.add(operClone);
        }
    }

    private static boolean isMsgBlockEqual(MsgBlock msgBlockA, MsgBlock msgBlockB) {
        try {
            int size = msgBlockA.getDataBlockCount();
            for (int i = 0; i < size; ++i) {
                DataBlock dataBlock = msgBlockA.getDataBlock(i);
                DataBlock dataBlockB = msgBlockB.getDataBlock(i);
                int len = dataBlock.getPartCount();
                for (int j = 0; j < len; ++j) {
                    Part partA = dataBlock.getPart(j);
                    Part partB = dataBlockB.getPart(j);
                    if (partA.getValue() == null && partB.getValue() != null || partA.getValue() != null && partB.getValue() == null) {
                        return false;
                    }
                    if (partA.getValue() == null || partB.getValue() == null || partA.getValue().equals(partB.getValue())) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getTL1CmdMod2(String operationStr) {
        String[] strArr = operationStr.split(AIDSPERATOR);
        String cmd = "";
        String mod1 = "";
        String neMod2 = "";
        if (strArr.length == 2) {
            cmd = strArr[0];
            neMod2 = strArr[1];
        } else if (strArr.length == 3) {
            cmd = strArr[0];
            mod1 = strArr[1];
            neMod2 = strArr[2];
        }
        String mod2 = neMod2.equals("OC3") || neMod2.equals("OC12") || neMod2.equals("OC48") || neMod2.equals("OC192") || neMod2.equals("OC768") || neMod2.equals("STM1") || neMod2.equals("STM4") || neMod2.equals("STM16") || neMod2.equals("STM64") || neMod2.equals("STM256") ? "OCN" : (neMod2.indexOf("OTU") != -1 ? "OTUN" : (neMod2.indexOf("ODU") != -1 ? "ODUN" : (neMod2.indexOf("FC") != -1 ? "FCMOD2" : (neMod2.equals("FICON") || neMod2.equals("FICON4G") || neMod2.equals("FICON8G") || neMod2.equals("FICONEXP") || neMod2.equals("HDSDI") || neMod2.equals("3GSDI") || neMod2.equals("DVBASI") || neMod2.equals("SDI") || neMod2.equals("ESCON") || neMod2.equals("FDDI") || neMod2.equals("EPON") || neMod2.equals("CPRI") || neMod2.equals("CPRICUT") || neMod2.equals("CLO") || neMod2.equals("ETR") || neMod2.equals("ISC1G") || neMod2.equals("ISC2G") || neMod2.equals("IBSDR") || neMod2.equals("IBDDR") || neMod2.equals("CPRI2457") || neMod2.equals("HDTV") || neMod2.equals("DVBSDI") || neMod2.equals("IBQDR") || neMod2.equals("CBR10G") || neMod2.equals("HDSDIRBR") || neMod2.equals("3GSDIRBR") ? "TRAFFICMOD2" : neMod2))));
        if (mod1.equals("")) {
            return cmd + AIDSPERATOR + mod2;
        }
        return cmd + AIDSPERATOR + mod1 + AIDSPERATOR + mod2;
    }

    public static boolean isNewNeVersion(int neType, String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        String[] ver = version.split("\\.");
        if (neType == 70) {
            if (ver[1].equals(newVersion)) {
                return true;
            }
            return version.compareTo(OLDNEVERSION_3800NA) > 0;
        }
        if (neType == 71) {
            if (ver[1].equals(newVersion)) {
                return true;
            }
            return version.compareTo(OLDNEVERSION_6800NA) > 0;
        }
        if (neType == 66) {
            if (ver[1].equals(newVersion_1800NA)) {
                return true;
            }
            return version.compareTo(OLDNEVERSION_1800NA) > 0;
        }
        return true;
    }

    public static String getRealMod2(TL1Operation oper) {
        if (oper.getMod2() == null || oper.getMod2().equals("")) {
            return oper.getMod1();
        }
        return oper.getMod2();
    }

    public static String processESC(String value) {
        String strTrans = "\\\"";
        if (value.length() >= 4 && value.startsWith("\\\"") && value.endsWith("\\\"")) {
            value = value.substring("\\\"".length());
            value = value.substring(0, value.length() - "\\\"".length());
        }
        return value;
    }

    public static void main(String[] args) {
        System.out.println(TETL1CommonUtil.processESC("\\\"\\\""));
        System.out.println(TETL1CommonUtil.processESC("\\\"111\\\""));
        System.out.println(TETL1CommonUtil.processESC("abc"));
    }

    public static boolean isFilterVCTrunkPort(int neid, int boardType, int nmCurrSlotID, int portNo) {
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neid);
        String shelfType = TEBoardUtil.getTl1SubrackType(neid, ne.getNEType(), nmCurrSlotID);
        return !(!shelfType.equalsIgnoreCase(OSN8800A) && !shelfType.equalsIgnoreCase(OSN8800AII) || boardType != 2110 && boardType != 2109 || portNo != 32771 && portNo != 32772);
    }

    public static ArrayList getUsableEthPortList(int neid, int slotNMID, TEAIDAndTypeList aidAndTypeList) {
        ArrayList ethPortList = new ArrayList();
        ethPortList.addAll(TETL1CommonUtil.getMacPortList(neid, slotNMID, aidAndTypeList));
        ethPortList.addAll(TETL1CommonUtil.getVCTrunkPortList(neid, slotNMID, aidAndTypeList));
        return ethPortList;
    }

    public static ArrayList getMacPortList(int neid, int slotNMID, TEAIDAndTypeList aidAndTypeList) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        int bdType = configurDataMgr.getBoardType(neid, slotNMID);
        ArrayList macPortList = TEConfigurationDataMgr.getInstance().getETHMACPort(neid, bdType);
        ArrayList<Integer> ethPortList = new ArrayList<Integer>();
        String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotNMID);
        ArrayList portList = (ArrayList)aidAndTypeList.getAidAndTypeMap().get(shelfSlotID);
        if (portList == null) {
            return ethPortList;
        }
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)portList.get(i);
            String pldType = aidType.getPldType();
            if (pldType.isEmpty() || pldType.indexOf("GETH") == -1 && pldType.indexOf("FETH") == -1) continue;
            String[] aidArr = TETL1CommonUtil.parseAID(aidType.getAid(), neid);
            int port = TETL1CommonUtil.getNMPortNOFromAidStruct(aidType.getAid(), neid);
            if (aidArr[0].equals("ACC") || !macPortList.contains(port) || ethPortList.contains(port)) continue;
            ethPortList.add(port);
        }
        return ethPortList;
    }

    public static ArrayList getVCTrunkPortList(int neid, int slotNMID, TEAIDAndTypeList aidAndTypeList) {
        ArrayList<Integer> ethPortList = new ArrayList<Integer>();
        String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotNMID);
        ArrayList portList = (ArrayList)aidAndTypeList.getAidAndTypeMap().get(shelfSlotID);
        if (portList == null) {
            return ethPortList;
        }
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int port;
            String[] aidArr;
            TEAIDAndType aidType = (TEAIDAndType)portList.get(i);
            String pldType = aidType.getPldType();
            if (pldType.isEmpty() || pldType.indexOf("GETH") == -1 && pldType.indexOf("FETH") == -1 || !(aidArr = TETL1CommonUtil.parseAID(aidType.getAid(), neid))[0].equals("ACC") || ethPortList.contains(port = Integer.parseInt(aidArr[3]) + 32768)) continue;
            ethPortList.add(port);
        }
        return ethPortList;
    }

    public static ArrayList createQueryBoardOperList(int neid, String aid) {
        try {
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile();
            ArrayList<TL1Operation> operList = new ArrayList<TL1Operation>();
            TL1Operation queryOper = definitions.getTL1Operation("RTRV-EQPT");
            InMsg input = queryOper.getInMsg();
            input.getPart("AID").setValue(aid);
            if (TETL1CommonUtil.isSupFilterTypeVersion(neid)) {
                MsgBlock msgBlock = input.getMsgBlock();
                DataBlock vDataBlock1 = new DataBlock();
                vDataBlock1.setParamType(ParamType.POS);
                msgBlock.addDataBlock(vDataBlock1);
                DataBlock vDataBlock2 = new DataBlock();
                vDataBlock2.setParamType(ParamType.NAMEPAIR);
                Part part2 = new Part();
                part2.setName("FILTER");
                part2.setType(PartType.STRING);
                part2.setValue("CARDTYPE");
                part2.setParamType(ParamType.NAMEPAIR);
                vDataBlock2.addPart(part2);
                msgBlock.addDataBlock(vDataBlock2);
                input.setMsgBlock(msgBlock);
            }
            operList.add(queryOper);
            return operList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("create aid error" + e);
            return null;
        }
    }

    private static boolean isSupFilterTypeVersion(int neid) {
        TENE ne = TENEListUtils.getNEObj(neid);
        String version = ne.getHostVersion();
        String[] ver = version.split("\\.");
        int neType = ne.getNEType();
        if (neType == 66) {
            return false;
        }
        if (neType == 70 ? ver[1].equals("70") : (neType == 71 || neType == 73 || neType == 75) && ver[1].equals("71")) {
            return false;
        }
        return version.compareTo("5.51.06.12") >= 0;
    }

    static {
        slotAIDBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof SlotObject) {
                    SlotObject obj = (SlotObject)key;
                    HashSet<Integer> slotSet = new HashSet<Integer>();
                    slotSet.add(obj.slotid);
                    ArrayList<TEErrInfo> errInfoList = new ArrayList<TEErrInfo>();
                    return TETL1CommonUtil.queryPortType(obj.neid, slotSet, errInfoList);
                }
                throw new TEUnknowmKeyTypeException(key.toString() + " is unkown key type!");
            }
        });
    }
}

