/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.cache.TETimeStatMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class TETL1BoardConfigurationDataMgr {
    public static final String GFP_OTU = "GFP_OTU";
    public static final String SDH_OTU = "SDH_OTU";

    private TETL1BoardConfigurationDataMgr() {
    }

    public static TEErrInfoReturn queryBoardMode(int neid, TIntArrayList slotIDList, TIntObjectHashMap<String> boardModeMap) {
        TEErrInfoReturn errReturn = new TEErrInfoReturn();
        TEErrInfo errInfo = null;
        if (null == slotIDList || slotIDList.isEmpty()) {
            return errReturn;
        }
        TL1Definitions tl1definitions = null;
        String boardMode = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            errReturn.setResult(2);
            errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neid});
            errInfo.setStrOperDesc("RTRV-PORT getOperation fail!");
            errInfo.setErrorCode(1090646019);
            errReturn.addErrInfo(errInfo);
            return errReturn;
        }
        int slotID = -1;
        String tmpAid = null;
        TL1Operation tmpTl1Operation = null;
        InMsg inputMsg = null;
        StagBlock stagBlock = null;
        AID aid = null;
        Part part = null;
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-EQPT");
        int len = slotIDList.size();
        for (int i = 0; i < len; ++i) {
            slotID = slotIDList.get(i);
            tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotID);
            tmpTl1Operation = (TL1Operation)tl1Operation.clone();
            inputMsg = tmpTl1Operation.getInMsg();
            stagBlock = inputMsg.getStagBlock();
            aid = stagBlock.getAID();
            part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList.add(tmpTl1Operation);
        }
        TL1Operation tOper = null;
        OutMsg output = null;
        HashMap partMap = null;
        String aidStr = null;
        Part mapModePart = null;
        String mapModeStr = null;
        int shelfID = -1;
        int relativeSlotID = -1;
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 10);
        if (0 == result.retCode) {
            int iLen = tl1OperList.size();
            for (int i = 0; i < iLen; ++i) {
                tOper = (TL1Operation)tl1OperList.get(i);
                aidStr = tOper.getInMsg().getPart("AID").getValue();
                String[] aidArray = TETL1CommonUtil.parseAID(aidStr, neid);
                shelfID = Integer.parseInt(aidArray[1]);
                relativeSlotID = Integer.parseInt(aidArray[2]);
                slotID = TETL1CommonUtil.getNMSlotStr(aidStr, neid);
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    output = tOper.getOutMsg(row);
                    if (0 == output.getFault().getCompletionCode()) {
                        partMap = TETL1CommonUtil.getOutMsgPart(output);
                        Part phyPart = (Part)partMap.get("WORKMODE");
                        if (null != phyPart) {
                            boardMode = TETL1CommonUtil.isNull(phyPart.getValue());
                        } else {
                            mapModePart = (Part)partMap.get("MAPMODE");
                            if (null != mapModePart) {
                                mapModeStr = mapModePart.getValue();
                                if (-1 != mapModeStr.indexOf("GFP")) {
                                    boardMode = GFP_OTU;
                                } else if (-1 != mapModeStr.indexOf("SDH")) {
                                    boardMode = SDH_OTU;
                                }
                            }
                        }
                        boardModeMap.put(slotID, (Object)boardMode);
                        continue;
                    }
                    TETL1BoardConfigurationDataMgr.constructErrInfo(neid, shelfID, relativeSlotID, output, errReturn);
                }
            }
        }
        return errReturn;
    }

    private static void constructErrInfo(int neid, int shelfID, int relativeSlotID, OutMsg output, TEErrInfoReturn errReturn) {
        Fault fault = output.getFault();
        int errorCode = fault.getCompletionCode();
        String errorDesc = fault.getErrDesc();
        errReturn.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(new int[]{neid, shelfID, relativeSlotID});
        errInfo.setStrOperDesc(errorDesc);
        errInfo.setErrorCode(errorCode);
        errReturn.addErrInfo(errInfo);
    }

    public static void queryBoardPortMode(int neid, int slotID, int bdtype, String boardMode, TIntObjectHashMap<String> portModeMap, List<TEErrInfo> errInfoList) {
        TEErrInfo errInfo = null;
        TL1Definitions tl1definitions = null;
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
        }
        catch (Exception e) {
            errInfo = new TEErrInfo();
            int shelfID = TEBoardUtil.getRelativeShelfID(slotID);
            int relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
            errInfo.setObjID(new int[]{neid, shelfID, relativeSlotID});
            errInfo.setErrorCode(1090646019);
            errInfoList.add(errInfo);
            TELogFactory.getNormalLogger().error("RTRV-CLNT getOperation fail!", (Throwable)e);
            return;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-CLNT");
        int port = 0;
        if (bdtype == 2280 || bdtype == 2296) {
            port = 8;
        } else if (bdtype == 2279) {
            port = 16;
        } else if (bdtype == 2297) {
            port = 2;
        } else if (bdtype == 2315) {
            port = 4;
        }
        for (int i = 1; i <= port; ++i) {
            String tmpAid = "CLNT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotID) + "-" + i + "-" + 1;
            TL1Operation tmpTl1Operation = (TL1Operation)tl1Operation.clone();
            InMsg inputMsg = tmpTl1Operation.getInMsg();
            StagBlock stagBlock = inputMsg.getStagBlock();
            AID aid = stagBlock.getAID();
            Part part = aid.getPart(0);
            part.setValue(tmpAid);
            tl1OperList.clear();
            tl1OperList.add(tmpTl1Operation);
            TETimeStatMgr timer = new TETimeStatMgr(TETimeStatMgr.FLAG_LOG);
            timer.startStat("get tl1 board mode. size->" + tl1OperList.size());
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, tl1OperList, 60);
            timer.stopStat();
            if (result.retCode == 0) {
                TL1Operation tOper = (TL1Operation)tl1OperList.get(0);
                String typeStr = "";
                int portID = 0;
                int errCode = -1;
                int shelfID = -1;
                int relativeSlotID = -1;
                int size = tOper.getOutMsgCount();
                for (int row = 0; row < size; ++row) {
                    OutMsg output = tOper.getOutMsg(row);
                    errCode = output.getFault().getCompletionCode();
                    if (0 == errCode) {
                        HashMap partMap = TETL1CommonUtil.getOutMsgPart(output);
                        String aidStr = ((Part)partMap.get("AID")).getValue();
                        if (!aidStr.equals(tmpAid)) continue;
                        Part phyPart = (Part)partMap.get("WORKMODE");
                        if (phyPart != null) {
                            typeStr = TETL1CommonUtil.isNull(phyPart.getValue());
                        }
                        portID = TETL1CommonUtil.getNMPortNOFromAidStruct(aidStr, neid);
                        continue;
                    }
                    errInfo = new TEErrInfo();
                    shelfID = TEBoardUtil.getRelativeShelfID(slotID);
                    relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
                    errInfo.setObjID(new int[]{neid, shelfID, relativeSlotID, i});
                    errInfo.setErrorCode(errCode);
                    errInfoList.add(errInfo);
                }
                portModeMap.put(portID, (Object)typeStr);
                continue;
            }
            errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neid, slotID});
            errInfo.setErrorCode(1090646019);
            errInfoList.add(errInfo);
        }
    }

    public static int getRelativeShelfID(int cnemgrSlotID) {
        return cnemgrSlotID / 65536;
    }
}

