/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.tl1.TETL1CommonUtil;

public class TETL1AID {
    private String tl1Aid = "";
    private int neid = -1;
    private int shelfID = -1;
    private int slotID = -1;
    private int portID = -1;
    private int pathID = -1;
    private String aidPre = "";

    public TETL1AID(int neid, String tl1Aid) {
        this.neid = neid;
        this.tl1Aid = tl1Aid;
        this.initAidParam();
    }

    public TETL1AID(String aidPre, int neid, int shelfID, int slotID, int portID, int pathID) {
        this.aidPre = aidPre;
        this.neid = neid;
        this.shelfID = shelfID;
        this.pathID = pathID;
        this.portID = portID;
        this.slotID = slotID;
        this.initTL1AidStr();
    }

    private void initAidParam() {
        String[] aidStrArray = TETL1CommonUtil.parseAID(this.tl1Aid, this.neid);
        this.aidPre = aidStrArray[0];
        try {
            this.shelfID = Integer.parseInt(aidStrArray[1]);
            this.slotID = Integer.parseInt(aidStrArray[2]);
            this.portID = Integer.parseInt(aidStrArray[3]);
            this.pathID = Integer.parseInt(aidStrArray[4]);
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("NEID:" + this.neid + " AID: " + this.tl1Aid + "format error.", (Throwable)e);
        }
    }

    private void initTL1AidStr() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.aidPre);
        if (this.isMultiShelf()) {
            sb.append("-");
            sb.append(this.shelfID);
        }
        if (this.slotID > 0) {
            sb.append("-");
            sb.append(this.slotID);
        } else {
            TELogFactory.getNormalLogger().error("AID slot is Error: " + this.slotID);
        }
        if (this.portID > 0) {
            sb.append("-");
            sb.append(this.portID);
        }
        if (this.pathID > 0) {
            sb.append("-");
            sb.append(this.pathID);
        }
        this.tl1Aid = sb.toString();
    }

    public String toString() {
        return this.tl1Aid;
    }

    public String getTl1Aid() {
        return this.tl1Aid;
    }

    public int getNeid() {
        return this.neid;
    }

    public int getShelfID() {
        return this.shelfID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getPortID() {
        return this.portID;
    }

    public int getPathID() {
        return this.pathID;
    }

    public String getAidPre() {
        return this.aidPre;
    }

    public boolean isMultiShelf() {
        return TETL1CommonUtil.hasShelfNE(this.neid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aidPre == null ? 0 : this.aidPre.hashCode());
        result = 31 * result + this.neid;
        result = 31 * result + this.pathID;
        result = 31 * result + this.portID;
        result = 31 * result + this.shelfID;
        result = 31 * result + this.slotID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TETL1AID)) {
            return false;
        }
        TETL1AID other = (TETL1AID)obj;
        if (this.aidPre == null ? other.aidPre != null : !this.aidPre.equals(other.aidPre)) {
            return false;
        }
        if (this.neid != other.neid) {
            return false;
        }
        if (this.pathID != other.pathID) {
            return false;
        }
        if (this.portID != other.portID) {
            return false;
        }
        if (this.shelfID != other.shelfID) {
            return false;
        }
        return this.slotID == other.slotID;
    }
}

