/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEBoardTypeConvertUtil {
    private int neType;
    private String hostVersion;
    private SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
    private static TEBoardTypeConvertUtil instance = null;

    public static synchronized TEBoardTypeConvertUtil getInstance() {
        if (instance == null) {
            instance = new TEBoardTypeConvertUtil();
        }
        return instance;
    }

    public int getNeType() {
        return this.neType;
    }

    public void setNeType(int neType) {
        this.neType = neType;
    }

    public String getHostVersion() {
        return this.hostVersion;
    }

    public void setHostVersion(String hostVersion) {
        this.hostVersion = hostVersion;
    }

    public List getPortListByBoardType(int boardType) {
        List list = this.getPortList(boardType);
        return list;
    }

    public List getPortList(int boardType) {
        List list = new ArrayList();
        NodeList nodeList = this.parseChannelViewXML();
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)nodeList.item(i);
                String cpType = element.getAttribute("cp_type");
                if (boardType != this.mgr.parseInt(cpType)) continue;
                NodeList bdTypeList = element.getElementsByTagName("cptype");
                list = bdTypeList != null && bdTypeList.getLength() != 0 ? this.readPortFromElement((Element)bdTypeList.item(0)) : this.readPortFromElement(element);
            }
        }
        return list;
    }

    private List readPortFromElement(Element element) {
        ArrayList<Port> list = new ArrayList<Port>();
        NodeList nodeList = element.getElementsByTagName("port_aid");
        if (nodeList != null) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element portElement = (Element)nodeList.item(i);
                String portNoListStr = portElement.getAttribute("port_no");
                ArrayList portNolist = new ArrayList();
                TENEListUtils.getNumList(portNoListStr, portNolist);
                int nn = portNolist.size();
                for (int ii = 0; ii < nn; ++ii) {
                    Port port = new Port();
                    port.setPortid(Integer.valueOf(String.valueOf(portNolist.get(ii))));
                    NodeList channelList = portElement.getElementsByTagName("item");
                    this.setChannelToPort(channelList, port);
                    list.add(port);
                }
            }
        }
        return list;
    }

    private void setChannelToPort(NodeList channelList, Port port) {
        int n = channelList.getLength();
        for (int i = 0; i < n; ++i) {
            Element portElement = (Element)channelList.item(i);
            String fb_type = portElement.getAttribute("fb_type");
            String mod2 = "";
            mod2 = fb_type.indexOf("FB_DYN_PAYLOAD") != -1 ? "ALL" : this.getAidFromFb(fb_type);
            String location = portElement.getAttribute("location");
            if (!location.equals("")) {
                ArrayList clannelNolist = new ArrayList();
                TENEListUtils.getNumList(location, clannelNolist);
                int nn = clannelNolist.size();
                for (int ii = 0; ii < nn; ++ii) {
                    if (mod2.indexOf("TCM") != -1) {
                        port.addTcmToList(mod2 + "-" + clannelNolist.get(ii));
                    } else {
                        port.addMod2ToList(mod2 + "-" + clannelNolist.get(ii));
                    }
                    if (fb_type.indexOf("FB_DYN_PAYLOAD_TCM") == -1) continue;
                    port.setDynTcmSupportPath(fb_type);
                    port.addTcmToList("ODUNTCM-" + clannelNolist.get(ii));
                }
                continue;
            }
            if (mod2.indexOf("TCM") != -1) {
                port.addTcmToList(mod2);
            } else {
                port.addMod2ToList(mod2);
            }
            if (fb_type.equals("FB_DYN_SIGNAL")) {
                port.addMod2ToList("OC");
                port.addMod2ToList("OCH");
                port.addMod2ToList("EC");
            }
            if (fb_type.indexOf("FB_DYN_PAYLOAD_TCM") == -1) continue;
            port.setDynTcmSupportPath(fb_type);
            port.addTcmToList("ODUNTCM");
        }
    }

    public String getAidFromFb(String fb) {
        return TEFuncBlockDescription.getInstance().getFBTypeName(this.mgr.parseInt(fb));
    }

    private NodeList parseChannelViewXML() {
        NodeList nodelist = null;
        Document doc = null;
        String filePath = TEResourceManager.getPath() + File.separator + TEGetFilePath.getFilePath(this.neType, this.hostVersion, "conf" + File.separator + "aid_description.xml");
        try {
            doc = TEParseXMLFile.parseFile(filePath);
            nodelist = doc.getElementsByTagName("circuitpack_desc");
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TEBoardTypeConvertUtil.parseChannelViewXML() fail!", (Throwable)ex);
        }
        return nodelist;
    }

    public class Port {
        private List mod2List = new ArrayList();
        private int portid = -1;
        private List tcmList = new ArrayList();
        private String dynTcmSupportPath = "";

        public String getDynTcmSupportPath() {
            return this.dynTcmSupportPath;
        }

        public void setDynTcmSupportPath(String dynTcmSupportPath) {
            this.dynTcmSupportPath = dynTcmSupportPath;
        }

        public List getMod2List() {
            return this.mod2List;
        }

        public void setMod2List(List mod2List) {
            this.mod2List = mod2List;
        }

        public void addTcmToList(String tcmMod2) {
            this.tcmList.add(tcmMod2);
        }

        public void addMod2ToList(String mod2) {
            this.mod2List.add(mod2);
        }

        public int getPortid() {
            return this.portid;
        }

        public void setPortid(int portid) {
            this.portid = portid;
        }

        public List getTcmList() {
            return this.tcmList;
        }

        public void setTcmList(List tcmList) {
            this.tcmList = tcmList;
        }
    }
}

