/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEAlarmKey;
import com.huawei.nglct.nelist.TENEListConstant;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.tl1.TEBoardSupportAlarmAID;
import com.huawei.nglct.tl1.TEBoardSupportAlarmData;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEBoardSupportAlarmMgr {
    private static TEBoardSupportAlarmMgr instance = null;
    private HashMap boardSupportAlarm = new HashMap();
    private HashMap almDataMap = null;

    private TEBoardSupportAlarmMgr() {
        if (this.boardSupportAlarm.isEmpty()) {
            this.parseXML("boardsupportalm_nawdm");
            this.parseXML("boardsupportalm_nawdm_MARINE");
        }
    }

    public static synchronized TEBoardSupportAlarmMgr getInstance() {
        if (instance == null) {
            instance = new TEBoardSupportAlarmMgr();
        }
        return instance;
    }

    private void parseXML(String filename) {
        StringBuffer tl1Path = new StringBuffer("").append(File.separator).append("nemgr").append(File.separator).append("tl1necommon").append(File.separator).append("conf").append(File.separator).append(filename).append(".xml");
        try {
            this.almDataMap = TENEListConstant.getInstance().getTL1NMAlmData();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            File f = TEResourceManager.getFileByName("com.huawei.weblct.tl1necommon", tl1Path.toString());
            sp.parse(f, (DefaultHandler)new PaserAlarmHandler());
        }
        catch (SAXException e) {
            TELogFactory.getNormalLogger().error("TEBoardSupportAlarmMgr.parseXML() fail!", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            TELogFactory.getNormalLogger().error("TEBoardSupportAlarmMgr.parseXML() fail!", (Throwable)e);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TEBoardSupportAlarmMgr.parseXML() fail!", (Throwable)e);
        }
    }

    public HashMap getBoardSupportFBAlarm(int boardType) {
        HashMap boardSupportAlarmFB = (HashMap)this.boardSupportAlarm.get(new Integer(boardType));
        if (boardSupportAlarmFB == null) {
            return new HashMap();
        }
        block0: for (Map.Entry entry : boardSupportAlarmFB.entrySet()) {
            TEBoardSupportAlarmAID aid = (TEBoardSupportAlarmAID)entry.getKey();
            ArrayList almList = (ArrayList)entry.getValue();
            int size = almList.size();
            for (int i = 0; i < size; ++i) {
                boolean t_AlmFlag;
                int aeID;
                TEBoardSupportAlarmData boarddAlmData = (TEBoardSupportAlarmData)almList.get(i);
                int eqType = boarddAlmData.getEqType();
                TEAlarmKey almKey = new TEAlarmKey(eqType, aeID = boarddAlmData.getAeID());
                TEAlarmData almData = (TEAlarmData)this.almDataMap.get(almKey);
                if (almData == null || almData.getAeName() == null || !(t_AlmFlag = almData.getAeName().startsWith("T-", 0))) continue;
                aid.setSupportT_Alm(t_AlmFlag);
                continue block0;
            }
        }
        return boardSupportAlarmFB;
    }

    public ArrayList getBoardSupportAllAlarm(int boardType) {
        HashMap map = this.getBoardSupportFBAlarm(boardType);
        ArrayList supportAlarmList = new ArrayList();
        Object[] obj = map.values().toArray();
        int len = obj.length;
        for (int i = 0; i < len; ++i) {
            supportAlarmList.addAll((ArrayList)obj[i]);
        }
        return supportAlarmList;
    }

    public ArrayList getBoardSupportAlarmFBList(int boardType) {
        ArrayList<Object> fbList = new ArrayList<Object>();
        HashMap map = this.getBoardSupportFBAlarm(boardType);
        Object[] obj = map.keySet().toArray();
        int size = obj.length;
        for (int i = 0; i < size; ++i) {
            fbList.add(obj[i]);
        }
        return fbList;
    }

    public ArrayList getBoardSupportAlarmFromFB(int boardType, int fbType) {
        ArrayList temp;
        HashMap map = this.getBoardSupportFBAlarm(boardType);
        if (map != null && (temp = (ArrayList)map.get(new Integer(fbType))) != null) {
            return temp;
        }
        return new ArrayList();
    }

    class PaserAlarmHandler
    extends DefaultHandler {
        PaserAlarmHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("param")) {
                TEBoardSupportAlarmAID almAID;
                int brdType = Integer.parseInt(attributes.getValue("BrdType"));
                int eqType = Integer.parseInt(attributes.getValue("EqType"));
                int aeID = Integer.parseInt(attributes.getValue("AeID"));
                int fbType = Integer.parseInt(attributes.getValue("FbType"));
                int portID = Integer.parseInt(attributes.getValue("PortID"));
                int pathID = Integer.parseInt(attributes.getValue("PathID"));
                TEBoardSupportAlarmData boardsupportalarmData = new TEBoardSupportAlarmData(brdType, eqType, aeID, fbType, portID, pathID);
                HashMap<TEBoardSupportAlarmAID, ArrayList<TEBoardSupportAlarmData>> boardSupportMap = (HashMap<TEBoardSupportAlarmAID, ArrayList<TEBoardSupportAlarmData>>)TEBoardSupportAlarmMgr.this.boardSupportAlarm.get(new Integer(brdType));
                if (boardSupportMap == null) {
                    boardSupportMap = new HashMap<TEBoardSupportAlarmAID, ArrayList<TEBoardSupportAlarmData>>();
                    TEBoardSupportAlarmMgr.this.boardSupportAlarm.put(new Integer(brdType), boardSupportMap);
                }
                if ((almAID = this.getAIDStructFromAE(aeID, eqType, portID, pathID)) != null) {
                    ArrayList<TEBoardSupportAlarmData> supportList = (ArrayList<TEBoardSupportAlarmData>)boardSupportMap.get(almAID);
                    if (supportList == null) {
                        supportList = new ArrayList<TEBoardSupportAlarmData>();
                        boardSupportMap.put(almAID, supportList);
                    }
                    supportList.add(boardsupportalarmData);
                }
            }
        }

        private TEBoardSupportAlarmAID getAIDStructFromAE(int aeID, int eqType, int portID, int pathID) {
            int aidType;
            TEAlarmKey almKey = new TEAlarmKey(eqType, aeID);
            TEAlarmData almData = (TEAlarmData)TEBoardSupportAlarmMgr.this.almDataMap.get(almKey);
            if (almData == null) {
                return null;
            }
            TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
            String mod2Name = fbDesc.getMOD2(aidType = almData.getAIDType());
            if (mod2Name.equals("")) {
                return null;
            }
            TEBoardSupportAlarmAID aid = new TEBoardSupportAlarmAID(mod2Name, portID, pathID);
            aid.setAidPreFix(fbDesc.getAIDPrefix(aidType));
            return aid;
        }
    }
}

