/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

public class TEBoardState {
    private static final int TL1COMMON_SST_NULL = 0;
    private static final int TL1COMMON_SST_FAF = 1;
    private static final int TL1COMMON_SST_SGEO = 2;
    private static final int TL1COMMON_SST_UEQ = 4;
    private static final int TL1COMMON_SST_MEA = 0;
    private static final int TL1COMMON_SST_FLT = 16;
    private static final int TL1COMMON_SST_UAS = 32;
    private static final int TL1COMMON_SST_TS = 256;
    private static final int TL1COMMON_SST_AINS = 512;
    private static final int TL1COMMON_SST_MT = 1024;
    private static final int TL1COMMON_SST_LPBK = 2048;
    private static final int TL1COMMON_SST_UEQ_UAS = 36;
    private static final int TL1COMMON_SST_TS_FAF = 257;
    private static final int TL1COMMON_SST_TS_SGEO = 258;
    private static final int TL1COMMON_SST_AINS_FAF = 513;
    private static final int TL1COMMON_SST_AINS_SGEO = 514;
    private static final int TL1COMMON_SST_AINS_UEQ = 516;
    private static final int TL1COMMON_SST_AINS_MEA = 512;
    private static final int TL1COMMON_SST_AINS_FLT = 528;
    private static final int TL1COMMON_SST_MT_FAF = 1025;
    private static final int TL1COMMON_SST_MT_SGEO = 1026;
    private static final int TL1COMMON_SST_MT_TS = 1280;
    private static final int TL1COMMON_SST_MT_TS_FAF = 1281;
    private static final int TL1COMMON_SST_MT_TS_SGEO = 1282;
    private static final int TL1COMMON_SST_MT_LPBK = 3072;
    private static final int TL1COMMON_SST_MT_LPBK_FAF = 3073;
    private static final int TL1COMMON_SST_MT_LPBK_SGEO = 3074;
    private static final int TL1COMMON_SST_MASK = 4095;
    private static final int OS_UNKNOWN = 255;
    private static final int TL1COMMON_PST_IS_NR = 0;
    private static final int TL1COMMON_PST_OOS_AU = 1;
    private static final int TL1COMMON_PST_OOS_MA = 2;
    private static final int TL1COMMON_PST_OOS_AUMA = 3;
    private static final String SONET_PST_IS_NR = "0";
    private static final String SONET_PST_OOS_AU = "1";
    private static final String SONET_PST_OOS_MA = "2";
    private static final String SONET_PST_OOS_AUMA = "3";
    private static final String SONET_SST_NULL = "0";
    private static final String SONET_SST_FAF = "1";
    private static final String SONET_SST_SGEO = "2";
    private static final String SONET_SST_UEQ = "4";
    private static final String SONET_SST_MEA = "8";
    private static final String SONET_SST_FLT = "16";
    private static final String SONET_SST_UAS = "32";
    private static final String SONET_SST_TS = "256";
    private static final String SONET_SST_AINS = "512";
    private static final String SONET_SST_MT = "1024";
    private static final String SONET_SST_LPBK = "2048";
    private static final String SONET_SST_ACT = "4096";
    private static final String SONET_SST_STBYC = "8192";
    private static final String SONET_SST_STBYH = "16384";
    private static final String SONET_SST_SWDL = "32768";

    public static int getBoardState(int nPST, int nSST) {
        int pathOperatinalState = 255;
        nSST &= 0xFFF;
        if (nPST == 0) {
            pathOperatinalState = nSST == 0 || nSST == 256 ? 16 : 16;
        } else if (nPST == 1) {
            pathOperatinalState = nSST == 0 || nSST == 1 || nSST == 2 || nSST == 257 || nSST == 258 ? 20 : (nSST == 512 || nSST == 513 || nSST == 514 ? 18 : (nSST == 4 ? 19 : (nSST == 0 || nSST == 16 ? 20 : (nSST == 516 || nSST == 512 || nSST == 528 ? 18 : 20))));
        } else if (nPST == 2) {
            pathOperatinalState = nSST == 0 ? 17 : (nSST == 1024 || nSST == 1280 || nSST == 3072 ? 24 : (nSST == 32 ? 21 : 17));
        } else if (nPST == 3) {
            pathOperatinalState = nSST == 0 || nSST == 1 || nSST == 2 ? 17 : (nSST == 1025 || nSST == 1026 || nSST == 1281 || nSST == 1282 || nSST == 3073 || nSST == 3074 ? 24 : (nSST == 4 || nSST == 0 || nSST == 16 ? 17 : (nSST == 36 ? 22 : 17)));
        }
        return pathOperatinalState;
    }

    public static int setStateInPSTANDSST(String pst, String sst) {
        if (pst.equals("INITIALIZING")) {
            return 18;
        }
        int pstNum = Integer.parseInt(TEBoardState.getNumByState(pst));
        int sstNum = 0;
        if (sst != null) {
            String[] ssts = sst.split("&");
            int n = ssts.length;
            for (int i = 0; i < n; ++i) {
                sstNum |= Integer.parseInt(TEBoardState.getNumByState(ssts[i]));
            }
        }
        int state = TEBoardState.getBoardState(pstNum, sstNum);
        return state;
    }

    private static String getNumByState(String pstORsst) {
        if (pstORsst == null) {
            return "-1";
        }
        if (pstORsst.equals("IS")) {
            return "0";
        }
        if (pstORsst.equals("IS-NR")) {
            return "0";
        }
        if (pstORsst.equals("OOS-AU")) {
            return "1";
        }
        if (pstORsst.equals("OOS-MA")) {
            return "2";
        }
        if (pstORsst.equals("OOS-AUMA")) {
            return SONET_PST_OOS_AUMA;
        }
        if (pstORsst.equals("")) {
            return "0";
        }
        if (pstORsst.equals("FAF")) {
            return "1";
        }
        if (pstORsst.equals("SGEO")) {
            return "2";
        }
        if (pstORsst.equals("UEQ")) {
            return SONET_SST_UEQ;
        }
        if (pstORsst.equals("MEA")) {
            return SONET_SST_MEA;
        }
        if (pstORsst.equals("FLT")) {
            return SONET_SST_FLT;
        }
        if (pstORsst.equals("UAS")) {
            return SONET_SST_UAS;
        }
        if (pstORsst.equals("TS")) {
            return SONET_SST_TS;
        }
        if (pstORsst.equals("AINS")) {
            return SONET_SST_AINS;
        }
        if (pstORsst.equals("MT")) {
            return SONET_SST_MT;
        }
        if (pstORsst.equals("LPBK")) {
            return SONET_SST_LPBK;
        }
        if (pstORsst.equals("ACT")) {
            return SONET_SST_ACT;
        }
        if (pstORsst.equals("STBYC")) {
            return SONET_SST_STBYC;
        }
        if (pstORsst.equals("STBYH")) {
            return SONET_SST_STBYH;
        }
        if (pstORsst.equals("SWDL")) {
            return SONET_SST_SWDL;
        }
        return "-1";
    }
}

