/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.tl1;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TETL1AIDKey;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TEAIDAndType;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.uflight.tl1.tl1operation.Fault;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TEAIDAndTypeList {
    private HashMap aidAndTypeMap = new HashMap();
    public static final int AID_PREFIX = 0;
    public static final int SHELF = 1;
    private int slotPos = 2;
    private int portPos = 3;
    private int pathPos = 4;
    private int aidArrLength = 4;
    private HashMap errorMap = new HashMap();
    private TETL1AIDTranslateRuleMgr instance = TETL1AIDTranslateRuleMgr.getInstance();

    public void add(int neid, TEAIDAndType aidAndType) {
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String shelfSlot = null;
        if (bShelfNE) {
            shelfSlot = aidAndType.getAidArr()[1] + "-" + aidAndType.getAidArr()[this.slotPos];
        } else {
            this.slotPos = 1;
            shelfSlot = aidAndType.getAidArr()[this.slotPos];
        }
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(shelfSlot);
        if (aidAndTypeList == null) {
            aidAndTypeList = new ArrayList();
        }
        this.addAidTypeToList(aidAndTypeList, aidAndType);
        this.aidAndTypeMap.put(shelfSlot, aidAndTypeList);
    }

    private void addAidTypeToList(ArrayList aidAndTypeList, TEAIDAndType aidAndType) {
        boolean addFlag = true;
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            String tempStr;
            TEAIDAndType aidtype = (TEAIDAndType)aidAndTypeList.get(i);
            if (!aidtype.getAid().equalsIgnoreCase(aidAndType.getAid()) || !aidtype.getAidArr()[0].equalsIgnoreCase("CLNT")) continue;
            if (!aidAndType.getType().equals("")) {
                tempStr = aidtype.getType().equals("") ? aidAndType.getType() : aidAndType.getType() + "|" + aidtype.getType();
                aidtype.setType(tempStr);
            }
            if (!aidAndType.getPldType().equals("")) {
                tempStr = aidtype.getPldType().equals("") ? aidAndType.getPldType() : aidAndType.getPldType() + "|" + aidtype.getPldType();
                aidtype.setpldType(tempStr);
            }
            addFlag = false;
            break;
        }
        if (addFlag) {
            aidAndTypeList.add(aidAndType);
        }
    }

    public String getAID(int neid, int slot, int port) {
        String aid = "";
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = "" + TETL1CommonUtil.getAIDPortNo(neid, slot, port);
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.aidArrLength = 3;
            }
            if (aidArr.length != this.aidArrLength || !aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot)) continue;
            return aidType.getAid();
        }
        return aid;
    }

    public String getAID(int neid, int slot, int port, int path) {
        String aid = "";
        ArrayList aidAndTypeList4 = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList4 == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList4.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList4.get(i);
            String[] aidArr4 = ((TEAIDAndType)aidAndTypeList4.get(i)).getAidArr();
            if (!bShelfNE ? aidArr4.length < 4 : aidArr4.length < 5) continue;
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.pathPos = 3;
            }
            if (!aidArr4[0].equalsIgnoreCase(aidFrefix) || new Integer(aidArr4[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot) || !aidArr4[this.portPos].equals(neport) || new Integer(aidArr4[this.pathPos]) != path) continue;
            return aidType.getAid();
        }
        return aid;
    }

    public String getMod2(int neid, int slot, int port) {
        String aid = "";
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList == null) {
            return aid;
        }
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.aidArrLength = 3;
            }
            if (aidArr.length != this.aidArrLength || !aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot)) continue;
            if (aidArr[0].equalsIgnoreCase("FAC") || bdtype == 1542 && aidArr[0].equals("SRV3") || (bdtype == 2213 || bdtype == 2430) && aidArr[0].equals("SRV4")) {
                return aidType.getType();
            }
            return aidType.getPldType();
        }
        return aid;
    }

    public ArrayList getActTypeMod2List(int neid, int slot, int port) {
        String facMode2 = this.getMod2(neid, slot, port);
        ArrayList<String> list = new ArrayList<String>();
        if (!facMode2.equals("") && facMode2.indexOf("NA") == -1) {
            StringTokenizer st = new StringTokenizer(facMode2, "|");
            while (st.hasMoreTokens()) {
                String modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        return list;
    }

    public String getMod2(String aid_pre, int neid, int slot, int port) {
        String aid = "";
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = aid_pre;
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.aidArrLength = 3;
            }
            if (aidArr.length != this.aidArrLength || !aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot)) continue;
            return aidType.getType();
        }
        return aid;
    }

    public String getPayLoadMod2(int neid, int slot, int port) {
        int brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        String aid = "";
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.aidArrLength = 3;
            }
            if (aidArr.length != this.aidArrLength || !aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot)) continue;
            if (this.instance.isSimpleBoard(brdType) && aidFrefix.equalsIgnoreCase("FAC") && aidType.getPldType().equals("USETYPESTR") && aidType.getType().equals("USETYPESTR")) {
                return aidType.getOtnType();
            }
            return aidType.getPldType();
        }
        return aid;
    }

    public String getTypeStr(int neid, int slot, int port, int path) {
        String aid = "";
        ArrayList aidAndTypeList1 = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList1 == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList1.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList1.get(i);
            String[] aidArr1 = ((TEAIDAndType)aidAndTypeList1.get(i)).getAidArr();
            if (!bShelfNE ? aidArr1.length < 4 : aidArr1.length < 5) continue;
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.pathPos = 3;
            }
            if (!aidArr1[0].equalsIgnoreCase(aidFrefix) || new Integer(aidArr1[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot) || !aidArr1[this.portPos].equals(neport) || path > 0 && Integer.parseInt(aidArr1[this.pathPos]) != path) continue;
            return aidType.getOtnType();
        }
        return aid;
    }

    public String getMod2(int neid, int slot, int port, int path) {
        String aid = "";
        ArrayList aidAndTypeList2 = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList2 == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList2.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList2.get(i);
            String[] aidArr2 = ((TEAIDAndType)aidAndTypeList2.get(i)).getAidArr();
            if (!bShelfNE ? aidArr2.length < 4 : aidArr2.length < 5) continue;
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.pathPos = 3;
            }
            if (!aidArr2[0].equalsIgnoreCase(aidFrefix) || new Integer(aidArr2[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot) || !aidArr2[this.portPos].equals(neport) || new Integer(aidArr2[this.pathPos]) != path) continue;
            if (aidArr2[0].equalsIgnoreCase("FAC")) {
                return aidType.getType();
            }
            return aidType.getPldType();
        }
        return aid;
    }

    public ArrayList getActTypeMod2List(int neid, int slot, int port, int path) {
        if (path == 0 || path == -1) {
            return this.getActTypeMod2List(neid, slot, port);
        }
        String facMode2 = this.getMod2(neid, slot, port, path);
        ArrayList<String> list = new ArrayList<String>();
        if (!facMode2.equals("") && facMode2.indexOf("NA") == -1) {
            StringTokenizer st = new StringTokenizer(facMode2, "|");
            while (st.hasMoreTokens()) {
                String modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        return list;
    }

    public String getPayLoadMod2(int neid, int slot, int port, int path) {
        int brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        String aid = "";
        ArrayList aidAndTypeList3 = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList3 == null) {
            return aid;
        }
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList3.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType3 = (TEAIDAndType)aidAndTypeList3.get(i);
            String[] aidArr3 = ((TEAIDAndType)aidAndTypeList3.get(i)).getAidArr();
            if (!bShelfNE ? aidArr3.length < 4 : aidArr3.length < 5) continue;
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.pathPos = 3;
            }
            if (!aidArr3[0].equalsIgnoreCase(aidFrefix) || new Integer(aidArr3[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot) || !aidArr3[this.portPos].equals(neport) || new Integer(aidArr3[this.pathPos]) != path) continue;
            if (this.instance.isSimpleBoard(brdType) && aidFrefix.equalsIgnoreCase("FAC") && aidType3.getPldType().equals("USETYPESTR") && aidType3.getType().equals("USETYPESTR")) {
                return aidType3.getOtnType();
            }
            return aidType3.getPldType();
        }
        return aid;
    }

    private boolean isSupportAddMode(String mode2) {
        if (mode2.indexOf("ODU") != -1) {
            return true;
        }
        return mode2.indexOf("NA") == -1;
    }

    public ArrayList<String> getPLDTYPEMod2List(int neid, int slotid, int portid, int pathid) {
        ArrayList<String> list = new ArrayList<String>();
        String pldMode2 = "";
        pldMode2 = pathid <= 0 ? this.getPayLoadMod2(neid, slotid, portid) : this.getPayLoadMod2(neid, slotid, portid, pathid);
        if (!pldMode2.equals("") && this.isSupportAddMode(pldMode2)) {
            StringTokenizer st = new StringTokenizer(pldMode2, "|");
            while (st.hasMoreTokens()) {
                String modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        return list;
    }

    public ArrayList getAllMod2(int neid, int slot, int port, int path) {
        String typeMode2;
        String modifier;
        StringTokenizer st;
        String facMode2 = this.getMod2(neid, slot, port, path);
        String pldMode2 = this.getPayLoadMod2(neid, slot, port, path);
        ArrayList<String> list = new ArrayList<String>();
        if (!facMode2.equals("") && this.isSupportAddMode(facMode2)) {
            st = new StringTokenizer(facMode2, "|");
            while (st.hasMoreTokens()) {
                modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        if (!pldMode2.equals("") && this.isSupportAddMode(pldMode2)) {
            st = new StringTokenizer(pldMode2, "|");
            while (st.hasMoreTokens()) {
                modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        String aidPre = TETL1CommonUtil.getAIDFrefix(neid, slot, port, path);
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        if (TETL1AIDTranslateRuleMgr.getInstance().isSimpleBoard(bdtype) && aidPre.equalsIgnoreCase("FAC") && !(typeMode2 = this.getTypeStr(neid, slot, port, path)).equals("") && this.isSupportAddMode(typeMode2)) {
            StringTokenizer st2 = new StringTokenizer(typeMode2, "|");
            while (st2.hasMoreTokens()) {
                String modifier2 = st2.nextToken();
                if (list.contains(modifier2)) continue;
                list.add(modifier2);
            }
        }
        return list;
    }

    public ArrayList getAllMod2(int neid, int slot, int port) {
        String typeMode2;
        String modifier;
        StringTokenizer st;
        String facMode2 = this.getMod2(neid, slot, port);
        String pldMode2 = this.getPayLoadMod2(neid, slot, port);
        ArrayList<String> list = new ArrayList<String>();
        if (!facMode2.equals("") && this.isSupportAddMode(facMode2)) {
            st = new StringTokenizer(facMode2, "|");
            while (st.hasMoreTokens()) {
                modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        if (!pldMode2.equals("") && this.isSupportAddMode(pldMode2)) {
            st = new StringTokenizer(pldMode2, "|");
            while (st.hasMoreTokens()) {
                modifier = st.nextToken();
                if (list.contains(modifier)) continue;
                list.add(modifier);
            }
        }
        int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slot);
        String aidPre = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        if (TETL1AIDTranslateRuleMgr.getInstance().isSimpleBoard(bdtype) && aidPre.equalsIgnoreCase("FAC") && !(typeMode2 = this.getTypeStr(neid, slot, port, -1)).equals("") && this.isSupportAddMode(typeMode2)) {
            StringTokenizer st2 = new StringTokenizer(typeMode2, "|");
            while (st2.hasMoreTokens()) {
                String modifier2 = st2.nextToken();
                if (list.contains(modifier2)) continue;
                list.add(modifier2);
            }
        }
        return list;
    }

    public String getPayLoadMod2(int neid, String aid) {
        String mod2 = "";
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String[] aidArr = TETL1CommonUtil.parseAID(aid, neid);
        String shelfSlot = null;
        shelfSlot = bShelfNE ? aidArr[1] + "-" + aidArr[2] : aidArr[2];
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(shelfSlot);
        if (aidAndTypeList == null) {
            return mod2;
        }
        for (TEAIDAndType aidType : aidAndTypeList) {
            if (!aidType.getAid().equals(aid)) continue;
            mod2 = aidType.getPldType();
            break;
        }
        return mod2;
    }

    public String getMod2(int neid, String aid) {
        String mod2 = "";
        boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
        String[] aidArr = TETL1CommonUtil.parseAID(aid, neid);
        String shelfSlot = null;
        shelfSlot = bShelfNE ? aidArr[1] + "-" + aidArr[2] : aidArr[2];
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(shelfSlot);
        if (aidAndTypeList == null) {
            return mod2;
        }
        for (TEAIDAndType aidType : aidAndTypeList) {
            if (!aidType.getAid().equals(aid)) continue;
            if (aid.toUpperCase().indexOf("FAC") != -1) {
                return aidType.getType();
            }
            return aidType.getPldType();
        }
        return mod2;
    }

    public ArrayList getPortPayloadMod2(int neid, int slot, int port) {
        ArrayList<TETL1AIDKey> payloadList = new ArrayList<TETL1AIDKey>();
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slot));
        if (aidAndTypeList == null) {
            return payloadList;
        }
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slot, port);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slot, port));
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            String pldMode2;
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            String aid = ((TEAIDAndType)aidAndTypeList.get(i)).getAid();
            boolean bShelfNE = TETL1CommonUtil.hasShelfNE(neid);
            if (!bShelfNE) {
                this.slotPos = 1;
                this.portPos = 2;
                this.pathPos = 3;
            }
            if (!aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slot) || (pldMode2 = aidType.getPldType()).equals("")) continue;
            StringTokenizer st = new StringTokenizer(pldMode2, "|");
            while (st.hasMoreTokens()) {
                TETL1AIDKey aidKey;
                String modifier = st.nextToken();
                if (modifier.equals("NA") || modifier.equals("UNEQ") || payloadList.contains(aidKey = new TETL1AIDKey(neid, aid, modifier))) continue;
                payloadList.add(aidKey);
            }
        }
        return payloadList;
    }

    public int getPortPathID(int neid, int slotId, int portId, String _mod2) {
        int brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotId);
        String mod2 = this.convertExcLevelToPldType(_mod2);
        ArrayList aidAndTypeList = (ArrayList)this.aidAndTypeMap.get(TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neid, slotId));
        int pathID = -1;
        if (aidAndTypeList == null) {
            return pathID;
        }
        String aidFrefix = TETL1CommonUtil.getAIDFrefix(neid, slotId, portId);
        String neport = String.valueOf(TETL1CommonUtil.getAIDPortNo(neid, slotId, portId));
        int size = aidAndTypeList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDAndType aidType = (TEAIDAndType)aidAndTypeList.get(i);
            String[] aidArr = ((TEAIDAndType)aidAndTypeList.get(i)).getAidArr();
            if (!aidArr[0].equalsIgnoreCase(aidFrefix) || !aidArr[this.portPos].equals(neport) || new Integer(aidArr[this.slotPos]) != TETL1CommonUtil.slotIDNMToNESlotID(slotId)) continue;
            String curMod2 = "";
            if (this.instance.isSimpleBoard(brdType) && aidFrefix.equalsIgnoreCase("FAC")) {
                curMod2 = aidType.getOtnType();
            } else {
                String pldMode2 = aidType.getPldType();
                if (pldMode2.equals("")) {
                    return -1;
                }
                StringTokenizer st = new StringTokenizer(pldMode2, "|");
                curMod2 = st.countTokens() > 1 && _mod2.indexOf("ODU") == -1 && st.nextToken().indexOf("ODU") != -1 ? st.nextToken() : pldMode2;
            }
            if (curMod2.indexOf(mod2) == -1) continue;
            try {
                pathID = Integer.parseInt(aidArr[4]);
            }
            catch (Exception e) {
                pathID = -1;
            }
            return pathID;
        }
        return pathID;
    }

    private String convertExcLevelToPldType(String _mod2) {
        if (_mod2.equalsIgnoreCase("STS3")) {
            return "OC3";
        }
        if (_mod2.equalsIgnoreCase("STS12")) {
            return "OC12";
        }
        if (_mod2.equalsIgnoreCase("STS48")) {
            return "OC48";
        }
        if (_mod2.equalsIgnoreCase("STS192")) {
            return "OC192";
        }
        if (_mod2.equalsIgnoreCase("STS768")) {
            return "OC768";
        }
        return _mod2;
    }

    public int size() {
        return this.aidAndTypeMap.size();
    }

    public HashMap getAidAndTypeMap() {
        return this.aidAndTypeMap;
    }

    public void setAidAndTypeMap(HashMap aidAndTypeMap) {
        this.aidAndTypeMap = aidAndTypeMap;
    }

    public void addFaultInfo(int slot, Fault fault) {
        this.errorMap.put(new Integer(slot), fault);
    }

    public Fault getFaultInfo(int slot) {
        return (Fault)this.errorMap.get(new Integer(slot));
    }

    public int getErrorCount() {
        return this.errorMap.size();
    }
}

