/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.sysmanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TESysManagerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1822892684112509804L;
    private static final String CONTENT_TYPE = "text/xml";
    private static final String SFID_PARAM = "sfid";
    private static final int QUERY_VERSION_CMD = 11037;
    private static final int QUERY_JVMSTACK_CMD = 11038;
    private Datainterface output = null;
    private int sfid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TELogInfo loginfo = new TELogInfo();
        try {
            loginfo.setUserID(123);
            loginfo.setCmdID(11037);
            loginfo.setLocation(request.getRemoteAddr());
            loginfo.setOperateObject("");
            loginfo.setOperateDesc("");
            loginfo.setResult(0);
            this.sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
            TELogFactory.getNormalLogger().info("sfid = \u00a3\u00ba" + this.sfid);
            switch (this.sfid) {
                case 11037: {
                    this.output = TESysManagerBean.getInstance().getVersionInfo();
                    break;
                }
                case 11038: {
                    TESystemUtil.exportCurrentJVMStack();
                    this.output = new Datainterface();
                    this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                    break;
                }
            }
        }
        catch (Exception e) {
            loginfo.setResult(2);
            TELogFactory.getNormalLogger().error("Query version fail\u00a3\u00a1", (Throwable)e);
            this.output = new Datainterface();
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        TELogMgr.writeLog(loginfo);
        response.setContentType(CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        StringWriter stringout = new StringWriter();
        PrintWriter print = response.getWriter();
        if (!this.output.isValid()) {
            this.output = new Datainterface();
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        try {
            this.output.marshal(stringout);
            TELogFactory.getInterfaceLogger().info("Query version\u00a3\u00ba" + stringout.toString());
            print.println(stringout.toString());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse fail\u00a3\u00a1", (Throwable)e);
            return;
        }
        finally {
            if (null != stringout) {
                stringout.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

