/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.sysmanager;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.jni.usercfginfo.TEJNIGetUserCfgInfoService;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.IFileProvider;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.appmanager.api.IAppManager;
import com.huawei.uflight.security.sysusermgr.api.ISysUserMgr;
import com.huawei.uflight.security.sysusermgr.api.SysUserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TESysManagerBean {
    private static final String SUB_SYSTEM_NAME = "TRANS";
    private static final String CFG_ITEM_NAME = "slotModeflg";
    private static final String SYS_FILE_NAME = "system.xml";
    private static final String NELIST_FILE_NAME = "nelistinfo.xml";
    private static final String DEV_SUPPORT_DESCRIPTION_FILE_NAME = "devsupportdescrib.ini";
    private static final String PAKAGE_PATH = TEResourceManager.getPath() + TEPathManager.PACKAGE_PATH + "device" + File.separator;
    private static TESysManagerBean instance = null;
    private static Logger log = TELogFactory.getCommuLogger();
    private static Map<String, String> propertiesmap = new HashMap<String, String>();
    private String context;
    private String sysFileName = "DefaultCodeset.xml";
    private String emsFileName = "trans_ems.cfg";
    private IAppManager appMgr;
    private ISysUserMgr userMgr;
    private static final int DEFAULT_TIMEOUT = 60;

    private TESysManagerBean() {
        this.loadSysFile();
        this.initAppManager();
        if (TESysManagerConstants.SYS_SINGLE_STATUS != this.getSysStauts() && this.getM2000() == 0) {
            this.loadT2000ImapCfg();
            this.loadT2000SlotMode();
        } else {
            TimeZoneDateBean.getTimeFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadT2000SlotMode() {
        String sysConfEnv = System.getenv("IMAP_ROOT") + File.separator + "var" + File.separator + "trans" + File.separator + "core" + File.separator + "conf";
        String imapPath = sysConfEnv + File.separator + this.emsFileName;
        Properties imapPro = new Properties();
        FileInputStream imapStream = null;
        try {
            imapStream = new FileInputStream(imapPath);
            imapPro.load(imapStream);
            String t2000slotMode = imapPro.getProperty(CFG_ITEM_NAME);
            TELogFactory.getNormalLogger().info("read t2000slotmode = " + t2000slotMode);
            if (null == t2000slotMode) {
                return;
            }
            int slotMode = Integer.parseInt(t2000slotMode);
            propertiesmap.put("slotMode", String.valueOf(slotMode));
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("replace language Fail!", (Throwable)ex);
        }
        finally {
            try {
                if (null != imapStream) {
                    imapStream.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("loadT2000SlotMode Fail!", (Throwable)e);
            }
        }
    }

    public static synchronized TESysManagerBean getInstance() {
        if (null == instance) {
            instance = new TESysManagerBean();
        }
        return instance;
    }

    public String getProperty(String key) {
        if (null != propertiesmap) {
            return propertiesmap.get(key);
        }
        return null;
    }

    public String getlanguage() {
        String language = this.getProperty("language");
        if (null == language) {
            return "";
        }
        if (!language.equals("zh") && !language.equals("en")) {
            language = "zh";
        }
        return language;
    }

    public int getServerSSLMode() {
        int serverSSLMode = 0;
        String sslModeStr = this.getProperty("serverSSLMode");
        if (null != sslModeStr && !sslModeStr.isEmpty()) {
            serverSSLMode = Integer.parseInt(sslModeStr);
        }
        return serverSSLMode;
    }

    public DeploymentMode getSysStauts() {
        DeploymentMode deploymentMode = TESysManagerConstants.SYS_SINGLE_STATUS;
        try {
            if (this.appMgr != null && (deploymentMode = this.appMgr.getDeploymentMode()) != TESysManagerConstants.SYS_SINGLE_STATUS && deploymentMode != TESysManagerConstants.SYS_INTEGRATION_STATUS) {
                deploymentMode = TESysManagerConstants.SYS_SINGLE_STATUS;
            }
        }
        catch (Exception e) {
            log.error("Get system status fail!", (Throwable)e);
            deploymentMode = TESysManagerConstants.SYS_SINGLE_STATUS;
        }
        return deploymentMode;
    }

    public boolean isIntegratedStatus() {
        if (null == this.appMgr) {
            return false;
        }
        DeploymentMode deploymentMode = this.appMgr.getDeploymentMode();
        return deploymentMode == TESysManagerConstants.SYS_INTEGRATION_STATUS;
    }

    public int getM2000() {
        String strM2000 = this.getProperty("M2000");
        if (null != strM2000) {
            return Integer.valueOf(strM2000);
        }
        return 0;
    }

    public String getSysVersion() {
        return this.getProperty("version");
    }

    public String getSysUser() {
        String username = this.getProperty("username");
        if (null == username || username.equals("")) {
            username = "admin";
        }
        return username;
    }

    private void setSysUser(String userName) {
        if (null != propertiesmap) {
            propertiesmap.put("username", userName);
        }
    }

    public boolean verifyPassword(String username, byte[] password) {
        boolean passFlg = false;
        this.userMgr = this.getUserMgr();
        if (null != this.userMgr) {
            char[] charPwd = EncryptUtils.encodePlainText(password);
            String strPwd = EncryptUtils.encryptAESChar2Str(charPwd);
            passFlg = this.userMgr.verifyUser(username, strPwd);
            EncryptUtils.clearChar(charPwd);
        }
        if (passFlg) {
            this.setSysUser(username);
        }
        return passFlg;
    }

    public int modifyPassword(String userName, byte[] oldPassword, byte[] newPassword) {
        this.userMgr = this.getUserMgr();
        if (null != this.userMgr) {
            char[] charOldPwd = EncryptUtils.encodePlainText(oldPassword);
            char[] charNewPwd = EncryptUtils.encodePlainText(newPassword);
            int result = this.userMgr.modifyPassword(userName, EncryptUtils.encryptAESChar2Str(charOldPwd), EncryptUtils.encryptAESChar2Str(charNewPwd));
            EncryptUtils.clearChar(charOldPwd);
            EncryptUtils.clearChar(charNewPwd);
            return result;
        }
        return 2;
    }

    private ISysUserMgr getUserMgr() {
        ServiceReference service;
        BundleContext context;
        if (null == this.userMgr && null != (context = FrameworkUtil.getBundle(TESysManagerBean.class).getBundleContext()) && null != (service = context.getServiceReference(ISysUserMgr.class.getName()))) {
            this.userMgr = (ISysUserMgr)context.getService(service);
        }
        return this.userMgr;
    }

    public String getIsEncrypt() {
        return this.getProperty("isencrypt");
    }

    public String getIslocal() {
        return this.getProperty("islocal");
    }

    public int getSaveLogType() {
        String logtypeStr = this.getProperty("savelogtype");
        int logtype = 0;
        try {
            logtype = Integer.parseInt(logtypeStr);
            if (logtype != 0 && logtype != 1) {
                logtype = 0;
            }
        }
        catch (Exception e) {
            logtype = 0;
            log.error("Log type is wrong\u00a3\u00a1", (Throwable)e);
        }
        return logtype;
    }

    public int getLogSize() {
        String logSizeStr = this.getProperty("savelogsize");
        int logSize = 1;
        try {
            logSize = Integer.parseInt(logSizeStr);
        }
        catch (Exception e) {
            logSize = 1;
            log.error("Log size is wrong\u00a3\u00a1", (Throwable)e);
        }
        return logSize;
    }

    public int getJSLogFlag() {
        String flag = this.getProperty("jsLogFlag");
        if (flag == null || !flag.equals(String.valueOf(1)) && !flag.equals(String.valueOf(0))) {
            flag = String.valueOf(1);
        }
        return Integer.parseInt(flag);
    }

    public String encodeMsg(String msg) {
        String str = null;
        try {
            str = URLEncoder.encode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TESysManagerBean.encodeMsg() fail!", (Throwable)e);
        }
        return str;
    }

    public int getSlotMode() {
        String mode = String.valueOf(0);
        if (TESysManagerConstants.SYS_SINGLE_STATUS != this.getSysStauts() && this.getM2000() == 0) {
            String modeDB = TEJNIGetUserCfgInfoService.getUserCfgInfo(SUB_SYSTEM_NAME, CFG_ITEM_NAME);
            mode = modeDB != null && !modeDB.isEmpty() ? modeDB : this.getProperty("slotMode");
        }
        if (mode == null || !mode.equals(String.valueOf(0)) && !mode.equals(String.valueOf(1))) {
            mode = String.valueOf(0);
        }
        return Integer.parseInt(mode);
    }

    public int getShowGrade() {
        String flag = this.getProperty("showgrade");
        if (flag == null || !flag.equals(String.valueOf(0)) && !flag.equals(String.valueOf(1))) {
            flag = String.valueOf(0);
        }
        return Integer.parseInt(flag);
    }

    public int getNEUserTerminalType() {
        String neUserTerminalType = this.getProperty("neuserterminaltype");
        if (null != neUserTerminalType) {
            return Integer.parseInt(neUserTerminalType);
        }
        return 2;
    }

    public int getExplorerBeanTimeout() {
        String explorerBeanTimeout = this.getProperty("explorerBeanTimeout");
        if (null != explorerBeanTimeout) {
            return Integer.parseInt(explorerBeanTimeout);
        }
        return 60;
    }

    public Datainterface getVersionInfo() {
        File file;
        ServiceReference[] refs;
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        RowParams rowparams = new RowParams();
        Param devverParam = new Param("dev_version", "");
        Param softverParam = new Param("soft_version", this.getSysVersion());
        rowparams.addParam(devverParam);
        rowparams.addParam(softverParam);
        output.getBussinessParams().addRowParams(rowparams);
        Bundle commonBd = FrameworkUtil.getBundle(TEResourceManager.class);
        BundleContext context = commonBd.getBundleContext();
        try {
            refs = context.getServiceReferences(IFileProvider.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            TELogFactory.getNormalLogger().error("TESysManagerBean.getVersionInfo() fail!", (Throwable)e);
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            return output;
        }
        if (refs == null) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            return output;
        }
        Bundle bundle = null;
        String filepath = "";
        for (ServiceReference ref : refs) {
            bundle = ref.getBundle();
            try {
                filepath = TEResourceManager.getFileRealPath(bundle, PAKAGE_PATH);
            }
            catch (Exception e) {
                continue;
            }
            file = new File(filepath);
            if (filepath.isEmpty() || !file.exists() || !file.isDirectory()) continue;
            this.getVersionDetail(file, output);
        }
        Bundle pnpBundle = TERWCfgFile.getBundleBySymbolicName("com.huawei.weblct.pnp");
        if (null != pnpBundle) {
            try {
                filepath = TEResourceManager.getFileRealPath(pnpBundle, PAKAGE_PATH);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TESysManagerBean.getVersionInfo() fail!", (Throwable)e);
            }
            file = new File(filepath);
            if (!filepath.isEmpty() && file.exists() && file.isDirectory()) {
                this.getVersionDetail(file, output);
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return output;
    }

    private void getVersionDetail(File file, Datainterface output) {
        File[] fileArr = file.listFiles();
        File tmp = null;
        File stmp = null;
        File desFile = null;
        StringBuffer path = null;
        for (int i = fileArr.length - 1; i >= 0; --i) {
            tmp = fileArr[i];
            File[] tmpFile = tmp.listFiles();
            if (tmpFile == null) continue;
            for (int j = tmpFile.length - 1; j >= 0; --j) {
                stmp = tmpFile[j];
                if (!stmp.isDirectory()) continue;
                File[] tFiles = stmp.listFiles();
                int m = tFiles.length;
                for (int k = 0; k < m; ++k) {
                    if (!tFiles[k].isDirectory()) continue;
                    if (tFiles[k].getName().equalsIgnoreCase("conf")) {
                        path = new StringBuffer(TEPathManager.PACKAGE_PATH).append("device").append(File.separator).append(tmp.getName()).append(File.separator).append(stmp.getName()).append(File.separator).append(tFiles[k].getName()).append(File.separator).append(DEV_SUPPORT_DESCRIPTION_FILE_NAME);
                        desFile = new File(file.getParentFile().getParent() + File.separator + path.toString());
                        if (!desFile.exists()) continue;
                        this.parseNEVersionParam(output, path.toString());
                        continue;
                    }
                    path = new StringBuffer(TEPathManager.PACKAGE_PATH).append("device").append(File.separator).append(tmp.getName()).append(File.separator).append(stmp.getName()).append(File.separator).append(tFiles[k].getName()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(DEV_SUPPORT_DESCRIPTION_FILE_NAME);
                    desFile = new File(file.getParentFile().getParent() + File.separator + path.toString());
                    if (!desFile.exists()) continue;
                    this.parseNEVersionParam(output, path.toString());
                }
            }
        }
    }

    private void parseNEVersionParam(Datainterface output, String path) {
        TEResourceUtil res = TEResourceUtil.getInstance(path);
        String[] versions = res.getString("ne_version", "ne_version").split(",");
        String neTypeName = res.getString("ne_type_name", "ne_type_name");
        String devSupportVersion = res.getString("devsupport_version", "devsupport_version");
        int len = versions.length;
        for (int i = 0; i < len; ++i) {
            RowParams rowparams = new RowParams();
            Param itemParam = new Param("item", neTypeName);
            Param devverParam = new Param("dev_version", versions[i]);
            Param softverParam = new Param("soft_version", devSupportVersion);
            rowparams.addParam(itemParam);
            rowparams.addParam(devverParam);
            rowparams.addParam(softverParam);
            output.getBussinessParams().addRowParams(rowparams);
        }
    }

    public String getLanguageFromNMS() {
        String nmslanguage = "";
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            String sysConfEnv = System.getenv("IMAP_ROOT");
            String sysPath = sysConfEnv + File.separator + "platform" + File.separator + "conf" + File.separator + this.sysFileName;
            File file = new File(sysPath);
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setCoalescing(true);
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(file);
            NodeList childNodeList = doc.getElementsByTagName("param");
            Element element = null;
            for (int i = childNodeList.getLength() - 1; i >= 0; --i) {
                element = (Element)childNodeList.item(i);
                if (!element.hasAttribute("name") || !element.getAttribute("name").equals("language")) continue;
                nmslanguage = element.getTextContent();
            }
            String[] languages = nmslanguage.split("_");
            if (languages.length >= 2) {
                nmslanguage = languages[0];
            }
        }
        catch (Exception e) {
            TELogFactory.getStartupLogger().error("Parse System Config File Fail\u00a3\u00a1", (Throwable)e);
        }
        return nmslanguage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadT2000ImapCfg() {
        FileOutputStream fos = null;
        try {
            this.loadT2000SSLMode();
            String nmslanguage = this.getLanguageFromNMS();
            TELogFactory.getNormalLogger().info("read NMSLang = " + nmslanguage);
            if (null != nmslanguage && (nmslanguage.equalsIgnoreCase("zh") || nmslanguage.equalsIgnoreCase("en")) && !this.getlanguage().equalsIgnoreCase(nmslanguage)) {
                TELogFactory.getNormalLogger().info("replace language " + this.getlanguage() + " to NMS language " + nmslanguage);
                this.setLocalEnv(nmslanguage.toLowerCase());
                propertiesmap.put("language", nmslanguage.toLowerCase());
                StringBuffer filePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(SYS_FILE_NAME);
                String fileListPath = TEPathManager.CONFIG_PROFILE_PATH + NELIST_FILE_NAME;
                File sysFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
                File lockFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, fileListPath);
                DocumentBuilderFactory builderFactory = null;
                DocumentBuilder builder = null;
                Document doc = null;
                builderFactory = DocumentBuilderFactory.newInstance();
                builderFactory.setIgnoringComments(false);
                builderFactory.setIgnoringElementContentWhitespace(true);
                builderFactory.setCoalescing(true);
                builder = builderFactory.newDocumentBuilder();
                fos = new FileOutputStream(lockFile.getPath());
                FileLock fl = fos.getChannel().tryLock();
                if (fl == null) {
                    TELogFactory.getNormalLogger().error(filePath.toString() + " is already locked");
                    fos.close();
                    return;
                }
                doc = builder.parse(sysFile);
                NodeList systemconfig = doc.getElementsByTagName("language");
                Element languageinfo = (Element)systemconfig.item(0);
                languageinfo.getFirstChild().setNodeValue(nmslanguage.toLowerCase());
                boolean isDelFileSuccess = sysFile.delete();
                if (isDelFileSuccess) {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Transformer transformer = tFactory.newTransformer();
                    DOMSource source = new DOMSource(doc);
                    StreamResult result = new StreamResult(new File(sysFile.getAbsolutePath()));
                    transformer.transform(source, result);
                    TELogFactory.getNormalLogger().info("succeeded to write server language to system.xml");
                } else {
                    TELogFactory.getNormalLogger().error("faile to delete " + sysFile.getName());
                }
                fl.release();
                fos.close();
                fos = null;
                TELogFactory.getNormalLogger().info("file clock release");
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("replace language Fail!", (Throwable)ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("fos closed Fail!", (Throwable)e);
                }
            }
        }
    }

    private void setLocalEnv(String lang) {
        if ("zh".endsWith(lang)) {
            Locale.setDefault(Locale.CHINA);
        } else {
            Locale.setDefault(Locale.US);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadT2000SSLMode() {
        FileInputStream imapFIS = null;
        try {
            String imapEnv = System.getenv("IMAP_CONFIG_PATH");
            String imapPath = imapEnv + File.separator + "imap.cfg";
            Properties imapPro = new Properties();
            imapFIS = new FileInputStream(imapPath);
            imapPro.load(imapFIS);
            String sslModeKey = "SSLMode";
            String serverSSLMode = imapPro.getProperty("SSLMode");
            propertiesmap.put("serverSSLMode", serverSSLMode);
        }
        catch (Exception e) {
            TELogFactory.getStartupLogger().error("loadT2000SSLMode fail!", (Throwable)e);
        }
        finally {
            try {
                if (imapFIS != null) {
                    imapFIS.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getStartupLogger().error("loadT2000SSLMode fail!", (Throwable)e);
            }
        }
    }

    public void loadSysFile() {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        StringBuffer filePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(SYS_FILE_NAME);
        TELogFactory.getStartupLogger().info("start to load systemconfig file:" + filePath);
        Document doc = null;
        try {
            File SysCfgFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
            for (int counter = 0; !(SysCfgFile != null && SysCfgFile.exists() || counter > 10); ++counter) {
                Thread.sleep(1000L);
                SysCfgFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
            }
            URI uri = SysCfgFile.toURI();
            InputStream in = uri.toURL().openStream();
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setCoalescing(true);
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(in);
            in.close();
        }
        catch (Exception e) {
            TELogFactory.getStartupLogger().error("Parse System Config File Fail!", (Throwable)e);
            return;
        }
        this.parseNode(doc.getFirstChild());
    }

    private void initAppManager() {
        BundleContext context = FrameworkUtil.getBundle(TEResourceManager.class).getBundleContext();
        if (null == context) {
            return;
        }
        ServiceReference refs = context.getServiceReference(IAppManager.class.getName());
        if (null == refs) {
            return;
        }
        this.appMgr = (IAppManager)context.getService(refs);
    }

    public void parseNode(Node node) {
        NodeList childNodeList = node.getChildNodes();
        Node childNode = null;
        String key = null;
        String value = null;
        if (null != childNodeList && childNodeList.getLength() > 0) {
            for (int i = childNodeList.getLength() - 1; i >= 0; --i) {
                childNode = childNodeList.item(i);
                if (childNode.getNodeType() != 1) continue;
                if (childNode.hasChildNodes() && childNode.getChildNodes().getLength() > 1) {
                    this.parseNode(childNode);
                    continue;
                }
                key = childNode.getNodeName();
                value = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : childNode.getNodeValue();
                propertiesmap.put(key, value);
                TELogFactory.getStartupLogger().info("systemconfig info:[" + key + "=" + value + "]");
            }
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public SysUserInfo getSysUserInfo(String userName) {
        this.userMgr = this.getUserMgr();
        if (null != this.userMgr) {
            List users = this.userMgr.getSysUsers();
            int len = users.size();
            for (int i = 0; i < len; ++i) {
                SysUserInfo user = (SysUserInfo)users.get(i);
                if (!user.getUserName().equals(userName)) continue;
                return user;
            }
        }
        return null;
    }

    public boolean isForceChangePwd() {
        String loginfirst = this.getProperty("loginfirst");
        return loginfirst == null || !loginfirst.equals("0");
    }

    public void setForceChangePwd(boolean bFirst) {
        try {
            StringBuffer filePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(SYS_FILE_NAME);
            File sysFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
            DocumentBuilderFactory builderFactory = null;
            DocumentBuilder builder = null;
            Document doc = null;
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(false);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setCoalescing(true);
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(sysFile);
            NodeList loginfirstList = doc.getElementsByTagName("loginfirst");
            Element loginfirst = null;
            String value = bFirst ? "1" : "0";
            propertiesmap.put("loginfirst", value);
            if (loginfirstList.getLength() == 0) {
                NodeList rootList = doc.getElementsByTagName("systemconfig");
                if (rootList.getLength() > 0) {
                    loginfirst = doc.createElement("loginfirst");
                    loginfirst.appendChild(doc.createTextNode(value));
                    rootList.item(0).appendChild(loginfirst);
                }
            } else {
                loginfirst = (Element)loginfirstList.item(0);
                loginfirst.getFirstChild().setNodeValue(value);
            }
            boolean isDelFileSuccess = sysFile.delete();
            if (isDelFileSuccess) {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(sysFile.getAbsolutePath()));
                transformer.transform(source, result);
                TELogFactory.getNormalLogger().info("succeeded to write server language to system.xml");
            } else {
                TELogFactory.getNormalLogger().error("faile to delete " + sysFile.getName());
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("setForceChangePwd flag Fail!", (Throwable)ex);
        }
    }

    public int getAppProcID() {
        int procID = -1;
        if (this.appMgr != null) {
            AppEntity appEntity = this.appMgr.getAppByBundle(FrameworkUtil.getBundle(TEResourceManager.class));
            if (appEntity == null) {
                TELogFactory.getNormalLogger().warn("appEntity is null!");
                return -1;
            }
            String tempID = appEntity.getAppParam("UrlProcID", new String[0]);
            if (tempID != null) {
                procID = Integer.valueOf(tempID);
            }
        }
        return procID;
    }

    public int getAppPorcHandle() {
        int procHandle = -1;
        if (this.appMgr != null) {
            AppEntity appEntity = this.appMgr.getAppByBundle(FrameworkUtil.getBundle(TEResourceManager.class));
            if (appEntity == null) {
                TELogFactory.getNormalLogger().warn("appEntity is null!");
                return -1;
            }
            String tempHandle = appEntity.getAppParam("UrlProcHandle", new String[0]);
            if (tempHandle != null) {
                procHandle = Integer.valueOf(tempHandle);
            }
        }
        return procHandle;
    }
}

