/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.sysmanager;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaReq;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaRsp;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.nemanager.TETL1NELoginMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.qxprotocol.QxNEConnectInfo;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEHandleSbiInfo {
    private static final int EMS_TERMINAL_TYPE = 1;
    private static final int NE_LOGIN_OK = 1;
    private static final char PROC_ID_COMMON = '\u00b2';
    private static final int COMM_TCP = 1;
    private static final int COMM_SSL = 4;
    private static final byte[] KEY = new byte[]{89, 69, 75, 48, 48, 48, 50, 84};
    private static final byte[] ADD_ENCRPT_STR = new byte[]{68, 50, 67, 56, 49, 50, 55, 56, 68, 70, 53, 65, 65, 67, 53, 53};
    private static final int TL1NEID_MASK = 0x4000000;
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private String sbiUserName = null;
    private String sbiPassword = null;
    private String sbiAddr = null;
    private String sbiPort = null;
    private int sbiSoketType = -1;
    private boolean isFromFile = false;
    private boolean isFromJni = true;
    private static TEHandleSbiInfo instance = null;

    private TEHandleSbiInfo() {
    }

    public static synchronized TEHandleSbiInfo getInstance() {
        if (null == instance) {
            instance = new TEHandleSbiInfo();
        }
        return instance;
    }

    public synchronized boolean handleSBIConnectOnInter(int neID) {
        String sbiCommStr;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return false;
        }
        if (1 == ne.getLogStatus() && 0 == ne.getIsTL1OrQX()) {
            return true;
        }
        if (-1 == this.sbiSoketType) {
            this.getSbiSocketType();
        }
        if (null == (sbiCommStr = TEHandleSbiInfo.getSbiCommStr(neID, this.isFromJni, this.isFromFile, this.sbiSoketType))) {
            return false;
        }
        if (!this.decodeCommStr(sbiCommStr, this.isFromFile)) {
            return false;
        }
        return 0 == this.connectSbi(neID);
    }

    public synchronized int handleSBIConnect(int neID) {
        String sbiCommStr;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return -1;
        }
        if (1 == ne.getLogStatus() && 0 == ne.getIsTL1OrQX()) {
            return 0;
        }
        if (-1 == this.sbiSoketType) {
            this.getSbiSocketType();
        }
        if (null == (sbiCommStr = TEHandleSbiInfo.getSbiCommStr(neID, this.isFromJni, this.isFromFile, this.sbiSoketType))) {
            return 1090646019;
        }
        if (!this.decodeCommStr(sbiCommStr, this.isFromFile)) {
            return 1090646019;
        }
        return this.connectSbi(neID);
    }

    public synchronized int handleSBIConnectOnInter2(int neID) {
        String sbiCommStr;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        if (1 == ne.getLogStatus() && 0 == ne.getIsTL1OrQX()) {
            return 0;
        }
        if (-1 == this.sbiSoketType) {
            this.getSbiSocketType();
        }
        if (null == (sbiCommStr = TEHandleSbiInfo.getSbiCommStr(neID, this.isFromJni, this.isFromFile, this.sbiSoketType))) {
            return 1090609685;
        }
        if (!this.decodeCommStr(sbiCommStr, this.isFromFile)) {
            return 1090609685;
        }
        return this.connectSbi(neID);
    }

    private void getSbiSocketType() {
        this.sbiSoketType = 1;
        int serverSSLMode = TESysManagerBean.getInstance().getServerSSLMode();
        if (0 != serverSSLMode) {
            this.sbiSoketType = 4;
        }
        normalLogger.info("The sbiSoketType is " + this.sbiSoketType);
    }

    private boolean decodeCommStr(String sbiCommStr, boolean isFromFile) {
        boolean result = false;
        result = this.isFromJni ? this.decodeCommStrFromJNI(sbiCommStr) : (isFromFile ? this.decodeCommStrFromFile(sbiCommStr) : this.decodeCommStrFromServer(sbiCommStr));
        return result;
    }

    private boolean decodeCommStrFromJNI(String sbiCommStr) {
        if (null == sbiCommStr || sbiCommStr.isEmpty()) {
            normalLogger.error("The commStr is empty!");
            return false;
        }
        String[] commStrArr = sbiCommStr.split(":");
        this.sbiUserName = commStrArr[0];
        this.sbiPassword = EncryptUtils.encryptAESByte2Str(commStrArr[1].getBytes());
        this.sbiAddr = commStrArr[2];
        this.sbiPort = commStrArr[3];
        return true;
    }

    private boolean decodeCommStrFromFile(String sbiCommStr) {
        if (null == sbiCommStr || sbiCommStr.isEmpty()) {
            normalLogger.error("The commStr is empty!");
            return false;
        }
        String[] commStrArr = sbiCommStr.split(":");
        this.sbiUserName = commStrArr[0];
        this.sbiPassword = commStrArr[1];
        this.sbiAddr = commStrArr[2];
        this.sbiPort = commStrArr[3];
        normalLogger.debug("Decrypt commStr success!");
        normalLogger.debug("User Name :" + this.sbiUserName);
        normalLogger.debug("SBI Address :" + this.sbiAddr);
        normalLogger.debug("SBI PORT :" + this.sbiPort);
        return true;
    }

    private boolean decodeCommStrFromServer(String sbiCommStr) {
        if (null == sbiCommStr || sbiCommStr.isEmpty()) {
            normalLogger.error("The commStr is empty!");
            return false;
        }
        try {
            DeploymentMode sysStatus = TESysManagerBean.getInstance().getSysStauts();
            if (TESysManagerConstants.SYS_SINGLE_STATUS == sysStatus) {
                normalLogger.error("The system is not intergrated!");
                return false;
            }
            normalLogger.debug("The hex encrptStr is :" + sbiCommStr);
            String[] obc = sbiCommStr.split(":");
            byte[] user = TEHandleSbiInfo.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[0] + new String(ADD_ENCRPT_STR)));
            byte[] pwd = TEHandleSbiInfo.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[1] + new String(ADD_ENCRPT_STR)));
            byte[] sbiads = TEHandleSbiInfo.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[2] + new String(ADD_ENCRPT_STR)));
            byte[] sbiport = TEHandleSbiInfo.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[3] + new String(ADD_ENCRPT_STR)));
            this.sbiUserName = IOStreamConvertor.replaceSpecialStr(new String(user));
            byte[] newpwd = IOStreamConvertor.removeByteZero(pwd);
            this.sbiPassword = EncryptUtils.encryptAESByte2Str(newpwd);
            EncryptUtils.clearByte(pwd);
            EncryptUtils.clearByte(newpwd);
            this.sbiAddr = IOStreamConvertor.replaceSpecialStr(new String(sbiads));
            this.sbiPort = IOStreamConvertor.replaceSpecialStr(new String(sbiport));
            normalLogger.debug("Decrypt commSt success!");
            normalLogger.debug("User Name :" + this.sbiUserName);
            normalLogger.debug("SBI Address :" + this.sbiAddr);
            normalLogger.debug("SBI PORT :" + this.sbiPort);
            return true;
        }
        catch (Exception e) {
            normalLogger.error("Decrypt commStr is Fail!", (Throwable)e);
            return false;
        }
    }

    private int connectSbi(int neID) {
        try {
            boolean isQx;
            int result = 0;
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TIntArrayList nes = TENEListMgr.getInstance().getNEIDList();
                normalLogger.error("Can't find ne, neid->" + neID);
                normalLogger.error("Tenelistmgr neids -> " + nes);
                return 1090596385;
            }
            boolean bl = isQx = TEHandleSbiInfo.getTL1OrQx(ne.getRealNEID()) == 0;
            if (!isQx) {
                TETL1NECommMgr.getInstance().closeConnect((long)neID, Integer.parseInt(this.sbiPort), this.sbiAddr, this.sbiSoketType);
            }
            if (isQx) {
                QxNEConnectInfo neCon = new QxNEConnectInfo();
                neCon.setLogicNeID((long)neID);
                neCon.setPort(Integer.parseInt(this.sbiPort));
                neCon.setIpAddress(this.sbiAddr);
                neCon.setCommType(this.sbiSoketType);
                neCon.setNeVersion(ne.getNEVersion());
                result = TENECommMgr.getInstance().createConect(neCon);
            } else {
                result = TETL1NECommMgr.getInstance().createConect((long)neID, Integer.parseInt(this.sbiPort), this.sbiAddr, this.sbiSoketType);
            }
            if (0 != result && result != 1090781210) {
                normalLogger.debug("Connect to SBI Fail! result is: " + result);
                return result;
            }
            byte[] password = EncryptUtils.decryptAESStr2Byte(this.sbiPassword);
            byte[] curPassword = ne.getCurUserPassword();
            if (this.sbiUserName.equals(ne.getCurUser()) && Arrays.equals(password, curPassword) && ne.getLogStatus() == 1) {
                normalLogger.debug("The ne is already logined");
                return 0;
            }
            if (!isQx) {
                TETL1NELoginMgr.Fault fault = TETL1NELoginMgr.getInstance().sendLoginCmd(neID, this.sbiUserName, password);
                result = fault.getRetCode();
            } else {
                result = ne.login(this.sbiUserName, password, 1);
            }
            EncryptUtils.clearByte(password);
            EncryptUtils.clearByte(curPassword);
            if (0 == result) {
                ne.setLogStatus(1);
                ne.initInterNEDataAfterLogin();
                return result;
            }
            normalLogger.debug("Login ne Fail!");
            return result;
        }
        catch (Exception e) {
            normalLogger.error("Conect and login ne fail!", (Throwable)e);
            return 1090646019;
        }
    }

    private static int getNGLCTPara(int cmdCode, FStruct req, FStruct rsp) {
        TEProcID procID = new TEProcID();
        procID.setProcID('\u00b2');
        return TEASN1CommMgr.sendCommand(procID, req, rsp, cmdCode);
    }

    private static int getTL1OrQx(int phyNEID) {
        if (0 != (phyNEID & 0x4000000)) {
            return 1;
        }
        return 0;
    }

    private static byte[] decryptPwd(String key, byte[] encrptbyte) {
        String arithmetic = "DES";
        byte[] b_key = key.getBytes();
        SecretKeySpec deskey = new SecretKeySpec(b_key, arithmetic);
        try {
            Cipher c1 = Cipher.getInstance(arithmetic);
            c1.init(2, deskey);
            return c1.doFinal(encrptbyte);
        }
        catch (Exception e) {
            normalLogger.error("Decrypt fail!", (Throwable)e);
            return null;
        }
    }

    private static String getSbiCommStr(int neID, boolean isFromJni, boolean isFromFile, int sbiSoketType) {
        String commStr = null;
        if (isFromJni) {
            commStr = TEHandleSbiInfo.getSbiCommStrFromJni(neID);
        } else if (isFromFile) {
            commStr = TEHandleSbiInfo.getSbiCommStrFromFile(neID, sbiSoketType);
        } else {
            int userID = 386;
            commStr = TEHandleSbiInfo.getSbiCommStrFromServer(neID, 386);
        }
        return commStr;
    }

    private static String getSbiCommStrFromJni(int neID) {
        return TEJNIFacadeUtil.getSBICommStr(neID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSbiCommStrFromFile(int neID, int sbiSoketType) {
        String commStr = null;
        String instanceName = System.getProperty("instanceName");
        if (null == instanceName || instanceName.isEmpty()) {
            return commStr;
        }
        String[] nameArr = instanceName.split("_");
        String nemgrPath = nameArr[0] + "_" + nameArr[1];
        String imapRoot = System.getenv("IMAP_ROOT");
        String instanceCfgPath = new StringBuffer().append(imapRoot).append(File.separator).append("nemgr").append(File.separator).append(nemgrPath).append(File.separator).append("conf").append(File.separator).append(instanceName).append(".cfg").toString();
        Properties instancePro = new Properties();
        FileInputStream instanceFIS = null;
        try {
            boolean isQx;
            instanceFIS = new FileInputStream(instanceCfgPath);
            instancePro.load(instanceFIS);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            String userName = ne.getCurUser();
            byte[] password = ne.getCurUserPassword();
            String addr = instancePro.getProperty("SBIProxyServerName").trim();
            String port = null;
            boolean bl = isQx = TEHandleSbiInfo.getTL1OrQx(ne.getRealNEID()) == 0;
            port = isQx ? (1 == sbiSoketType ? instancePro.getProperty("SBIProxyPort").trim() : instancePro.getProperty("SBIProxySSLPort").trim()) : (1 == sbiSoketType ? instancePro.getProperty("SBIProxyTL1Port").trim() : instancePro.getProperty("SBIProxyTL1SSLPort").trim());
            commStr = new StringBuffer().append(addr).append(':').append(port).append(':').append(userName).append(':').append(EncryptUtils.encryptAESByte2Str(password)).toString();
            EncryptUtils.clearByte(password);
        }
        catch (Exception e) {
            normalLogger.error("Get sbi info from file error!", (Throwable)e);
            commStr = null;
        }
        finally {
            try {
                if (null != instanceFIS) {
                    instanceFIS.close();
                }
            }
            catch (Exception e) {
                normalLogger.error("Close instanceFIS fail!", (Throwable)e);
            }
        }
        return commStr;
    }

    protected static String getSbiCommStrFromServer(int neID, int userID) {
        String commStr = null;
        AsnGetNGLCTParaReq req = new AsnGetNGLCTParaReq();
        req.userID = userID;
        req.neID = neID;
        normalLogger.info(TEAsn1Util.getAsn1String(req));
        AsnGetNGLCTParaRsp rsp = new AsnGetNGLCTParaRsp();
        int cmdCode = 0x202211;
        int result = 0;
        if (-1 != neID) {
            result = TEHandleSbiInfo.getNGLCTPara(cmdCode, (FStruct)req, (FStruct)rsp);
        }
        if (result != 0) {
            normalLogger.error("Send cmdCode fail! errorCode:" + result);
            return commStr;
        }
        normalLogger.info(TEAsn1Util.getAsn1String(rsp));
        if (rsp.result.isSuccess) {
            commStr = new String(rsp.commStr);
        } else {
            if (null == rsp.result.retCode) {
                rsp.result.retCode = BigInteger.valueOf(1090646019L);
            }
            normalLogger.error("Get sbi commStr fail!");
        }
        return commStr;
    }
}

