/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.security.TECheckSessionTimeoutUtil;
import com.huawei.nglct.security.TESecurityLogMgr;
import com.huawei.nglct.security.TETokenCheckMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TSLoginFilter
implements Filter {
    TESysManagerBean teSysManagerBean;
    DeploymentMode istatus;

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TELogFactory.getNormalLogger().debug("#####doFilter(): start");
        Field methodField = null;
        try {
            methodField = request.getClass().getDeclaredField("_method");
            if (null != methodField) {
                if (!methodField.isAccessible()) {
                    methodField.setAccessible(true);
                }
                methodField.set(request, "GET");
            }
        }
        catch (SecurityException e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doFilter() SecurityException!", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doFilter() NoSuchFieldException!", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doFilter() IllegalArgumentException!", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doFilter() IllegalAccessException!", (Throwable)e);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doFilter() Exception!", (Throwable)e);
        }
        this.teSysManagerBean = TESysManagerBean.getInstance();
        this.istatus = this.teSysManagerBean.getSysStauts();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpresponse = (HttpServletResponse)response;
            httpresponse.setHeader("Cache-Control", "no-cache");
            httpresponse.setHeader("Pragma", "no-cache");
            httpresponse.setHeader("Expires", "0");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String currentURL = httpRequest.getRequestURL().toString();
        currentURL = currentURL.substring(currentURL.lastIndexOf(47) + 1);
        TELogFactory.getNormalLogger().debug("#####doFilter():" + httpRequest.getRequestURL());
        if (currentURL.indexOf(".html") < 0 && currentURL.indexOf(".jsp") < 0) {
            chain.doFilter(request, response);
            return;
        }
        if (TESysManagerConstants.SYS_SINGLE_STATUS != this.istatus) {
            this.doIntergrationFilter(request, response, chain);
        } else {
            this.doSingleFilter(request, response, chain);
        }
    }

    public void doSingleFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String currentURL = httpRequest.getRequestURL().toString();
        currentURL = currentURL.substring(currentURL.lastIndexOf(47) + 1);
        String contextPath = httpRequest.getContextPath();
        if (currentURL.equals("login.html") && !request.isSecure() && TESystemUtil.isHTTPS()) {
            httpRequest.getSession().setAttribute("visit", (Object)"normal");
            httpResponse.sendRedirect(TESystemUtil.getHTTPSURL(httpRequest.getServerName()) + "/weblct" + "/page/login.html");
            return;
        }
        if ("login.html".equals(currentURL) || currentURL.indexOf("indexbanner.html") != -1 || currentURL.indexOf("help.html") != -1 || currentURL.indexOf("helpbanner.html") != -1 || currentURL.indexOf("loginmain.html") != -1 || currentURL.indexOf("bottom.html") != -1 || currentURL.indexOf("tohomepage.html") != -1 || currentURL.indexOf("accesserror.html") != -1 || (currentURL.indexOf("pswinner.html") != -1 || currentURL.indexOf("password.html") != -1) && (TESystemUtil.isPassNeedChange(httpRequest) || httpRequest.getParameter("fromLoginPage") != null && httpRequest.getParameter("fromLoginPage").equals("true"))) {
            chain.doFilter(request, response);
            return;
        }
        try {
            HttpSession session = httpRequest.getSession(false);
            if (session != null) {
                if (!(!TESystemUtil.isLoginSuccess(httpRequest) || TECheckSessionTimeoutUtil.getInstance().isTimeout(httpRequest) && this.isNeedCheckTimeout(httpRequest))) {
                    TECheckSessionTimeoutUtil.getInstance().setOperTime(httpRequest);
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                TESystemUtil.removeLoginFlag(httpRequest);
            }
            StringBuffer requestURL = httpRequest.getRequestURL();
            String query = httpRequest.getQueryString();
            if (query != null) {
                requestURL.append(query);
            }
            this.writeLogForUnauthorizedSession(httpRequest);
            httpResponse.sendRedirect(contextPath + "/weblct" + "/page/tohomepage.html");
            return;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TSLoginFilter.doSingleFilter() fail!", (Throwable)e);
            return;
        }
    }

    private void writeLogForUnauthorizedSession(HttpServletRequest httpRequest) {
        String requestURI = httpRequest.getRequestURI().toString();
        String remoteHost = httpRequest.getRemoteHost();
        if (TESysManagerConstants.SYS_SINGLE_STATUS != this.istatus) {
            remoteHost = TESystemUtil.getTerminalIP(httpRequest);
        }
        String LINE_SEPARATOR = System.getProperty("line.separator");
        String sessionTime = TESecurityLogMgr.getInstance().getLogRes("unauthorizedSessionTime") + new Date() + LINE_SEPARATOR;
        String sessionURL = TESecurityLogMgr.getInstance().getLogRes("unauthorizedSessionURI") + requestURI + LINE_SEPARATOR;
        String sessionSource = TESecurityLogMgr.getInstance().getLogRes("unauthorizedSessionSource") + remoteHost;
        String operDesc = sessionTime + sessionURL + sessionSource;
        String operName = TESecurityLogMgr.getInstance().getLogRes("loginweblct");
        int cmdCode = 2180459;
        TESecurityLogMgr.getInstance().writeLog(remoteHost, cmdCode, operName, operDesc, 2, 67);
    }

    private boolean isNeedCheckTimeout(HttpServletRequest httpRequest) {
        boolean result = true;
        String currentURL = httpRequest.getRequestURL().toString();
        if (currentURL.indexOf("help/" + TESysManagerBean.getInstance().getlanguage()) != -1 && currentURL.indexOf("nemgr") != -1) {
            result = false;
        }
        return result;
    }

    public void doIntergrationFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TELogFactory.getNormalLogger().info("#####doIntergrationFilter(): start");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        String currentURL = httpRequest.getRequestURL().toString();
        currentURL = currentURL.substring(currentURL.lastIndexOf(47) + 1);
        String contextPath = httpRequest.getContextPath();
        TELogFactory.getNormalLogger().debug("#####doIntergrationFilter(): A " + currentURL);
        if (currentURL.equals("login.html")) {
            TELogFactory.getNormalLogger().info("recevied the url from dispatcher,url is :" + httpRequest.getRequestURI());
        }
        TELogFactory.getNormalLogger().debug("#####doIntergrationFilter(): B " + currentURL);
        if (currentURL.equals("tohomepage.html") || currentURL.equals("errorinfo.html") || currentURL.equals("printpage.html") || currentURL.equals("printspetable.html") || currentURL.equals("printstatistics.html") || currentURL.equals("savestatistics.html") || currentURL.equals("printXc.html") || currentURL.equals("boundpathconfig.html") || currentURL.equals("accesserror.html") || currentURL.equals("blank.html")) {
            TELogFactory.getNormalLogger().debug("#####doIntergrationFilter(): C " + currentURL);
            chain.doFilter(request, response);
            return;
        }
        TELogFactory.getNormalLogger().debug("#####doIntergrationFilter(): D " + currentURL);
        String terminalIP = TESystemUtil.getTerminalIP(httpRequest);
        String token = TETokenCheckMgr.getTokenFromHeadOrURL(httpRequest);
        Cookie tokenCookie = TETokenCheckMgr.getTokenCookie(httpRequest);
        if (token == null) {
            if (tokenCookie != null) {
                token = TETokenCheckMgr.decodeToken(tokenCookie.getValue());
            }
        } else {
            Cookie cookietemp = new Cookie("token", TETokenCheckMgr.encodeToken(token));
            cookietemp.setPath("/");
            if (TESysManagerBean.getInstance().getServerSSLMode() == 2) {
                cookietemp.setSecure(true);
            }
            if (tokenCookie != null) {
                if (!token.equals(TETokenCheckMgr.decodeToken(tokenCookie.getValue()))) {
                    httpresponse.addCookie(cookietemp);
                }
            } else {
                httpresponse.addCookie(cookietemp);
            }
        }
        TELogFactory.getNormalLogger().debug("#####doIntergrationFilter(): E " + currentURL);
        if (token == null || !TETokenCheckMgr.getInstance().checkToken(token, terminalIP)) {
            if (null == token) {
                TELogFactory.getNormalLogger().info("token is null!");
            }
            TELogFactory.getNormalLogger().info("#####doIntergrationFilter(): F " + currentURL);
            TELogFactory.getNormalLogger().info("The URL is :" + httpRequest.getRequestURI() + "has been refuse!Remoteaddress=" + httpRequest.getRemoteAddr());
            this.writeLogForUnauthorizedSession(httpRequest);
            TESystemUtil.sendRedirect(contextPath + "/weblct" + "/page/accesserror.html", httpRequest, httpresponse);
            return;
        }
        TELogFactory.getNormalLogger().info("#####doIntergrationFilter():  " + currentURL + " finished.");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

