/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TECheckSessionTimeoutUtil;
import com.huawei.nglct.security.TESecurityLogMgr;
import com.huawei.nglct.security.TESecurityPolicyBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TSLoginCheck
extends HttpServlet {
    private static final long serialVersionUID = 7169106511218784336L;
    private static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final int iparam = 0;
    private static final int iparam1 = 0;
    TESysManagerBean teSysManagerBean;
    String language;
    String isLocal;
    DeploymentMode isStatus;
    private static final int PWD_WILL_INVALID = 1001;
    private static final int PWD_INVALID = 1002;
    private static final int PWD_NORMAL = 1000;
    private static final int LOGIN_FIRST_ERRORCODE = 1005;

    public void init(ServletConfig config) throws ServletException {
    }

    protected void doGet(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) throws IOException, ServletException {
        this.doPost(httpReqeust, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) throws IOException, ServletException {
        String operName;
        this.teSysManagerBean = TESysManagerBean.getInstance();
        this.language = this.teSysManagerBean.getlanguage();
        this.isStatus = this.teSysManagerBean.getSysStauts();
        this.isLocal = this.teSysManagerBean.getIslocal();
        String operDesc = operName = TESecurityLogMgr.getInstance().getLogRes("loginweblct");
        httpResponse.setContentType(CONTENT_TYPE);
        String compareLocal = BigInteger.valueOf(0L).toString();
        TELogFactory.getNormalLogger().info("0: not local user may not access,1:may access. isLocal = " + this.isLocal);
        String requestURL = httpReqeust.getRemoteAddr();
        TELogFactory.getNormalLogger().info("request address = " + requestURL);
        if (requestURL.equals("0:0:0:0:0:0:0:1")) {
            requestURL = "127.0.0.1";
        }
        String localURL = null;
        try {
            try {
                localURL = httpReqeust.getLocalAddr();
                localURL = "127.0.0.1";
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("TSLoginCheck.doPost() fail!", (Throwable)ex);
                localURL = "127.0.0.1";
            }
        }
        catch (Throwable throwable) {
            localURL = "127.0.0.1";
            throw throwable;
        }
        TELogFactory.getNormalLogger().info("my local address = " + localURL);
        String userName = httpReqeust.getParameter("txtname");
        String password = httpReqeust.getParameter("txtpassword");
        userName = EncryptUtils.convertByte2Str(EncryptUtils.decrypt(userName));
        byte[] bPassword = EncryptUtils.decrypt(password);
        String verifycode = httpReqeust.getParameter("txtverifycode");
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            EncryptUtils.clearByte(bPassword);
            String info1 = TEErrorResourceUtil.getErrCodeResWithDot(0x41040014);
            TELogFactory.getNormalLogger().info(info1 + "current:" + 0);
            this.redirectErrorPage(httpReqeust, httpResponse, info1);
            return;
        }
        HttpSession session = httpReqeust.getSession(true);
        if (!TSLoginCheck.checkVerifyCode(verifycode, session)) {
            EncryptUtils.clearByte(bPassword);
            this.redirectErrorPage(httpReqeust, httpResponse, TENEListUtils.getString("verifycodeerror"));
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1092091910);
            return;
        }
        String remoteAddr = this.getRemoteAddr(httpReqeust);
        int locktime = TESecurityPolicyBean.getInstance().checkUserLock(userName, remoteAddr);
        if (locktime > 0) {
            EncryptUtils.clearByte(bPassword);
            this.redirectErrorPage(httpReqeust, httpResponse, TENEListUtils.getString("userlockinfo").replaceAll("%s", String.valueOf(locktime)));
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1132);
            return;
        }
        if (this.isLocal.equals(compareLocal)) {
            TELogFactory.getStartupLogger().info("not long_distance visit:");
            if (!requestURL.equals(localURL)) {
                EncryptUtils.clearByte(bPassword);
                String info1 = TEErrorResourceUtil.getErrCodeResWithDot(1090781203);
                TELogFactory.getNormalLogger().info(info1 + "your IPAddress:" + requestURL);
                this.redirectErrorPage(httpReqeust, httpResponse, TEErrorResourceUtil.getErrCodeResWithDot(1090781203));
                TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1090781203);
                return;
            }
            TELogFactory.getNormalLogger().info("my IpAddress is:" + localURL);
            if (!TESysManagerBean.getInstance().verifyPassword(userName, bPassword)) {
                String errorCode = this.setLoginFail(session, userName, remoteAddr);
                EncryptUtils.clearByte(bPassword);
                this.redirectErrorPage(httpReqeust, httpResponse, errorCode);
                TELogFactory.getStartupLogger().info("validate password error.");
                TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1030);
                return;
            }
            TELogFactory.getStartupLogger().info("validate password success.");
            session.invalidate();
            int pwdStatus = this.checkPwdStatus(httpReqeust, httpResponse, session, userName, bPassword, remoteAddr, localURL);
            EncryptUtils.clearByte(bPassword);
            if (pwdStatus != 1000) {
                return;
            }
            TENEListMgr.getInstance().clearAllNePassWord();
            this.dealLoginSuccess(httpReqeust, httpResponse, userName, remoteAddr);
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 0, 0);
            return;
        }
        TELogFactory.getStartupLogger().info("you may visit my machine by long_distance!" + requestURL);
        if (!TESysManagerBean.getInstance().verifyPassword(userName, bPassword)) {
            TELogFactory.getNormalLogger().info("your password is not right!");
            EncryptUtils.clearByte(bPassword);
            String errorCode = this.setLoginFail(session, userName, remoteAddr);
            this.redirectErrorPage(httpReqeust, httpResponse, errorCode);
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1030);
            return;
        }
        session.invalidate();
        int pwdStatus = this.checkPwdStatus(httpReqeust, httpResponse, session, userName, bPassword, remoteAddr, localURL);
        EncryptUtils.clearByte(bPassword);
        if (pwdStatus != 1000) {
            return;
        }
        TENEListMgr.getInstance().clearAllNePassWord();
        this.dealLoginSuccess(httpReqeust, httpResponse, userName, remoteAddr);
        TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 0, 0);
    }

    private static boolean checkVerifyCode(String uVerifyCode, HttpSession oSession) {
        String sVerifyCode = (String)oSession.getAttribute("validateCode");
        oSession.setAttribute("validateCode", (Object)"");
        if (uVerifyCode == null || uVerifyCode.equals("")) {
            return false;
        }
        return uVerifyCode.equalsIgnoreCase(sVerifyCode);
    }

    public static void redirectNeListMain(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) throws IOException {
        TESystemUtil.setLoginSuccess(httpReqeust);
        String redirectURL = TESystemUtil.getNeListURL(httpReqeust, httpResponse);
        TESystemUtil.sendRedirect(redirectURL, httpReqeust, httpResponse);
    }

    private String setLoginFail(HttpSession session, String username, String remoteAddr) {
        String info = TEErrorResourceUtil.getErrCodeResWithDot(1090744429);
        if (TESecurityPolicyBean.getInstance().getLoginFail() > 0) {
            int loginfail = TESecurityPolicyBean.getInstance().getUserLoginFail(username, remoteAddr);
            int fail = TESecurityPolicyBean.getInstance().getLoginFail() - ++loginfail;
            if (fail <= 0) {
                loginfail = 0;
                TESecurityPolicyBean.getInstance().setUserLock(username, remoteAddr);
                int locktime = TESecurityPolicyBean.getInstance().getLockTime();
                info = locktime > 1 ? TENEListUtils.getString("userlockinfos").replaceAll("%s", String.valueOf(locktime)) : TENEListUtils.getString("userlockinfo").replaceAll("%s", String.valueOf(locktime));
            } else if (fail == 1) {
                int locktime = TESecurityPolicyBean.getInstance().getLockTime();
                info = locktime > 1 ? TENEListUtils.getString("loginfailinfos").replaceAll("%s", String.valueOf(locktime)) : TENEListUtils.getString("loginfailinfo").replaceAll("%s", String.valueOf(locktime));
            }
            TESecurityPolicyBean.getInstance().setUserLoginFail(username, remoteAddr, loginfail);
        }
        return info;
    }

    private void dealLoginSuccess(HttpServletRequest httpReqeust, HttpServletResponse httpResponse, String username, String remoteAddr) throws IOException {
        TECheckSessionTimeoutUtil.getInstance().setOperTime(httpReqeust);
        TESecurityPolicyBean.getInstance().removeUserLoginFail(username, remoteAddr);
        if (TESysManagerBean.getInstance().isForceChangePwd()) {
            TESystemUtil.setPassNeedChange(httpReqeust);
            this.redirectErrorPage(httpReqeust, httpResponse, TENEListUtils.getString("LoginForFirstTimeHint"), 1005);
        } else {
            TSLoginCheck.redirectNeListMain(httpReqeust, httpResponse);
        }
    }

    public String encodeMsg(String msg) {
        String str = null;
        try {
            str = TESysManagerBean.getInstance().getlanguage().equalsIgnoreCase("zh") ? URLEncoder.encode(msg, "UTF-8") : msg;
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TSLoginCheck.encodeMsg() fail!", (Throwable)e);
        }
        return str;
    }

    private void redirectErrorPage(HttpServletRequest httpReqeust, HttpServletResponse httpResponse, String errorInfo) throws IOException {
        String contextPath = httpReqeust.getContextPath();
        httpResponse.sendRedirect(contextPath + "/weblct" + "/page/login.html" + "?msg=" + this.encodeMsg(errorInfo));
        TELogFactory.getNormalLogger().info("sendRedirect =" + contextPath + "/weblct" + "/page/login.html" + "?msg=" + errorInfo);
    }

    private void redirectErrorPage(HttpServletRequest httpReqeust, HttpServletResponse httpResponse, String errorInfo, int errorCode) throws IOException {
        String contextPath = httpReqeust.getContextPath();
        httpResponse.sendRedirect(contextPath + "/weblct" + "/page/login.html" + "?msg=" + this.encodeMsg(errorInfo) + "&errCode=" + errorCode);
        TELogFactory.getNormalLogger().info("sendRedirect =" + contextPath + "/weblct" + "/page/login.html" + "?msg=" + errorInfo + "&errCode=" + errorCode);
    }

    private String getRemoteAddr(HttpServletRequest request) {
        String localURL = null;
        try {
            localURL = request.getRemoteAddr();
        }
        catch (Exception ex) {
            localURL = "127.0.0.1";
        }
        return localURL;
    }

    private int checkPwdStatus(HttpServletRequest httpReqeust, HttpServletResponse httpResponse, HttpSession session, String userName, byte[] password, String remoteAddr, String localURL) throws IOException {
        int result = 1000;
        if (TESecurityPolicyBean.getInstance().getPwvalidate() <= 0) {
            return result;
        }
        String errorInfo = null;
        int days = TESecurityPolicyBean.getInstance().getInvalidDays(userName, password);
        if (days <= 0) {
            result = 1002;
            TESystemUtil.setPassNeedChange(httpReqeust);
            errorInfo = TENEListUtils.getString("pwdinvalidinfo");
        } else if (days <= TESecurityPolicyBean.getInstance().getConfirmdays() && days > 0) {
            result = 1001;
            errorInfo = TENEListUtils.getString("pwdwillinvalidinfo").replaceAll("%s", String.valueOf(days));
        }
        if (result != 1002) {
            TESystemUtil.setLoginSuccess(httpReqeust);
            TECheckSessionTimeoutUtil.getInstance().setOperTime(httpReqeust);
            TESecurityPolicyBean.getInstance().removeUserLoginFail(userName, remoteAddr);
            if (TESysManagerBean.getInstance().isForceChangePwd()) {
                TESystemUtil.setPassNeedChange(httpReqeust);
                this.redirectErrorPage(httpReqeust, httpResponse, TENEListUtils.getString("LoginForFirstTimeHint"), 1005);
            }
        }
        if (result != 1000) {
            String operName;
            String operDesc = operName = TESecurityLogMgr.getInstance().getLogRes("loginweblct");
            try {
                this.redirectErrorPage(httpReqeust, httpResponse, errorInfo, result);
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().info("redirect fail!", (Throwable)e);
            }
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1132);
        }
        return result;
    }
}

