/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.token.TECheckTokenService;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEUserCredential;
import com.huawei.nglct.util.string.EscapeUnescape;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class TETokenCheckMgr {
    public static final String TOKEN = "token";
    private static final int TOKEN_ITEM_COUNT = 7;
    private Set<TEUserCredential> validTokens = new HashSet<TEUserCredential>();
    private static TETokenCheckMgr instance = null;
    private Timer timer = new Timer();
    private CheckTokenTask checkTokenTask = new CheckTokenTask();
    private static final long CHECK_INTERVAL = 1200000L;
    private static final int VALID_ERROR_CODE = 0;

    private TETokenCheckMgr() {
        this.timer.scheduleAtFixedRate((TimerTask)this.checkTokenTask, 1200000L, 1200000L);
    }

    public static synchronized TETokenCheckMgr getInstance() {
        if (instance == null) {
            instance = new TETokenCheckMgr();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkToken(String rsatoken, String terminalIP) {
        boolean bValid = false;
        Set<TEUserCredential> set = this.validTokens;
        synchronized (set) {
            if (this.validTokens.contains(new TEUserCredential(rsatoken, terminalIP))) {
                bValid = true;
            } else {
                int result;
                String token = EncryptUtils.convertByte2Str(EncryptUtils.decrypt(rsatoken));
                if (!TETokenCheckMgr.verifyTokenACL(token, terminalIP)) {
                    TELogFactory.getNormalLogger().info("verifyTokenACL token is invalid! terminalIP:" + terminalIP + " ," + EscapeUnescape.escapeToken(token));
                    bValid = false;
                }
                if ((result = TECheckTokenService.isValidToken(token)) == 0) {
                    this.validTokens.add(new TEUserCredential(EncryptUtils.convertStr2Byte(token), rsatoken, terminalIP));
                    bValid = true;
                } else {
                    TELogFactory.getNormalLogger().info("checkToken token is invalid!" + EscapeUnescape.escapeToken(token));
                }
            }
        }
        return bValid;
    }

    public static String getTokenFromHeadOrURL(HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader(TOKEN);
        if (null == token) {
            token = httpRequest.getParameter(TOKEN);
        }
        return token;
    }

    public static Cookie getTokenCookie(HttpServletRequest httpRequest) {
        Cookie result = null;
        Cookie[] cookie = httpRequest.getCookies();
        if (cookie != null) {
            int len = cookie.length;
            for (int i = 0; i < len; ++i) {
                if (!cookie[i].getName().equals(TOKEN)) continue;
                result = cookie[i];
                break;
            }
        }
        return result;
    }

    public static String encodeToken(String token) throws UnsupportedEncodingException {
        return URLEncoder.encode(token, "UTF-8");
    }

    public static String decodeToken(String token) throws UnsupportedEncodingException {
        return URLDecoder.decode(token, "UTF-8");
    }

    public static boolean verifyTokenACL(String token, String terminalIP) {
        if (terminalIP == null) {
            return false;
        }
        String split = ";";
        String globalStr = Normalizer.normalize(token, Normalizer.Form.NFC);
        String[] items = globalStr.split(split = Normalizer.normalize(split, Normalizer.Form.NFC));
        if (items == null || items.length != 7) {
            return false;
        }
        return terminalIP.equals(items[2]);
    }

    class CheckTokenTask
    extends TimerTask {
        CheckTokenTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = TETokenCheckMgr.this.validTokens;
            synchronized (set) {
                if (!TETokenCheckMgr.this.validTokens.isEmpty()) {
                    ArrayList tokens = new ArrayList(TETokenCheckMgr.this.validTokens);
                    ArrayList<String> checkTokens = new ArrayList<String>();
                    int len = tokens.size();
                    for (int i = 0; i < len; ++i) {
                        checkTokens.add(EncryptUtils.convertByte2Str(((TEUserCredential)tokens.get(i)).getToken()));
                    }
                    List<Integer> result = TECheckTokenService.isValidToken(checkTokens);
                    if (result != null && !result.isEmpty()) {
                        for (int i = result.size() - 1; i >= 0; --i) {
                            if (result.get(i) == 0) continue;
                            TELogFactory.getNormalLogger().info("CheckTokenTask token is invalid!" + EscapeUnescape.escapeToken(EncryptUtils.convertByte2Str(((TEUserCredential)tokens.get(i)).getToken())));
                            TETokenCheckMgr.this.validTokens.remove(tokens.get(i));
                        }
                    }
                }
            }
        }
    }
}

