/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEOperCmdType;
import com.huawei.nglct.cbb.log.t2kinterface.TEInterfaceProcess;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.jni.checkright.TEJNICheckRightService;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.util.HashSet;
import java.util.Set;

public class TESecurityVerify {
    private static final int RIGHT_YES = 1;
    private static final int RIGHT_NO = 0;
    private static Set<Integer> SFID_NEED_SERVER_CHECK = new HashSet<Integer>();

    public static void initSuperUserID() {
    }

    public static void setSuperUserID(int userid) {
    }

    public static int getSuperUserID() {
        return 0;
    }

    public Datainterface checkRight(int neID, int nmUserID, Datainterface sfidData) {
        TESysManagerBean sysManager = TESysManagerBean.getInstance();
        DeploymentMode runningStatus = sysManager.getSysStauts();
        TELogFactory.getNormalLogger().info(" NG LCT running Status is " + runningStatus);
        if (!TESysManagerBean.getInstance().isIntegratedStatus() || sysManager.getM2000() != 0) {
            return this.checkRightOfSingle(neID, sfidData);
        }
        return this.checkRightOfIntegration(neID, nmUserID, sfidData);
    }

    public Datainterface checkRightOfSingle(int neID, Datainterface sfidData) {
        TELogFactory.getNormalLogger().info("The NE ID is " + neID);
        BussinessParams inputBussParams = sfidData.getBussinessParams();
        int rowCount = inputBussParams.getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            RowParams inputRowParams = inputBussParams.getRowParams(i);
            int paramCount = inputRowParams.getParamCount();
            for (int j = 0; j < paramCount; ++j) {
                Param param = inputRowParams.getParam(j);
                if (!"sfid".equals(param.getName())) continue;
                Param rightParam = new Param();
                TELogFactory.getNormalLogger().info("subfunction id is " + param.getValue());
                rightParam.setName("right");
                rightParam.setValue(String.valueOf(1));
                inputRowParams.addParam(rightParam);
            }
        }
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage(0);
        sfidData.setErrorMessage(errorMsg);
        return sfidData;
    }

    public Datainterface checkRightOfIntegration(int neID, int nmUserID, Datainterface sfidData) {
        TELogFactory.getNormalLogger().info("The NE ID is " + neID);
        TELogFactory.getNormalLogger().info("T2000 userid is " + nmUserID);
        BussinessParams inputBussParams = sfidData.getBussinessParams();
        int rowCount = inputBussParams.getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            RowParams inputRowParams = inputBussParams.getRowParams(i);
            int paramCount = inputRowParams.getParamCount();
            for (int j = 0; j < paramCount; ++j) {
                Param param = inputRowParams.getParam(j);
                if (!"sfid".equals(param.getName())) continue;
                Param rightParam = new Param();
                String rightValue = String.valueOf(1);
                TELogFactory.getNormalLogger().info("subfunction id is " + param.getValue());
                try {
                    int cmdID = Integer.parseInt(param.getValue());
                    TEOperCmdType cmdtype = TEInterfaceProcess.getCmdSIDFromCmdID(param.getValue());
                    boolean hashRight = true;
                    if (cmdtype != null) {
                        TELogFactory.getNormalLogger().debug("get cmdid=" + cmdID + " cmdSid=" + cmdtype.cmdSID);
                        hashRight = TEJNICheckRightService.getInstance().jniRightCheck(nmUserID, Integer.parseInt(cmdtype.cmdSID), cmdtype.objectTID, cmdtype.objectSubTID, neID);
                    } else {
                        TELogFactory.getNormalLogger().debug("get cmdid=" + cmdID + " getCmdSIDFromCmdID is null");
                        hashRight = TEJNICheckRightService.getInstance().jniRightCheck(nmUserID, cmdID, neID);
                    }
                    rightValue = hashRight ? String.valueOf(1) : String.valueOf(0);
                }
                catch (NumberFormatException ex) {
                    TELogFactory.getNormalLogger().error("parse cmdid failed!", (Throwable)ex);
                    rightValue = String.valueOf(1);
                }
                rightParam.setName("right");
                rightParam.setValue(rightValue);
                inputRowParams.addParam(rightParam);
            }
        }
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage(0);
        sfidData.setErrorMessage(errorMsg);
        return sfidData;
    }

    public static boolean checkUserRight(int neid, int nmUserID, int cmdID) {
        boolean isRight = true;
        TEOperCmdType cmdtype = TEInterfaceProcess.getCmdSIDFromCmdID(String.valueOf(cmdID));
        if (cmdtype != null) {
            TELogFactory.getNormalLogger().debug("server check:get cmdid=" + cmdID + " cmdSid=" + cmdtype.cmdSID);
            isRight = TEJNICheckRightService.getInstance().jniRightCheck(nmUserID, Integer.parseInt(cmdtype.cmdSID), cmdtype.objectTID, cmdtype.objectSubTID, neid);
        } else {
            TELogFactory.getNormalLogger().debug("server check:get cmdid=" + cmdID + " getCmdSIDFromCmdID is null");
            isRight = TEJNICheckRightService.getInstance().jniRightCheck(nmUserID, cmdID, neid);
        }
        return isRight;
    }

    public static boolean isNeedServerCheckRight(int sfid) {
        return SFID_NEED_SERVER_CHECK.contains(sfid);
    }

    static {
        SFID_NEED_SERVER_CHECK.add(2105971);
        SFID_NEED_SERVER_CHECK.add(2172648);
        SFID_NEED_SERVER_CHECK.add(2172649);
        SFID_NEED_SERVER_CHECK.add(2180300);
        SFID_NEED_SERVER_CHECK.add(2180299);
        SFID_NEED_SERVER_CHECK.add(2105974);
        SFID_NEED_SERVER_CHECK.add(0x202272);
        SFID_NEED_SERVER_CHECK.add(2179571);
        SFID_NEED_SERVER_CHECK.add(2179572);
        SFID_NEED_SERVER_CHECK.add(2106532);
        SFID_NEED_SERVER_CHECK.add(2106533);
        SFID_NEED_SERVER_CHECK.add(2107410);
        SFID_NEED_SERVER_CHECK.add(2107411);
        SFID_NEED_SERVER_CHECK.add(0x206020);
        SFID_NEED_SERVER_CHECK.add(2121761);
        SFID_NEED_SERVER_CHECK.add(2121765);
        SFID_NEED_SERVER_CHECK.add(2121767);
        SFID_NEED_SERVER_CHECK.add(0x206026);
        SFID_NEED_SERVER_CHECK.add(2106169);
        SFID_NEED_SERVER_CHECK.add(2106170);
        SFID_NEED_SERVER_CHECK.add(2179532);
        SFID_NEED_SERVER_CHECK.add(2179529);
        SFID_NEED_SERVER_CHECK.add(2179530);
        SFID_NEED_SERVER_CHECK.add(2179531);
        SFID_NEED_SERVER_CHECK.add(2121848);
        SFID_NEED_SERVER_CHECK.add(2121849);
        SFID_NEED_SERVER_CHECK.add(2121862);
        SFID_NEED_SERVER_CHECK.add(2121863);
        SFID_NEED_SERVER_CHECK.add(2106003);
        SFID_NEED_SERVER_CHECK.add(2106004);
        SFID_NEED_SERVER_CHECK.add(2105516);
        SFID_NEED_SERVER_CHECK.add(2105517);
    }
}

