/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class TESecurityServlet
extends HttpServlet {
    public static boolean isSuperUserIDInited = false;

    public void init() throws ServletException {
        super.init();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!isSuperUserIDInited) {
            TESecurityVerify.initSuperUserID();
            isSuperUserIDInited = true;
        }
        TESecurityVerify securityVerify = new TESecurityVerify();
        int neID = Integer.parseInt(request.getParameter("neID"));
        int nmUserID = 0;
        if (null != request.getParameter("nmUser")) {
            try {
                nmUserID = Integer.parseInt(request.getParameter("nmUser"));
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("The nmUserID is error: " + request.getParameter("nmUser"));
                nmUserID = TESecurityVerify.getSuperUserID();
            }
        }
        TELogFactory.getNormalLogger().info("The neid of Security verify is " + neID);
        String inputDataStr = request.getParameter("inputdata");
        TELogFactory.getInterfaceLogger().info("begin to checkRight: neid->" + neID + ", nmUserID->" + nmUserID + ", inputDataStr = " + inputDataStr);
        Datainterface inputData = null;
        Datainterface outputData = null;
        try {
            StringReader r = new StringReader(inputDataStr);
            inputData = Datainterface.unmarshal(r);
            outputData = securityVerify.checkRight(neID, nmUserID, inputData);
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            StringWriter out = new StringWriter();
            outputData.marshal(out);
            response.getWriter().println(((Object)out).toString());
            TELogFactory.getInterfaceLogger().info("end to checkRight: neid->" + neID + ", nmUserID->" + nmUserID + ", outputDataStr =" + ((Object)out).toString());
            ((Writer)out).close();
            response.getWriter().close();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("program inner error", (Throwable)ex);
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            try {
                StringWriter out = new StringWriter();
                outputData.marshal(out);
                TELogFactory.getInterfaceLogger().info("Return to page's XML data is \u00a3\u00ba" + ((Object)out).toString());
                response.getWriter().println(((Object)out).toString());
                response.getWriter().close();
            }
            catch (MarshalException e) {
                TELogFactory.getNormalLogger().error("failed", (Throwable)e);
            }
            catch (ValidationException e) {
                TELogFactory.getNormalLogger().error("failed", (Throwable)e);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }
}

