/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TEDaoHolder;
import com.huawei.nglct.po.security.TELctUser;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.hibernate.Dao;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TESecurityPolicyBean {
    private static final String FILE_NAME = "securitypolicy.xml";
    private static TESecurityPolicyBean instance = null;
    private static final String PWD_MIN_LENGTH = "pwdminlength";
    private static final String PWD_MAX_LENGTH = "pwdmaxlength";
    private static final String LOGIN_FAIL = "loginfail";
    private static final String LOCK_TIME = "locktime";
    private static final String PWD_VALIDATE = "pwvalidate";
    private static final String CONFRIM_DAYS = "confirmdays";
    private int pwdminlength = 8;
    private int pwdmaxlength = 24;
    private int loginfail = 3;
    private int locktime = 5;
    private static final long LOCK_TIME_UNIT = 60000L;
    public static final int MAX_LOCK_TIME = 999999;
    private Map<String, Long> lockinfo = null;
    private Map<String, Integer> loginfailinfo = null;
    private int pwvalidate = 180;
    private int confirmdays = 10;
    private static final long TIME_PER_DAY = 86400000L;

    private TESecurityPolicyBean() {
        this.loadFile();
        this.lockinfo = new HashMap<String, Long>();
        this.loginfailinfo = new HashMap<String, Integer>();
    }

    public static synchronized TESecurityPolicyBean getInstance() {
        if (null == instance) {
            instance = new TESecurityPolicyBean();
        }
        return instance;
    }

    public boolean checkPassword(byte[] pwd) {
        boolean bResult = false;
        if (pwd.length >= this.pwdminlength && pwd.length <= this.pwdmaxlength) {
            bResult = true;
        }
        return bResult;
    }

    public int getPwdMinLength() {
        return this.pwdminlength;
    }

    public void setPwdMinLength(int pwdminlength) {
        this.pwdminlength = pwdminlength;
    }

    public int getPwdMaxLength() {
        return this.pwdmaxlength;
    }

    public void setPwdMaxLength(int pwdmaxlength) {
        this.pwdmaxlength = pwdmaxlength;
    }

    public int getLoginFail() {
        return this.loginfail;
    }

    public void setLoginFail(int loginfail) {
        this.loginfail = loginfail;
    }

    public int getLockTime() {
        return this.locktime;
    }

    public void setLockTime(int locktime) {
        this.locktime = locktime;
    }

    public int getPwvalidate() {
        return this.pwvalidate;
    }

    public void setPwvalidate(int pwvalidate) {
        this.pwvalidate = pwvalidate;
    }

    public int getConfirmdays() {
        return this.confirmdays;
    }

    private Document getFileXMLDoc() {
        DocumentBuilderFactory builderFactory = null;
        DocumentBuilder builder = null;
        StringBuffer filePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(FILE_NAME);
        TELogFactory.getStartupLogger().info("start to load securitypolicy file:" + filePath);
        Document doc = null;
        try {
            File SysCfgFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
            URI uri = SysCfgFile.toURI();
            InputStream in = uri.toURL().openStream();
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
            builderFactory.setCoalescing(true);
            builder = builderFactory.newDocumentBuilder();
            doc = builder.parse(in);
            in.close();
        }
        catch (Exception e) {
            TELogFactory.getStartupLogger().error("Parse Securitypolicy Config File Fail\u00a3\u00a1", (Throwable)e);
        }
        return doc;
    }

    public void loadFile() {
        Document doc = this.getFileXMLDoc();
        if (doc == null) {
            return;
        }
        NodeList childNodeList = doc.getFirstChild().getChildNodes();
        if (null != childNodeList && childNodeList.getLength() > 0) {
            for (int i = childNodeList.getLength() - 1; i >= 0; --i) {
                Node childNode = childNodeList.item(i);
                if (childNode.getNodeType() != 1) continue;
                String value = childNode.getFirstChild() != null ? childNode.getFirstChild().getNodeValue() : childNode.getNodeValue();
                this.setProperty(childNode.getNodeName(), value);
            }
        }
    }

    public boolean writeFile() {
        boolean success = false;
        Document doc = this.getFileXMLDoc();
        if (doc == null) {
            return success;
        }
        NodeList childNodeList = doc.getFirstChild().getChildNodes();
        if (null != childNodeList && childNodeList.getLength() > 0) {
            for (int i = childNodeList.getLength() - 1; i >= 0; --i) {
                String value;
                Node childNode = childNodeList.item(i);
                if (childNode.getFirstChild() == null || (value = this.getProperty(childNode.getNodeName())).equals("")) continue;
                childNode.getFirstChild().setNodeValue(value);
            }
        }
        StringBuffer filePath = new StringBuffer(TEPathManager.CONFIG_PROFILE_PATH).append(FILE_NAME);
        File SysCfgFile = TERWCfgFile.getBundleRWCfgFileObj(TEResourceManager.class, filePath.toString());
        SysCfgFile.delete();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(SysCfgFile.getAbsolutePath()));
            transformer.transform(source, result);
            success = true;
        }
        catch (TransformerConfigurationException e) {
            success = false;
            TELogFactory.getNormalLogger().error("replace language Fail!", (Throwable)e);
        }
        catch (TransformerException e) {
            success = false;
            TELogFactory.getNormalLogger().error("replace language Fail!", (Throwable)e);
        }
        return success;
    }

    private String getProperty(String key) {
        String result = "";
        if (key.equalsIgnoreCase(PWD_MIN_LENGTH)) {
            result = String.valueOf(this.pwdminlength);
        } else if (key.equalsIgnoreCase(PWD_MAX_LENGTH)) {
            result = String.valueOf(this.pwdmaxlength);
        } else if (key.equalsIgnoreCase(LOGIN_FAIL)) {
            result = String.valueOf(this.loginfail);
        } else if (key.equalsIgnoreCase(LOCK_TIME)) {
            result = String.valueOf(this.locktime);
        } else if (key.equalsIgnoreCase(PWD_VALIDATE)) {
            result = String.valueOf(this.pwvalidate);
        } else if (key.equalsIgnoreCase(CONFRIM_DAYS)) {
            result = String.valueOf(this.confirmdays);
        }
        return result;
    }

    private void setProperty(String key, String value) {
        if (value == null || value.equals("")) {
            return;
        }
        if (key.equalsIgnoreCase(PWD_MIN_LENGTH)) {
            this.pwdminlength = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase(PWD_MAX_LENGTH)) {
            this.pwdmaxlength = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase(LOGIN_FAIL)) {
            this.loginfail = Integer.parseInt(value);
        } else if (key.equalsIgnoreCase(LOCK_TIME)) {
            this.locktime = Integer.parseInt(value);
        } else if (key.equals(PWD_VALIDATE)) {
            this.pwvalidate = Integer.valueOf(value);
        } else if (key.equals(CONFRIM_DAYS)) {
            this.confirmdays = Integer.valueOf(value);
        }
    }

    private String getLockKey(String username, String ipaddr) {
        return username + "-" + ipaddr;
    }

    public void setUserLock(String username, String ipaddr) {
        this.lockinfo.put(this.getLockKey(username, ipaddr), Calendar.getInstance().getTimeInMillis());
    }

    public int checkUserLock(String username, String ipaddr) {
        Long lock = this.lockinfo.get(this.getLockKey(username, ipaddr));
        if (lock != null) {
            if (this.locktime == 0) {
                return 999999;
            }
            long time = (long)this.locktime * 60000L - (Calendar.getInstance().getTimeInMillis() - lock);
            if (time <= 0L) {
                this.lockinfo.remove(this.getLockKey(username, ipaddr));
            } else {
                return (int)(time / 60000L) + 1;
            }
        }
        return 0;
    }

    public int getUserLoginFail(String username, String ipaddr) {
        Integer fail = this.loginfailinfo.get(this.getLockKey(username, ipaddr));
        int failnum = 0;
        if (fail != null) {
            failnum = fail;
        }
        return failnum;
    }

    public void setUserLoginFail(String username, String ipaddr, int loginfail) {
        this.loginfailinfo.put(this.getLockKey(username, ipaddr), loginfail);
    }

    public void removeUserLoginFail(String username, String ipaddr) {
        this.loginfailinfo.remove(this.getLockKey(username, ipaddr));
    }

    public int getInvalidDays(String username, byte[] password) {
        int result = this.getPwvalidate();
        Dao dao = TEDaoHolder.getInstance().getDao();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", username);
        params.put("param2", EncryptUtils.encryptAESByte2Str(password));
        List users = dao.getListByHql("from TELctUser where userName = :param1 and password = :param2 order by time desc", params);
        if (!users.isEmpty()) {
            long creatTime = ((TELctUser)users.get(0)).getTime().getTime();
            long curTime = System.currentTimeMillis();
            long validTime = (long)this.getPwvalidate() * 86400000L;
            long gap = validTime - (curTime - creatTime);
            result = new BigDecimal(gap).divide(new BigDecimal(86400000L), 0, 0).intValue();
        }
        return result;
    }
}

