/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESecurityLogMgr {
    private static TEResourceUtil res;
    private static TESecurityLogMgr instance;

    private TESecurityLogMgr() {
    }

    public static TESecurityLogMgr getInstance() {
        if (null == instance) {
            instance = new TESecurityLogMgr();
            TESecurityLogMgr.initLogRes();
        }
        return instance;
    }

    public static void initLogRes() {
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append("res").append(File.separator).append("loginres").append("_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEResourceUtil.getInstance(tempBuf.toString());
    }

    public String getLogRes(String key) {
        return res.getString(key);
    }

    public void writeLog(String ipAddress, int cmdID, String operName, String operDesc, int result, int errorCode) {
        try {
            TELogInfo loginfo = new TELogInfo();
            loginfo.setUserID(TESecurityVerify.getSuperUserID());
            loginfo.setCmdID(cmdID);
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(operName);
            loginfo.setOperateObject("Web LCT");
            loginfo.setOperateDesc(operDesc);
            loginfo.setResult(result);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            TELogMgr.writeLog(loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer security log fault:\n", (Throwable)e);
        }
    }
}

