/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.commextend.security.AsnGetRsaKeyReq;
import com.huawei.commextend.security.AsnGetRsaKeyRsp;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import net.commustru.fstru.FStruct;

public class TERSAKeyManager {
    private static final int FRAME_CMD_GET_RSAKEY = 4193199;
    private static final int KEY_LENGTH = 2048;
    private static String RSA_KEYPAIR = File.separator + "conf" + File.separator + "RSAKeyPair.ser";

    public static KeyPair generateKeypair() {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            return kpg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("RSA algorithm not supported", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveKeyPair(KeyPair kp) {
        FileOutputStream fos = null;
        BufferedWriter oos = null;
        try {
            fos = new FileOutputStream(TEResourceManager.getFileByName(RSA_KEYPAIR));
            oos = new BufferedWriter(new OutputStreamWriter(fos));
            RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)kp.getPrivate();
            String pubmoduleStr = publicKey.getModulus().toString(16);
            String pubexponentStr = publicKey.getPublicExponent().toString(16);
            String primoduleStr = privateKey.getModulus().toString(16);
            String priexponentStr = privateKey.getPrivateExponent().toString(16);
            oos.write(EncryptUtils.encryptAES(pubmoduleStr));
            oos.newLine();
            oos.write(EncryptUtils.encryptAES(pubexponentStr));
            oos.newLine();
            oos.write(EncryptUtils.encryptAES(primoduleStr));
            oos.newLine();
            oos.write(EncryptUtils.encryptAES(priexponentStr));
            oos.newLine();
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("saveKeyPair fail!", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("saveKeyPair fail!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair getKeyPair() {
        FileInputStream fis = null;
        BufferedReader oos = null;
        String pubmodule = "";
        String pubexponent = "";
        String primodule = "";
        String priexponent = "";
        try {
            fis = new FileInputStream(TEResourceManager.getFileByName(RSA_KEYPAIR));
            oos = new BufferedReader(new InputStreamReader(fis));
            String pubmoduleStr = oos.readLine();
            String pubexponentStr = oos.readLine();
            String primoduleStr = oos.readLine();
            String priexponentStr = oos.readLine();
            pubmodule = EncryptUtils.decryptAES(pubmoduleStr);
            pubexponent = EncryptUtils.decryptAES(pubexponentStr);
            primodule = EncryptUtils.decryptAES(primoduleStr);
            priexponent = EncryptUtils.decryptAES(priexponentStr);
            oos.close();
            oos = null;
            fis.close();
            fis = null;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getKeyPair fail!", (Throwable)e);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("getKeyPair fail!", (Throwable)e);
            }
        }
        return TERSAKeyManager.getKeyPairFromParams(pubmodule, pubexponent, primodule, priexponent);
    }

    private static KeyPair getKeyPairFromParams(String pubModuleHex, String pubExponenHex, String priModuleHex, String priExponenHex) {
        KeyPair keypair = null;
        try {
            BigInteger module = new BigInteger(pubModuleHex, 16);
            BigInteger exponent = new BigInteger(pubExponenHex, 16);
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(module, exponent);
            BigInteger primodule = new BigInteger(priModuleHex, 16);
            BigInteger priexponent = new BigInteger(priExponenHex, 16);
            RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(primodule, priexponent);
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey pubkey = fact.generatePublic(pubKeySpec);
            PrivateKey privateKey = fact.generatePrivate(priKeySpec);
            keypair = new KeyPair(pubkey, privateKey);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get RSAKeyPair From Integration fail!", (Throwable)e);
        }
        return keypair;
    }

    public static KeyPair getKeyPairIntegration() {
        AsnGetRsaKeyReq req = new AsnGetRsaKeyReq();
        req.userID = BigInteger.valueOf(10L);
        AsnGetRsaKeyRsp rsp = new AsnGetRsaKeyRsp();
        int errCode = TEASN1CommMgr.sendCommand(TEASN1CommMgr.DAM_PROCID, (FStruct)req, (FStruct)rsp, 4193199);
        TELogFactory.getNormalLogger().error("get RSAKeyPair From Integration Send Message ErrorCode is " + errCode);
        if (errCode != 0) {
            return null;
        }
        TELogFactory.getNormalLogger().error("get RSAKeyPair From Integration DAM Query ResultCode is " + rsp.result.intValue());
        if (rsp.result.intValue() != 0) {
            return null;
        }
        String moduleStr = new String(rsp.publicKey.modulus);
        String exponentStr = new String(rsp.publicKey.exponent);
        BigInteger module = new BigInteger(moduleStr, 16);
        BigInteger exponent = new BigInteger(exponentStr, 16);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(module, exponent);
        String primoduleStr = new String(rsp.privateKey.modulus);
        String priexponentStr = new String(rsp.privateKey.exponent);
        BigInteger primodule = new BigInteger(primoduleStr, 16);
        BigInteger priexponent = new BigInteger(priexponentStr, 16);
        RSAPrivateKeySpec priKeySpec = new RSAPrivateKeySpec(primodule, priexponent);
        KeyPair keypair = null;
        try {
            KeyFactory fact = KeyFactory.getInstance("RSA");
            PublicKey pubkey = fact.generatePublic(pubKeySpec);
            PrivateKey privateKey = fact.generatePrivate(priKeySpec);
            keypair = new KeyPair(pubkey, privateKey);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get RSAKeyPair From Integration fail!", (Throwable)e);
        }
        return keypair;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            result.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    public static byte[] hexStringToByteArray(String data) {
        int k = 0;
        byte[] results = new byte[data.length() / 2];
        int kLength = results.length;
        int iLength = data.length();
        int i = 0;
        while (i < iLength - 1 && k < kLength) {
            results[k] = (byte)(Character.digit(data.charAt(i++), 16) << 4);
            int n = k++;
            results[n] = (byte)(results[n] + (byte)Character.digit(data.charAt(i++), 16));
        }
        return results;
    }

    public static byte[] decrypt(PrivateKey privateKey, byte[] raw) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        return cipher.doFinal(raw);
    }
}

