/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEQueryRSAKeyPairServlet
extends HttpServlet {
    private static final long serialVersionUID = -8858534496127615999L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Datainterface outputData = new Datainterface();
        try {
            KeyPair kp = EncryptUtils.getKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)kp.getPublic();
            BussinessParams bussiness = new BussinessParams();
            RowParams row = new RowParams();
            row.addParam("public_key_n", publicKey.getModulus().toString(16));
            row.addParam("public_key_e", publicKey.getPublicExponent().toString(16));
            bussiness.addRowParams(row);
            outputData.setBussinessParams(bussiness);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        }
        catch (Exception e) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            TELogFactory.getNormalLogger().info("TEQueryRSAKeyPaireSevlet fail!", (Throwable)e);
        }
        try {
            response.setContentType("text/xml;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            StringWriter out = new StringWriter();
            outputData.marshal(out);
            response.getWriter().println(((Object)out).toString());
            response.getWriter().close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryRSAKeyPaireSevlet fail!", (Throwable)e);
            return;
        }
    }
}

