/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TEDaoHolder;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.po.security.TELctUser;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TECheckSessionTimeoutUtil;
import com.huawei.nglct.security.TESecurityLogMgr;
import com.huawei.nglct.security.TESecurityPolicyBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.uflight.hibernate.Dao;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEModifyPassword
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int TE_ERR_MODIFY_PWD_SUCC = 1090781205;
    private static final int TE_ERR_OLDPWD_ERROR = 1090781206;
    private static final int TE_ERR_PWD_DIFF = 1090781207;
    private static final int TE_ERR_MODIFY_PWD_FAIL = 1090781208;
    private static final int TE_ERR_NULL_PWD = 1090744371;
    private static final String CONTENT_TYPE = "text/html; charset=UTF-8";
    private static final String SPECIAL_LETTER = "`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/? ";
    private static final int USERNUM_USED_LATEST = 5;
    private static final long TWOMONTH = Long.valueOf(60L) * 24L * 3600L * 1000L;
    private static final int SBS_IS_NULL = 5;
    private static final int USER_NOT_EXIST_OR_SBS_ERROR = 3;

    public void init() throws ServletException {
    }

    public String encodeMsg(String msg) {
        String str = null;
        try {
            str = TESysManagerBean.getInstance().getlanguage().equalsIgnoreCase("zh") ? URLEncoder.encode(msg, "UTF-8") : msg;
        }
        catch (UnsupportedEncodingException e) {
            TELogFactory.getNormalLogger().error("TEModifyPassword.encodeMsg() fail!", (Throwable)e);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) throws IOException, ServletException {
        String info;
        String operName;
        String operDesc = operName = TESecurityLogMgr.getInstance().getLogRes("changepassword");
        String localURL = null;
        try {
            localURL = httpReqeust.getLocalAddr();
        }
        catch (Throwable ex) {
            TELogFactory.getNormalLogger().error("TSLoginCheck.doPost() fail!", ex);
        }
        finally {
            localURL = "127.0.0.1";
        }
        httpResponse.setContentType(CONTENT_TYPE);
        String contextPath = httpReqeust.getContextPath();
        String user = TESysManagerBean.getInstance().getSysUser();
        byte[] voldPass = EncryptUtils.decrypt(httpReqeust.getParameter("oldPass"));
        byte[] newPassword = EncryptUtils.decrypt(httpReqeust.getParameter("newPass"));
        byte[] confirmPsw = EncryptUtils.decrypt(httpReqeust.getParameter("confirmPass"));
        int result = 0;
        if (Arrays.equals(newPassword, confirmPsw)) {
            String error = this.checkPasswordPolicy(newPassword, voldPass);
            if (error.length() > 0) {
                EncryptUtils.clearByte(voldPass);
                EncryptUtils.clearByte(newPassword);
                EncryptUtils.clearByte(confirmPsw);
                this.redirectErrorPage(httpReqeust, httpResponse, error);
                TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1090781208);
                return;
            }
            result = TESysManagerBean.getInstance().modifyPassword(user, voldPass, newPassword);
        } else {
            result = 1090781207;
        }
        if (0 == result) {
            this.saveNewPwd(user, newPassword);
            info = TEErrorResourceUtil.getErrCodeResWithDot(1090781205);
            String sendURL = "";
            sendURL = TESysManagerBean.getInstance().getlanguage().equals("zh") ? contextPath + "/weblct" + "/page/password.html" + "?msg=" + this.encodeMsg(info) + "&succ=1" : contextPath + "/weblct" + "/page/password.html" + "?msg=" + info + "&succ=1";
            if (TESystemUtil.isPassNeedChange(httpReqeust)) {
                TESystemUtil.setLoginSuccess(httpReqeust);
                TESysManagerBean.getInstance().setForceChangePwd(false);
                TECheckSessionTimeoutUtil.getInstance().setOperTime(httpReqeust);
                String redirectURL = TESystemUtil.getNeListURL(httpReqeust, httpResponse);
                sendURL = sendURL + sendURL + "&redirecturl=" + URLEncoder.encode(redirectURL, "UTF-8");
            }
            httpResponse.sendRedirect(sendURL);
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 0, 0);
        } else {
            TELogFactory.getStartupLogger().info("[TEModifyPassword]old password is wrong.");
            info = this.matchErrInfo(result);
            this.redirectErrorPage(httpReqeust, httpResponse, info);
            TESecurityLogMgr.getInstance().writeLog(localURL, 0, operName, operDesc, 2, 1090781208);
        }
        EncryptUtils.clearByte(voldPass);
        EncryptUtils.clearByte(newPassword);
        EncryptUtils.clearByte(confirmPsw);
    }

    private String checkPasswordPolicy(byte[] password, byte[] oldpassword) {
        String errorInfo = "";
        if (!TESecurityPolicyBean.getInstance().checkPassword(password)) {
            errorInfo = TENEListUtils.getString("pwdlengtherror");
            errorInfo = errorInfo.replaceAll("%m", String.valueOf(TESecurityPolicyBean.getInstance().getPwdMinLength()));
            errorInfo = errorInfo.replaceAll("%x", String.valueOf(TESecurityPolicyBean.getInstance().getPwdMaxLength()));
            return errorInfo;
        }
        boolean bExistNumber = false;
        boolean bExistLower = false;
        boolean bExistSupper = false;
        boolean bExistSpecial = false;
        int len = password.length;
        for (int i = 0; i < len; ++i) {
            char code = (char)password[i];
            if (code >= '0' && code <= '9') {
                bExistNumber = true;
                continue;
            }
            if (code >= 'a' && code <= 'z') {
                bExistLower = true;
                continue;
            }
            if (code >= 'A' && code <= 'Z') {
                bExistSupper = true;
                continue;
            }
            if (SPECIAL_LETTER.indexOf(code) < 0) continue;
            bExistSpecial = true;
        }
        if (!bExistSpecial) {
            errorInfo = TENEListUtils.getString("pswspecialerror1") + SPECIAL_LETTER.trim() + TENEListUtils.getString("pswspecialerror2");
        }
        if (!bExistNumber) {
            errorInfo = TENEListUtils.getString("pwdnumbererror");
        }
        if (!bExistSupper) {
            errorInfo = TENEListUtils.getString("pwdsupererror");
        }
        if (!bExistLower) {
            errorInfo = TENEListUtils.getString("pwdlowererrror");
        }
        if (this.checkValidPwd(password, oldpassword)) {
            errorInfo = TENEListUtils.getString("pwdinvaliderror");
        }
        return errorInfo;
    }

    private boolean checkValidPwd(byte[] password, byte[] oldpassword) {
        return Arrays.equals(oldpassword, password) || !this.isValidPwd(null, password);
    }

    private String matchErrInfo(int result) {
        int errCode;
        switch (result) {
            case 5: {
                errCode = 1090744371;
                break;
            }
            case 2: {
                errCode = 1090781206;
                break;
            }
            case 1090781207: {
                errCode = 1090781207;
                break;
            }
            case 3: {
                errCode = 1090781206;
                break;
            }
            default: {
                errCode = 1090781208;
            }
        }
        return TEErrorResourceUtil.getErrCodeResWithDot(errCode);
    }

    private void redirectErrorPage(HttpServletRequest httpReqeust, HttpServletResponse httpResponse, String errorCode) throws IOException {
        String contextPath = httpReqeust.getContextPath();
        httpResponse.sendRedirect(contextPath + "/weblct" + "/page/password.html" + "?msg=" + this.encodeMsg(errorCode));
    }

    protected void doGet(HttpServletRequest httpReqeust, HttpServletResponse httpResponse) throws IOException, ServletException {
        this.doPost(httpReqeust, httpResponse);
    }

    private boolean isValidPwd(String userName, byte[] password) {
        boolean result = true;
        if (userName == null) {
            userName = TESysManagerBean.getInstance().getSysUser();
        }
        Dao dao = TEDaoHolder.getInstance().getDao();
        HashSet userSet = new HashSet();
        List userList = null;
        boolean currentPage = false;
        int pageSize = 5;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", userName);
        userList = dao.getListByHqlAndPage("from TELctUser where userName = :param1 order by time desc", params, 0, 5);
        userSet.addAll(userList);
        userList.clear();
        params.clear();
        Date endDate = new Date();
        long validTime = TWOMONTH;
        Date startDate = new Date(endDate.getTime() - validTime);
        params.put("param1", userName);
        params.put("param2", startDate);
        params.put("param3", endDate);
        userList = dao.getListByHql("from TELctUser where userName = :param1 and time >= :param2 and time <= :param3", params);
        userSet.addAll(userList);
        TELctUser tempUser = new TELctUser();
        tempUser.setUserName(userName);
        tempUser.setPassword(EncryptUtils.encryptAESByte2Str(password));
        if (userSet.contains(tempUser)) {
            result = false;
        }
        userList.clear();
        userList = null;
        userSet.clear();
        userSet = null;
        return result;
    }

    private void saveNewPwd(String userName, byte[] password) {
        TELctUser user = new TELctUser();
        user.setUserName(userName);
        user.setPassword(EncryptUtils.encryptAESByte2Str(password));
        user.setTime(new Date());
        Dao dao = TEDaoHolder.getInstance().getDao();
        dao.save((Object)user);
        user = null;
    }
}

