/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class TEFetchMac {
    private boolean iswin = true;
    private List<String> macArray = new ArrayList<String>();

    public TEFetchMac() {
        this.macArray.clear();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("windows") != -1) {
            this.iswin = true;
            this.getWinInfo();
        } else {
            this.iswin = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getWinInfo() {
        String tmpStr = "";
        String tmpValue = "";
        BufferedReader lnReader = null;
        try {
            Process process = Runtime.getRuntime().exec("ipconfig -all");
            InputStreamReader isReader = new InputStreamReader(process.getInputStream());
            lnReader = new LineNumberReader(isReader);
            while ((tmpStr = ((LineNumberReader)lnReader).readLine()) != null) {
                if (tmpStr.indexOf("Physical Address") == -1) continue;
                tmpValue = tmpStr.substring(tmpStr.lastIndexOf(58) + 1, tmpStr.length()).trim();
                this.macArray.add(tmpValue);
            }
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("getMacbyC file failed!", (Throwable)ex);
        }
        finally {
            if (lnReader != null) {
                try {
                    lnReader.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("Close lnReader failed!", (Throwable)e);
                }
            }
        }
    }

    public String[] getMac() {
        if (this.iswin) {
            return this.macArray.toArray(new String[0]);
        }
        return this.getSMac();
    }

    public String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            TELogFactory.getNormalLogger().error("Failed to get IP!", (Throwable)e);
            return "";
        }
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            TELogFactory.getNormalLogger().error("Failed to get host name!", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSMac() {
        ArrayList<String> restr = new ArrayList<String>();
        String tmpStr = "";
        String tmpMAC = "";
        BufferedReader lnReader = null;
        try {
            Process process = Runtime.getRuntime().exec("ifconfig -a");
            InputStreamReader isReader = new InputStreamReader(process.getInputStream());
            lnReader = new LineNumberReader(isReader);
            while ((tmpStr = ((LineNumberReader)lnReader).readLine()) != null) {
                if (tmpStr.indexOf("ether") == -1) continue;
                int index = tmpStr.indexOf("ether");
                tmpMAC = tmpStr.substring(index + 5).trim();
                restr.add(tmpMAC);
            }
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error("getMacbyC file!", (Throwable)ex);
        }
        finally {
            if (lnReader != null) {
                try {
                    lnReader.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("close LineNumberReader failed!", (Throwable)e);
                }
            }
        }
        return restr.toArray(new String[0]);
    }
}

