/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TECheckSessionTimeoutUtil {
    private static TECheckSessionTimeoutUtil instance;
    private static final String NO_CHECK = "0";
    private static final String OPER_TIME = "operTime";
    private static final String IS_EXCEPTION = "isexception";
    private static final String SFID = "sfid";
    private static final String DEFAULT_SESSION_TIMEOUT = "15";
    private static final int MINUTE = 60000;
    private static final List<String> EXC_REQS;

    public static synchronized TECheckSessionTimeoutUtil getInstance() {
        if (instance == null) {
            instance = new TECheckSessionTimeoutUtil();
        }
        return instance;
    }

    private TECheckSessionTimeoutUtil() {
        this.init();
    }

    private void init() {
        EXC_REQS.add("neListServlet;280");
        EXC_REQS.add("neExlorerServlet;2109575");
        EXC_REQS.add("neExlorerServlet;2109610");
        EXC_REQS.add("neExlorerServlet;2099240");
        EXC_REQS.add("neExlorerServlet;2179573");
        EXC_REQS.add("images/gateway.gif");
        EXC_REQS.add("neExlorerServlet;2117638");
        EXC_REQS.add("neExlorerServlet;2172149");
        EXC_REQS.add("isModifyTL1ExplorerServlet");
    }

    public synchronized void setOperTime(HttpServletRequest httpRequest) {
        if (this.isException(httpRequest)) {
            return;
        }
        HttpSession session = httpRequest.getSession();
        session.setAttribute(OPER_TIME, (Object)new Date());
    }

    public synchronized boolean isTimeout(HttpServletRequest httpRequest) {
        boolean result = false;
        String timeOut = TESysManagerBean.getInstance().getProperty("sessionTimeout");
        if (timeOut == null || timeOut.isEmpty()) {
            timeOut = DEFAULT_SESSION_TIMEOUT;
        }
        if (NO_CHECK.equals(timeOut) || this.isException(httpRequest)) {
            return result;
        }
        HttpSession session = httpRequest.getSession();
        if (session.getAttribute(OPER_TIME) == null) {
            result = true;
        } else {
            long time;
            long preActiveTime = ((Date)session.getAttribute(OPER_TIME)).getTime();
            long curTime = System.currentTimeMillis();
            long noActionTime = curTime - preActiveTime;
            if (noActionTime > (time = new BigDecimal(timeOut).longValue() * 60000L)) {
                result = true;
                TELogFactory.getNormalLogger().info("session time out, need login agin. sessionID is " + session.getId() + ", url is " + httpRequest.getRequestURL());
            }
        }
        return result;
    }

    private boolean isException(HttpServletRequest httpRequest) {
        String isException;
        boolean result = false;
        StringBuilder reqKey = new StringBuilder();
        String url = httpRequest.getRequestURL().toString();
        url = url.substring(url.indexOf("weblct") + 7);
        reqKey.append(url);
        String sfid = httpRequest.getParameter(SFID);
        if (sfid != null) {
            reqKey.append(";").append(sfid);
        }
        if ((isException = httpRequest.getParameter(IS_EXCEPTION)) != null) {
            reqKey.append(";").append(isException);
        }
        for (String excptionKes : EXC_REQS) {
            if (!excptionKes.equals(reqKey.toString())) continue;
            result = true;
        }
        return result;
    }

    static {
        EXC_REQS = new ArrayList<String>();
    }
}

