/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.security;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.security.TERSAKeyManager;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.uflight.util.SecurityUtil;
import com.swimap.external.cbb.baseutil.AESCipher;
import com.swimap.external.cbb.baseutil.CipherCommon;
import com.swimap.external.cbb.baseutil.CipherException;
import com.swimap.external.dsf.cbb.serverutil.ExternalUtil;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;

public class EncryptUtils {
    private static KeyPair keyPair = null;
    private static final int MAX_SHA256_PASSWORD = 32;
    private static final String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static KeyPair getKeyPair() {
        if (keyPair == null) {
            EncryptUtils.initRSAKeyPair();
        }
        return keyPair;
    }

    public static void setKeyPair(KeyPair keyPair) {
        EncryptUtils.keyPair = keyPair;
    }

    private static void initRSAKeyPair() {
        KeyPair keypair = null;
        keypair = TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() ? TERSAKeyManager.getKeyPairIntegration() : TERSAKeyManager.getKeyPair();
        EncryptUtils.setKeyPair(keypair);
    }

    public static String encrypt(String raw) {
        String result = raw;
        KeyPair keyp = EncryptUtils.getKeyPair();
        if (keyp != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, keyp.getPublic());
                result = TERSAKeyManager.byteArrayToHexString(cipher.doFinal(raw.getBytes()));
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("encrypt fail!", (Throwable)e);
            }
        }
        return result;
    }

    public static String encrypt(byte[] raw) {
        String result = "";
        KeyPair keyp = EncryptUtils.getKeyPair();
        if (keyp != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, keyp.getPublic());
                result = TERSAKeyManager.byteArrayToHexString(cipher.doFinal(raw));
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("encrypt fail!", (Throwable)e);
            }
        }
        return result;
    }

    public static byte[] decrypt(String raw) {
        if (null == raw) {
            return null;
        }
        if (raw.isEmpty()) {
            return raw.getBytes();
        }
        byte[] result = null;
        KeyPair keyp = EncryptUtils.getKeyPair();
        if (keyp != null) {
            try {
                RSAPrivateKey privateKey = (RSAPrivateKey)keyp.getPrivate();
                byte[] encrypted_bytes = TERSAKeyManager.hexStringToByteArray(raw);
                result = TERSAKeyManager.decrypt(privateKey, encrypted_bytes);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("decrypt fail!", (Throwable)e);
            }
        }
        return result;
    }

    public static String encryptAES(String content) {
        String result = "";
        try {
            result = String.valueOf(AESCipher.encrypt((char[])content.toCharArray(), (Key)ExternalUtil.getFixedKey()));
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("TEEncryptForNeListInfo-> Encrypt Error!", (Throwable)e);
        }
        return result;
    }

    public static byte[] encryptAES(byte[] content) {
        byte[] result = null;
        try {
            result = AESCipher.encrypt((byte[])content, (Key)ExternalUtil.getFixedKey());
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("TEEncryptForNeListInfo-> Encrypt Error!", (Throwable)e);
        }
        return result;
    }

    public static String decryptAES(String raw) {
        String result = "";
        try {
            result = String.valueOf(AESCipher.decrypt((char[])raw.toCharArray(), (Key)ExternalUtil.getFixedKey()));
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("TEEncryptForNeListInfo-> doDecrypt Error!", (Throwable)e);
        }
        return result;
    }

    public static byte[] decryptAES(byte[] raw) {
        byte[] result = null;
        try {
            result = AESCipher.decrypt((byte[])raw, (Key)ExternalUtil.getFixedKey());
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("EncryptUtils-> decryptAES Error!", (Throwable)e);
        }
        return result;
    }

    public static char[] decryptAESStr2Char(String value) {
        char[] result = null;
        try {
            result = AESCipher.decrypt((char[])value.toCharArray(), (Key)ExternalUtil.getFixedKey());
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("EncryptUtils-> decryptAESStr2Char Error!", (Throwable)e);
        }
        return result;
    }

    public static String encryptAESChar2Str(char[] value) {
        String result = null;
        try {
            result = String.valueOf(AESCipher.encrypt((char[])value, (Key)ExternalUtil.getFixedKey()));
        }
        catch (CipherException e) {
            TELogFactory.getNormalLogger().error("EncryptUtils-> encryptAESChar2Str Error!", (Throwable)e);
        }
        return result;
    }

    public static byte[] decryptAESStr2Byte(String value) {
        return SecurityUtil.decryptStrToByte((String)value);
    }

    public static String encryptAESByte2Str(byte[] value) {
        return SecurityUtil.encryptByteToStr((byte[])value);
    }

    public static void clearByte(byte[] value) {
        if (value != null && value.length > 0) {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                value[i] = 0;
            }
        }
        value = null;
    }

    public static void clearChar(char[] value) {
        if (value != null && value.length > 0) {
            int len = value.length;
            for (int i = 0; i < len; ++i) {
                value[i] = '\u0000';
            }
        }
    }

    public static byte[] decodePlainText(char[] paramChar) {
        return CipherCommon.decodePlainText((char[])paramChar);
    }

    public static char[] encodePlainText(byte[] paramByte) {
        return CipherCommon.encodePlainText((byte[])paramByte);
    }

    public static byte[] convertStr2Byte(String value) {
        return value.getBytes();
    }

    public static String convertByte2Str(byte[] value) {
        return new String(value);
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer sb = new StringBuffer();
        for (byte byt : byteArray) {
            sb.append(EncryptUtils.byteToHexString(byt));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String data) {
        int k = 0;
        byte[] results = new byte[data.length() / 2];
        int kLength = results.length;
        int iLength = data.length();
        int i = 0;
        while (i < iLength - 1 && k < kLength) {
            results[k] = (byte)(Character.digit(data.charAt(i++), 16) << 4);
            int n = k++;
            results[n] = (byte)(results[n] + (byte)Character.digit(data.charAt(i++), 16));
        }
        return results;
    }

    private static String byteToHexString(byte byt) {
        int n = byt;
        if (n < 0) {
            n = 256 + n;
        }
        return hexDigits[n / 16] + hexDigits[n % 16];
    }

    private static String Encode(String code, String message, int length) {
        if (message == null) {
            return "";
        }
        String encode = null;
        try {
            MessageDigest md = MessageDigest.getInstance(code);
            byte[] input = EncryptUtils.getEncryptBytes(code, length);
            encode = EncryptUtils.byteArrayToHexString(md.digest(input));
        }
        catch (NoSuchAlgorithmException e) {
            TELogFactory.getNormalLogger().error("EncryptUtils-> Encode Error! Encode kind:" + code, (Throwable)e);
        }
        return encode;
    }

    private static byte[] getEncryptBytes(String message, int length) {
        byte[] input = message.getBytes();
        if (input.length >= length) {
            return input;
        }
        byte[] output = new byte[length];
        for (int i = 0; i < length; ++i) {
            output[i] = i < input.length ? output[i] : (byte)0;
        }
        return output;
    }

    public static String encryptSHA256(String message) {
        return EncryptUtils.Encode("SHA-256", message, 32);
    }
}

