/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.report;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.report.TETableHeadInfoBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseTableHeadBean {
    private TEParseTableHeadBean() {
    }

    public static List getTableHead(int neid, String filename) {
        StringBuffer bundleName = new StringBuffer();
        ArrayList<TETableHeadInfoBean> headList = new ArrayList<TETableHeadInfoBean>();
        StringBuffer path = new StringBuffer(TEResourceManager.getPath()).append(File.separator);
        if (neid == 99999) {
            path.append(filename);
        } else {
            path.append(TEGetFilePath.getDomainFilePathAndBundleName(neid, filename, bundleName));
        }
        try {
            Document doc = TEParseXMLFile.parseFile(path.toString());
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                String width;
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("col") || (width = secondNode.getAttributes().getNamedItem("width").getNodeValue().trim()).indexOf(48) == 0) continue;
                String name = secondNode.getAttributes().getNamedItem("name").getNodeValue();
                String id = secondNode.getAttributes().getNamedItem("id").getNodeValue();
                Node isTimeColumnNode = secondNode.getAttributes().getNamedItem("isTimeColumn");
                TETableHeadInfoBean headInfo = new TETableHeadInfoBean();
                headInfo.id = id;
                headInfo.name = name;
                headInfo.width = width;
                headInfo.isTimeColumn = isTimeColumnNode != null && isTimeColumnNode.getNodeValue() != null && isTimeColumnNode.getNodeValue().equals("true");
                headList.add(headInfo);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEParseTableHeadBean.getTableHead() fail!", (Throwable)e);
        }
        return headList;
    }

    public static List getTableHead(int neid, Datainterface inputData) {
        ArrayList<TETableHeadInfoBean> headList = new ArrayList<TETableHeadInfoBean>();
        int count = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 1; i < count; ++i) {
            TETableHeadInfoBean headInfo = new TETableHeadInfoBean();
            RowParams rowParam = inputData.getBussinessParams().getRowParams(i);
            Param param = rowParam.getParam("id");
            if (param != null && param.getValue() != null) {
                headInfo.id = URLDecoder.decode(param.getValue());
            }
            if ((param = rowParam.getParam("name")) != null && param.getValue() != null) {
                headInfo.name = URLDecoder.decode(param.getValue());
            }
            if ((param = rowParam.getParam("width")) != null && param.getValue() != null) {
                headInfo.width = URLDecoder.decode(param.getValue());
            }
            if ((param = rowParam.getParam("isTimeColumn")) != null && param.getValue() != null) {
                headInfo.isTimeColumn = URLDecoder.decode(param.getValue()).equalsIgnoreCase("true");
            }
            headList.add(headInfo);
        }
        return headList;
    }
}

