/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ptn_pub;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEPTNUtil {
    private static int INVALID_SUBSLOT = 255;
    private static int MLPPP = 4096;
    private static int SERIAL = 6144;
    private static int SERIAL_MAX = 8191;
    private static int VIRTUAL = 10240;
    private static int VIRTUAL_MAX = 12288;
    private static int VIRTUAL_2 = 14336;
    private static int VIRTUAL_EXCURSION = 2048;
    private static int VIRTUAL_VE_START = 28928;
    private static int VIRTUAL_VE_END = 29439;
    private static int VIRTUAL_VLANAGGR_START = 29440;
    private static int VIRTUAL_VLANAGGR_END = 36863;
    private static String SPACE = " ";
    private static String RP = ")";
    private static String SUB = "-";
    private static TEPTNUtil util = null;
    private static String S_MLPPP = "(MP-";
    private static String S_SEARIAL = "(Serial-";
    private static String S_VPORT = "(VEther-";
    private static String VLANAGGR_VPORT = "(VLANAggr-";
    private static String VE_VPORT = "(VE-";
    private static final String FILTER_BOARD_XML_FILE = TEResourceManager.getPath() + "nemgr/device/ptn/conf/filterboards/defineboards.xml";
    private HashMap<String, TIntHashSet> funBoardMap = new HashMap();
    private static final HashMap<Integer, Integer> InterfaceProcessMap_3900 = new HashMap();
    private static final HashMap<Integer, Integer> InterfaceProcessMap_3900_8 = new HashMap();

    private TEPTNUtil() {
        this.readFile();
    }

    public static final synchronized TEPTNUtil instance() {
        if (util == null) {
            util = new TEPTNUtil();
        }
        return util;
    }

    private void readFile() {
        try {
            File filterBoardsFile = new File(TEResourceManager.getFileRealPath(FrameworkUtil.getBundle(TEPTNUtil.class), FILTER_BOARD_XML_FILE));
            Document filterBoardsDoc = TEParseXMLFile.parseFile(filterBoardsFile);
            NodeList nodeList = filterBoardsDoc.getElementsByTagName("filter");
            Element ele = null;
            int boardValue = -1;
            String boardName2 = null;
            TIntHashSet boardsets = null;
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                ele = (Element)nodeList.item(i);
                String[] splitBoardsNames = ele.getTextContent().split(",");
                boardsets = new TIntHashSet();
                for (String boardName2 : splitBoardsNames) {
                    if (boardName2 != null) {
                        boardName2 = boardName2.trim();
                    }
                    if (0 == (boardValue = SDXMLInterpreterMgr.getInstance().parseInt(boardName2))) continue;
                    boardsets.add(boardValue);
                }
                this.funBoardMap.put(ele.getAttribute("name"), boardsets);
            }
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Read File failed!:", (Throwable)e);
        }
    }

    public synchronized TIntHashSet getFilterBoardsSet(int neID, String filterName) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boardList = ne.getClonedBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int boardtype = board.getBoardType();
            TECircuitPackDescription.getInstance().loadCircuitPackDescription(boardtype);
        }
        TIntHashSet set = this.funBoardMap.get(filterName);
        if (set == null) {
            set = new TIntHashSet();
            TELogFactory.getNormalLogger().error("Can't find filtername: " + filterName + " in defineboards.xml");
        }
        return set;
    }

    public synchronized void setFilterBoards(String filterName, int boardType) {
        TIntHashSet set = this.funBoardMap.get(filterName);
        if (set == null) {
            set = new TIntHashSet();
        }
        set.add(boardType);
    }

    public String getLogicPortName(int phyPortID, String portName) {
        String fullPortName = "";
        String portValue = "";
        if (MLPPP <= phyPortID && SERIAL > phyPortID) {
            portValue = "" + (phyPortID - MLPPP);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + S_MLPPP + portName + ")";
        } else if (phyPortID >= SERIAL && phyPortID < SERIAL_MAX) {
            portValue = "" + (phyPortID - SERIAL);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + S_SEARIAL + portName + ")";
        } else if (phyPortID >= VIRTUAL && phyPortID < VIRTUAL_MAX) {
            portValue = "" + (phyPortID - VIRTUAL);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + S_VPORT + portName + ")";
        } else if (phyPortID >= VIRTUAL_VE_START && phyPortID <= VIRTUAL_VE_END) {
            portValue = "" + (phyPortID - VIRTUAL_VE_START + 1);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + VE_VPORT + portName + ")";
        } else if (phyPortID >= VIRTUAL_VLANAGGR_START && phyPortID <= VIRTUAL_VLANAGGR_END) {
            portValue = "" + (phyPortID - VIRTUAL_VLANAGGR_START + 1);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + VLANAGGR_VPORT + portName + ")";
        } else if (phyPortID >= VIRTUAL_2) {
            portValue = "" + (phyPortID - VIRTUAL_2 + VIRTUAL_EXCURSION);
            if (portName == null || portName.equals("")) {
                portName = portValue;
            }
            fullPortName = fullPortName + portValue + S_VPORT + portName + ")";
        }
        return fullPortName;
    }

    public void processMPAndVEthnetPortName(ArrayList<RowParams> rowList, Output[] outputArray) {
        int i;
        String portName = "";
        HashMap<String, String> portNameMap = new HashMap<String, String>();
        int len = outputArray.length;
        for (i = 0; i < len; ++i) {
            Output output = outputArray[i];
            if (!String.valueOf(0).equals(output.getFault(0).getCode()) || output.getPartValue("portName") == null) continue;
            String portid = output.getPartValue("port");
            String portname = output.getPartValue("portName").trim();
            portNameMap.put(portid, portname);
        }
        int size = rowList.size();
        for (i = 0; i < size; ++i) {
            RowParams row = rowList.get(i);
            Param portidParam = row.getParam("port");
            if (null == portidParam) continue;
            int portid = Integer.parseInt(portidParam.getValue());
            if (portid >= MLPPP && portid < SERIAL) {
                portName = (String)portNameMap.get(String.valueOf(portid));
                if (portName == null || "".equals(portName.trim())) {
                    portName = portid - MLPPP + "";
                }
                row.getParam("portname").setValue(portid - MLPPP + S_MLPPP + portName.trim() + ")");
                continue;
            }
            if ((portid < VIRTUAL || portid >= VIRTUAL_MAX) && portid < VIRTUAL_2) continue;
            portName = (String)portNameMap.get(String.valueOf(portid));
            if (portid >= VIRTUAL_VE_START && portid < VIRTUAL_VLANAGGR_END) {
                portName = this.getLogicPortName(portid, portName);
                row.getParam("portname").setValue(portName);
                continue;
            }
            int portExcursion = VIRTUAL;
            if (VIRTUAL_2 <= portid) {
                portExcursion = VIRTUAL_2 - VIRTUAL_EXCURSION;
            }
            if (portName == null || "".equals(portName.trim())) {
                portName = portid - portExcursion + "";
            }
            row.getParam("portname").setValue(portid - portExcursion + S_VPORT + portName.trim() + ")");
        }
    }

    public boolean isVEPort(int portID) {
        return portID >= VIRTUAL_VE_START && portID <= VIRTUAL_VE_END;
    }

    public void spellPortNameForLog(int portid, StringBuffer operDesc, int neid, RowParams rowparams) {
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        if (MLPPP <= portid && SERIAL > portid) {
            operDesc.append(portid - MLPPP).append(S_MLPPP).append(portid - MLPPP).append(RP).append(SPACE);
        } else if (VIRTUAL <= portid) {
            operDesc.append(portid - VIRTUAL).append(S_VPORT).append(portid - VIRTUAL).append(RP).append(SPACE);
        } else {
            int slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int boardType = configurDataMgr.getBoardType(neid, slotid);
            String boardName = configurDataMgr.getBoardTypeName(neid, boardType);
            int subslotid = Integer.parseInt(rowparams.getParam("subslotid").getValue());
            if (INVALID_SUBSLOT != subslotid) {
                int subboardType = configurDataMgr.getSubboardType(neid, slotid, subslotid);
                String subboardName = configurDataMgr.getBoardTypeName(neid, subboardType);
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(neid, slotid, boardType, Integer.parseInt(port));
                operDesc.append(slotid).append(SUB).append(boardName).append(SUB).append(subslotid).append(SUB).append(subboardName).append(SUB).append(portName).append(SPACE);
            } else {
                String port = rowparams.getParam("port").getValue();
                String portName = configurDataMgr.getPortName(neid, slotid, boardType, Integer.parseInt(port));
                operDesc.append(slotid).append(SUB).append(boardName).append(SUB).append(portName).append(SPACE);
            }
        }
    }

    public static int getAbsolutePortID(int domainType, int subSlotID, int physiPort) {
        int absolutePortID = TEConfigurationDataMgr.getAbsolutPort(domainType, physiPort);
        if (subSlotID == 255) {
            return absolutePortID;
        }
        return subSlotID << 24 | absolutePortID;
    }

    public static int getProcessBoardSlotID(int neid, int slotid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        int processBoardSlotID = 0;
        processBoardSlotID = 59 == neType ? InterfaceProcessMap_3900.get(slotid) : (78 == neType ? InterfaceProcessMap_3900_8.get(slotid) : 0);
        if (0 != processBoardSlotID && null == ne.getBoard(processBoardSlotID)) {
            --processBoardSlotID;
        }
        return processBoardSlotID;
    }

    static {
        InterfaceProcessMap_3900.put(19, 1);
        InterfaceProcessMap_3900.put(20, 1);
        InterfaceProcessMap_3900.put(21, 2);
        InterfaceProcessMap_3900.put(22, 2);
        InterfaceProcessMap_3900.put(23, 3);
        InterfaceProcessMap_3900.put(24, 3);
        InterfaceProcessMap_3900.put(25, 4);
        InterfaceProcessMap_3900.put(26, 4);
        InterfaceProcessMap_3900.put(31, 15);
        InterfaceProcessMap_3900.put(32, 15);
        InterfaceProcessMap_3900.put(33, 16);
        InterfaceProcessMap_3900.put(34, 16);
        InterfaceProcessMap_3900.put(35, 17);
        InterfaceProcessMap_3900.put(36, 17);
        InterfaceProcessMap_3900.put(37, 18);
        InterfaceProcessMap_3900.put(38, 18);
        InterfaceProcessMap_3900_8.put(1, 5);
        InterfaceProcessMap_3900_8.put(2, 5);
        InterfaceProcessMap_3900_8.put(3, 6);
        InterfaceProcessMap_3900_8.put(4, 6);
        InterfaceProcessMap_3900_8.put(15, 13);
        InterfaceProcessMap_3900_8.put(16, 13);
        InterfaceProcessMap_3900_8.put(17, 14);
        InterfaceProcessMap_3900_8.put(18, 14);
    }
}

