/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po.ttp.sdh;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.po.ttp.TEHighOrderInterface;
import gnu.trove.TIntArrayList;
import java.util.BitSet;

public class TEVC4TTPInterface
implements TEHighOrderInterface {
    public BitSet m_TsUsedFlag = new BitSet(67);
    public BitSet m_XCLevelFlag = new BitSet(4);

    public TIntArrayList getAvaliableTs(int xcLevel) {
        TIntArrayList vecTs = new TIntArrayList();
        if (xcLevel == 4865 || xcLevel == 4864) {
            if (!this.m_TsUsedFlag.isEmpty()) {
                vecTs.add(1);
            }
        } else if (xcLevel == 4099) {
            if (!this.m_TsUsedFlag.get(0)) {
                for (int iVC3 = 1; iVC3 <= 3; ++iVC3) {
                    int iVC12;
                    if (this.m_TsUsedFlag.get(1 + iVC3 - 1)) continue;
                    for (iVC12 = 4 + iVC3 - 1; iVC12 <= 66 && !this.m_TsUsedFlag.get(iVC12); iVC12 += 3) {
                    }
                    if (iVC12 <= 66) continue;
                    vecTs.add(iVC3);
                }
            }
        } else if (xcLevel == 4097) {
            if (!this.m_TsUsedFlag.get(0)) {
                for (int iVC12 = 1; iVC12 <= 63; ++iVC12) {
                    int iTempVC3 = iVC12 % 3;
                    iTempVC3 = iTempVC3 == 0 ? 3 : (iTempVC3 += 0);
                    if (this.m_TsUsedFlag.get(iVC12 + 4 - 1) || this.m_TsUsedFlag.get(iTempVC3)) continue;
                    vecTs.add(iVC12);
                }
            }
        } else {
            vecTs.clear();
        }
        return vecTs;
    }

    public boolean testTsUsedFlag(int tsNo, int xcLevel) {
        switch (xcLevel) {
            case 4097: {
                tsNo += 3;
                break;
            }
            case 4099: {
                tsNo += 0;
                break;
            }
            case 4864: 
            case 4865: {
                if (1 != tsNo) {
                    return false;
                }
                --tsNo;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("Invalid Interface Level, Level = " + xcLevel);
                return true;
            }
        }
        return this.m_TsUsedFlag.get(tsNo);
    }

    @Override
    public void copyForDM(TEHighOrderInterface other) {
    }

    @Override
    public void resetTsUsedFlag() {
        this.m_TsUsedFlag.set(0, this.m_TsUsedFlag.length(), false);
        this.m_XCLevelFlag.set(0, this.m_XCLevelFlag.length(), false);
    }

    public int ifVC4Used() {
        if (0 < this.m_TsUsedFlag.cardinality()) {
            return 1;
        }
        return 0;
    }

    public void initTsUsedFlag() {
        this.resetTsUsedFlag();
    }

    public void addTsUsedFlag(BitSet tsUsedFlag) {
        this.m_TsUsedFlag.or(tsUsedFlag);
    }

    public boolean isXCLevel(int xcLevel) {
        int iNo;
        switch (xcLevel) {
            case 4097: {
                iNo = 3;
                break;
            }
            case 4099: {
                iNo = 2;
                break;
            }
            case 4864: {
                iNo = 1;
                break;
            }
            case 4865: {
                iNo = 0;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("Invalid Interface Level, Level = " + xcLevel);
                return false;
            }
        }
        return this.m_XCLevelFlag.get(iNo);
    }

    public void addXCLevelFlag(BitSet levelFlag) {
        this.m_XCLevelFlag.or(levelFlag);
    }
}

