/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po.ttp.sdh;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.mo.AID;
import com.huawei.nglct.mo.ttp.TETTPKey;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.po.ttp.TESubTTPSink;
import com.huawei.nglct.po.ttp.TETP;
import com.huawei.nglct.po.ttp.sdh.TEVC4TTPInterface;
import com.huawei.nglct.po.ttp.sdh.TEVC4TTPSource;
import com.huawei.nglct.util.device.port.TEPortUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.List;

public class TEVC12TTPSink
extends TESubTTPSink {
    private int VC4No;
    private int usageState;
    private String SRJ2;
    private int SRV5;
    private int SRJ2ByteMode;

    public TEVC12TTPSink() {
        this.VC4No = 0;
        this.usageState = 0;
        this.SRJ2 = "48 75 61 57 65 69 20 53 42 53 20 20 20 20 20";
        this.SRJ2ByteMode = 16;
        this.SRV5 = 2;
    }

    public TEVC12TTPSink(TEVC12TTPSink o) {
        this.VC4No = o.VC4No;
        this.usageState = o.usageState;
        this.SRJ2 = o.SRJ2;
        this.SRJ2ByteMode = o.SRJ2ByteMode;
        this.SRV5 = o.SRV5;
    }

    public int getVC4No() {
        return this.VC4No;
    }

    public void setVC4No(int no) {
        this.VC4No = no;
    }

    public int getUsageState() {
        return this.usageState;
    }

    public void setUsageState(int usageState) {
        this.usageState = usageState;
    }

    public String getSRJ2() {
        return this.SRJ2;
    }

    public void setSRJ2(String srj2) {
        this.SRJ2 = srj2;
    }

    public int getSRV5() {
        return this.SRV5;
    }

    public void setSRV5(int srv5) {
        this.SRV5 = srv5;
    }

    public int getSRJ2ByteMode() {
        return this.SRJ2ByteMode;
    }

    public void setSRJ2ByteMode(int byteMode) {
        this.SRJ2ByteMode = byteMode;
    }

    @Override
    public int getAttrib(int attribID, List<TEOmniAttrib> value) {
        TEOmniAttrib attrTmp = new TEOmniAttrib();
        attrTmp.setIndex1(this.getTTPID());
        attrTmp.setAttribId(attribID);
        switch (attribID) {
            case 208902: {
                attrTmp.setValue(this.getSRJ2());
                value.add(attrTmp);
                break;
            }
            case 208934: {
                attrTmp.setValue(String.valueOf(this.getSRV5()));
                value.add(attrTmp);
                break;
            }
            case 208931: {
                attrTmp.setValue(String.valueOf(this.getSRJ2ByteMode()));
                value.add(attrTmp);
                break;
            }
        }
        return 0;
    }

    @Override
    public void setAttrib(List<TEOmniAttrib> value) {
        TEOmniAttrib attrTmp = null;
        int m = value.size();
        block8: for (int i = 0; i < m; ++i) {
            attrTmp = value.get(i);
            switch (attrTmp.getAttribId()) {
                case 208902: {
                    this.setSRJ2(attrTmp.getValue());
                    continue block8;
                }
                case 208934: {
                    this.setSRV5(Integer.valueOf(attrTmp.getValue()));
                    continue block8;
                }
                case 208931: {
                    this.setSRJ2ByteMode(Integer.valueOf(attrTmp.getValue()));
                    continue block8;
                }
                case 208917: {
                    continue block8;
                }
                case 208935: {
                    continue block8;
                }
                case 208932: {
                    continue block8;
                }
            }
        }
    }

    @Override
    public void initialize(int fbType, int ttpID, int parentID) {
        super.initialize(fbType, ttpID, parentID);
        this.VC4No = 0;
        TETP pVC4 = this.getParentTP();
        if (null != pVC4) {
            this.VC4No = pVC4.getTTPID();
        }
        this.usageState = 0;
        this.SRJ2 = "48 75 61 57 65 69 20 53 42 53 20 20 20 20 20";
        this.SRJ2ByteMode = 16;
        this.SRV5 = 2;
    }

    @Override
    public int getTTPNo() {
        int tmp = this.VC4No;
        return (tmp << 16 & 0xFFFF0000) + this.getTTPID();
    }

    @Override
    public boolean toKey(TETTPKey key) {
        key.setPara(this.getType(), this.getPortNo(), this.VC4No, this.getTTPID());
        return true;
    }

    @Override
    public void getTTPInfo(TIntObjectHashMap ttpInfo) {
        super.getTTPInfo(ttpInfo);
        TETP pTP = this.getParentTP();
        if (null == pTP) {
            TELogFactory.getNormalLogger().info("GetTTPInfo: get VC4TTPSink fail, vc4 = " + this.VC4No + ", vc12 = " + this.getTTPID());
            return;
        }
        TEVC4TTPSource pVC4 = (TEVC4TTPSource)pTP;
        TEVC4TTPInterface pVC4If = (TEVC4TTPInterface)pVC4.getTsBridge();
        TIntArrayList vecTs = pVC4If.getAvaliableTs(4097);
        if (!vecTs.contains(this.getTTPID())) {
            ttpInfo.put(775, (Object)2);
        }
        int id = this.getTTPID();
        id = TEPortUtil.TTPSlotTrans(96, id);
        String ttpName = this.getName();
        ttpName = ttpName + "(" + id + ")";
        ttpInfo.put(771, (Object)ttpName);
    }

    @Override
    public AID getAID() {
        AID aid = super.getAID();
        if (aid.m_vecLocation.size() > 0) {
            aid.m_vecLocation.set(aid.m_vecLocation.size() - 1, (this.getTTPID() - 1) % 3 + 1);
            aid.m_vecLocation.add(this.getTTPID());
        }
        return aid;
    }

    public void setDefaultValue(TIntObjectHashMap defValue) {
        this.setSRJ2((String)defValue.get(208902));
        this.setSRV5((Integer)defValue.get(208934));
        this.setSRJ2ByteMode((Integer)defValue.get(208931));
    }

    public boolean isEqualAttr(TEVC12TTPSink o) {
        return this.SRV5 == o.SRV5 && this.SRJ2ByteMode == o.SRJ2ByteMode && this.SRJ2.equals(o.SRJ2);
    }
}

