/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po.ttp;

import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.mo.AID;
import com.huawei.nglct.mo.TEMOCommon;
import com.huawei.nglct.mo.ttp.TETTPKey;
import com.huawei.nglct.po.TEOmniAttrib;
import com.huawei.nglct.po.ttp.TETP;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class TESubTP
implements Serializable {
    private int neID;
    private int slotID;
    private int portNo = -1;
    protected int portInnerType;
    private int type;
    private int TTPID;
    private String name;
    private String userLabel;
    private String owner;
    private int ptype = -1;
    private int pttpId = -1;

    public TESubTP() {
        this.type = 255;
        this.TTPID = 0;
        this.name = "";
        this.userLabel = "";
        this.owner = "";
    }

    public TESubTP(TESubTP o) {
        this.neID = o.neID;
        this.slotID = o.slotID;
        this.portNo = o.portNo;
        this.type = o.type;
        this.TTPID = o.TTPID;
        this.name = o.name;
        this.userLabel = o.userLabel;
        this.owner = o.owner;
        this.ptype = o.ptype;
        this.pttpId = o.pttpId;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getTTPID() {
        return this.TTPID;
    }

    public void setTTPID(int ttpid) {
        this.TTPID = ttpid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserLabel() {
        return this.userLabel;
    }

    public void setUserLabel(String userLabel) {
        this.userLabel = userLabel;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void initialize(int fbType, int ttpID, int parentID) {
        this.type = fbType;
        this.TTPID = ttpID;
        this.name = TEMOCommon.getTTPDefaultName(fbType, ttpID);
    }

    public int getPtype() {
        return this.ptype;
    }

    public void setPtype(int ptype) {
        this.ptype = ptype;
    }

    public int getPttpId() {
        return this.pttpId;
    }

    public void setPttpId(int pttpId) {
        this.pttpId = pttpId;
    }

    public int getPortInnerType() {
        return this.portInnerType;
    }

    public void setPortInnerType(int portInnerType) {
        this.portInnerType = portInnerType;
    }

    public TETP getParentTP() {
        TETP tp = new TETP();
        tp.setNeID(this.neID);
        tp.setSlotID(this.slotID);
        tp.setPortNo(this.portNo);
        tp.setType(this.ptype);
        tp.setTTPID(this.pttpId);
        tp = (TETP)CommonDaoService.getById(TETP.class, tp);
        return tp;
    }

    public boolean isNameModify() {
        return !this.name.equals(TEMOCommon.getTTPDefaultName(this.type, this.TTPID));
    }

    public void getTTPInfo(TIntObjectHashMap ttpInfo) {
        ttpInfo.put(771, (Object)this.getUserName());
        ttpInfo.put(773, (Object)0);
        ttpInfo.put(775, (Object)0);
        ttpInfo.put(774, (Object)0);
    }

    public String getUserName() {
        return this.name;
    }

    public void getUserName(Map<Integer, String> name) {
        TETP pTP = this.getParentTP();
        if (null != pTP) {
            name.put(4, pTP.getUserName());
            name.put(5, this.getUserName());
        } else {
            name.put(4, this.getUserName());
        }
    }

    public int getTTPNo() {
        return (this.pttpId << 16 & 0xFFFF0000) + this.TTPID;
    }

    public boolean toKey(TETTPKey key) {
        key.setTTPType(this.type);
        key.setPortID(this.getPortNo());
        key.setTTPID(this.getTTPNo());
        return true;
    }

    public void copyForDM(TESubTP pOtherSubTP) {
        this.name = pOtherSubTP.getName();
        this.owner = pOtherSubTP.getOwner();
        this.userLabel = pOtherSubTP.getUserLabel();
    }

    public int getAttrib(int attribID, List<TEOmniAttrib> value) {
        return 0;
    }

    public void setAttrib(List<TEOmniAttrib> value) {
    }

    public AID getAID() {
        AID aid = new AID(this.getType(), 255);
        TIntArrayList listLocation = new TIntArrayList();
        listLocation.insert(0, this.getTTPID());
        return aid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.TTPID;
        result = 31 * result + this.neID;
        result = 31 * result + this.portNo;
        result = 31 * result + this.slotID;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TESubTP other = (TESubTP)obj;
        if (this.TTPID != other.TTPID) {
            return false;
        }
        if (this.neID != other.neID) {
            return false;
        }
        if (this.portNo != other.portNo) {
            return false;
        }
        if (this.slotID != other.slotID) {
            return false;
        }
        return this.type == other.type;
    }
}

