/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import gnu.trove.TLongObjectHashMap;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;

public final class TESubrackTypes {
    public static final long SR_OSN6800 = 131924104L;
    public static final long SR_OSN8800I = 128843912L;
    public static final long SR_OSN8800II = 129302664L;
    public static final long SR_OSN8800IE = 128843873L;
    public static final long SR_OSN8800IIE = 129302626L;
    public static final long SR_OSN9560 = 134086792L;
    public static final long SR_1600G_ENHANCED = 131203210L;
    public static final long SR_1600G_STANDARD = 131203208L;
    public static final long SR_1600GOLA = 131596424L;
    public static final long SR_1600A = 132186248L;
    public static final long SR_OSN6800A = 132645001L;
    public static final long SR_OSN8800INA = 133890185L;
    public static final long SR_OSN8800IINA = 129433737L;
    public static final long SR_OSN1800_1U_SHELF = 128909452L;
    public static final long SR_OSN1800_2U_SHELF = 128909453L;
    public static final long SR_OSN1800_2UII_SHELF = 128909465L;
    public static final long SR_OSN18001U_AIR_CONVECTION = 128909454L;
    public static final long SR_OSN1800NA_1U_SHELF = 132776076L;
    public static final long SR_OSN1800NA_2U_SHELF = 132776077L;
    public static final long SR_OSN1800NA1U_AIR_CONVECTION = 132776078L;
    public static final long SR_OSN8800T16_SHELF = 130023560L;
    public static final long SR_OSN8800T16NA_SHELF = 130089097L;
    public static final long SR_OSN8800T32ENA_SHELF = 133890148L;
    public static final long SR_OSN8800T64ENA_SHELF = 129433701L;
    public static final long SR_OSN6800_OPTICAL = 131924061L;
    public static final long SR_BWS1600ST16 = 134021256L;
    public static final long SR_OSN9800_U32 = 130547848L;
    public static final long SR_OSN9800_U64 = 130613384L;
    public static final long SR_OSN9800_P18 = 130678900L;
    public static final long SR_OSN9600_U32 = 125894792L;
    public static final long SR_OSN9600_U64 = 125960328L;
    public static final long SR_OSN9600_P18 = 129826939L;
    public static final String OSN1800NA_1U_STR = "1U";
    public static final String OSN1800NA_2U_STR = "2U";
    public static final String OSN1800_1U_STR = "140";
    public static final String OSN1800_2U_STR = "141";
    public static final String OSN1800_2UII_STR = "153";
    public static final String OSN6800_OPTICAL = "93";
    public static final String OSN1800NA_1U_AUTO_COOL_STR = "1U_AUTO_COOL";
    public static final long SR_OSN1832_STD = 130154605L;
    public static final long SR_OSN1832_PLATFORM = 130154606L;
    public static final String OSN1832_STD_STR = "109";
    public static final String OSN1832_PLATFORM_STR = "110";
    public static final String BWS1600ST16_STR = "96";
    public static final long SR_OSN8800_PLATFORM = 130351206L;
    public static final String OSN8800_PLATFORM_STR = "102";
    public static final String OSD9800U32_STR = "112";
    public static final String OSD9800U64_STR = "111";
    public static final String OSD9800P18_STR = "116";
    public static final String OSD9800P16_STR = "174";
    public static final int SPAN = 65536;
    public static final int ST_WDMSTANDARD = 136;
    public static final String OSD9600U32_STR = "117";
    public static final String OSD9600U64_STR = "118";
    public static final String OSD9600P18_STR = "123";
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    private TLongObjectHashMap<String> cToWTypeMap = new TLongObjectHashMap();
    private Map<String, Integer> subrackToNeTypeMap = new Hashtable<String, Integer>();
    private Map<String, Integer> tl1subrackNameToSubrackID = new Hashtable<String, Integer>();
    private static TESubrackTypes instance = null;

    private TESubrackTypes() {
        this.registerCToWTypeMapping();
    }

    public static synchronized TESubrackTypes getInstance() {
        if (instance == null) {
            instance = new TESubrackTypes();
        }
        return instance;
    }

    public String getSubrackType(long cnemgrSubrackType) {
        String wnemgrType = (String)this.cToWTypeMap.get(cnemgrSubrackType);
        if (null == wnemgrType) {
            embededWnemgrlog.error("Get wnemgr subrack error! cnemgrSubrackType->" + cnemgrSubrackType);
        }
        return wnemgrType;
    }

    public int getNeType(String subrackType) {
        int neType = -1;
        if (this.subrackToNeTypeMap.containsKey(subrackType)) {
            neType = this.subrackToNeTypeMap.get(subrackType);
        }
        return neType;
    }

    public int getTL1SubrackType(String subrackName) {
        int subrackType = -1;
        if (this.tl1subrackNameToSubrackID.containsKey(subrackName)) {
            subrackType = this.tl1subrackNameToSubrackID.get(subrackName);
        }
        return subrackType;
    }

    private void registerCToWTypeMapping() {
        this.registerQxTypeMapping();
        this.registerTL1TypeMapping();
    }

    private void registerQxTypeMapping() {
        this.cToWTypeMap.put(131924104L, (Object)String.valueOf(51));
        this.cToWTypeMap.put(128843912L, (Object)String.valueOf(68));
        this.cToWTypeMap.put(129302664L, (Object)String.valueOf(74));
        this.cToWTypeMap.put(128843873L, (Object)String.valueOf(97));
        this.cToWTypeMap.put(129302626L, (Object)String.valueOf(98));
        this.cToWTypeMap.put(130023560L, (Object)String.valueOf(84));
        this.cToWTypeMap.put(134086792L, (Object)String.valueOf(79));
        this.cToWTypeMap.put(128909452L, (Object)OSN1800_1U_STR);
        this.cToWTypeMap.put(128909453L, (Object)OSN1800_2U_STR);
        this.cToWTypeMap.put(128909465L, (Object)OSN1800_2UII_STR);
        this.cToWTypeMap.put(131924061L, (Object)OSN6800_OPTICAL);
        this.cToWTypeMap.put(128909454L, (Object)String.valueOf(67));
        this.cToWTypeMap.put(130154605L, (Object)OSN1832_STD_STR);
        this.cToWTypeMap.put(130154606L, (Object)OSN1832_PLATFORM_STR);
        this.cToWTypeMap.put(134021256L, (Object)BWS1600ST16_STR);
        this.cToWTypeMap.put(130351206L, (Object)OSN8800_PLATFORM_STR);
        this.cToWTypeMap.put(130547848L, (Object)OSD9800U32_STR);
        this.cToWTypeMap.put(130613384L, (Object)OSD9800U64_STR);
        this.cToWTypeMap.put(130678900L, (Object)OSD9800P18_STR);
        this.cToWTypeMap.put(125894792L, (Object)OSD9600U32_STR);
        this.cToWTypeMap.put(125960328L, (Object)OSD9600U64_STR);
        this.cToWTypeMap.put(129826939L, (Object)OSD9600P18_STR);
    }

    private void registerCToWTypeMap(int devType, int shelfType, String tl1name) {
        long keyValue;
        if (TESysManagerBean.getInstance().isIntegratedStatus() && !this.cToWTypeMap.containsKey(keyValue = (long)(devType * 65536 + shelfType))) {
            if (tl1name != null && !tl1name.equals("")) {
                this.cToWTypeMap.put(keyValue, (Object)tl1name);
            } else {
                int neShelfType = shelfType;
                if (shelfType == 136) {
                    neShelfType = TEGetNEDomainVersion.getInstance().getNeType(devType);
                }
                this.cToWTypeMap.put(keyValue, (Object)String.valueOf(neShelfType));
            }
        }
    }

    private void registerSubrackToNeTypeMap(int devType, int shelfType, String tl1name) {
        int neType = TEGetNEDomainVersion.getInstance().getNeType(devType);
        if (tl1name != null && !tl1name.equals("")) {
            this.subrackToNeTypeMap.put(tl1name, neType);
            this.tl1subrackNameToSubrackID.put(tl1name, shelfType);
        } else if (shelfType != 136) {
            this.subrackToNeTypeMap.put(String.valueOf(shelfType), neType);
        }
    }

    public void registerTypeMapping(int devType, int shelfType, String tl1name) {
        this.registerCToWTypeMap(devType, shelfType, tl1name);
        this.registerSubrackToNeTypeMap(devType, shelfType, tl1name);
    }

    private void registerTL1TypeMapping() {
        this.cToWTypeMap.put(132645001L, (Object)"SHELF6800A");
        this.cToWTypeMap.put(133890185L, (Object)"SHELF8800I");
        this.cToWTypeMap.put(129433737L, (Object)"SHELF8800II");
        this.cToWTypeMap.put(130089097L, (Object)"SHELF8800T16");
        this.cToWTypeMap.put(133890148L, (Object)"SHELF8800T32E");
        this.cToWTypeMap.put(129433701L, (Object)"SHELF8800T64E");
        this.cToWTypeMap.put(132776076L, (Object)OSN1800NA_1U_STR);
        this.cToWTypeMap.put(132776077L, (Object)OSN1800NA_2U_STR);
        this.cToWTypeMap.put(132776078L, (Object)OSN1800NA_1U_AUTO_COOL_STR);
    }
}

