/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po;

import com.huawei.nglct.bscfg.installcp.TECPDBMgr;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.mo.TECPFb;
import com.huawei.nglct.mo.TEPhyPort2PPort;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.po.TECPCorrelateContainer;
import com.huawei.nglct.po.TECircuitPack;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.po.TEPortAttrib;
import com.huawei.nglct.po.ttp.TETP;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.port.TEPortUtil;
import gnu.trove.TIntHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEPortPO
implements Serializable,
Comparable {
    private int logicNeId;
    private int slotId;
    private int portNo;
    private int dynType;
    private boolean enable;
    private int interfaceLevel;
    private String name = "";
    private String owner = "";
    private int portDynSn;
    private int portInnerType;
    private int signalType;
    private int subFbgroup;
    private int usageState;
    private String userLable = "";
    private Set<TEPortAttrib> attributes = new HashSet<TEPortAttrib>();
    private Set<TETP> tps = new HashSet<TETP>();

    public TEPortPO() {
        this.dynType = 1;
        this.enable = true;
    }

    public TEPortPO(int neID, int slotID, int portNo) {
        this.logicNeId = neID;
        this.slotId = slotID;
        this.portNo = portNo;
    }

    public TEPortPO(int neID, int slotID, int portNo, int dynType, boolean enable, int interfaceLevel, String name, String owner, int portDynSn, int portInnerType, int signalType, int subFbgroup, int usageState, String userLable) {
        this.logicNeId = neID;
        this.slotId = slotID;
        this.portNo = portNo;
        this.dynType = dynType;
        this.enable = enable;
        this.interfaceLevel = interfaceLevel;
        this.name = name;
        this.owner = owner;
        this.portDynSn = portDynSn;
        this.portInnerType = portInnerType;
        this.signalType = signalType;
        this.subFbgroup = subFbgroup;
        this.usageState = usageState;
        this.userLable = userLable;
    }

    public void initialize(int neID, int slotID, int portNo, int portType, int eLevel, String name, int signaltype) {
        this.logicNeId = neID;
        this.slotId = slotID;
        this.portNo = portNo;
        this.portInnerType = portType;
        this.portDynSn = 0;
        this.interfaceLevel = eLevel;
        this.usageState = 0;
        this.name = name;
        this.signalType = signaltype;
        this.dynType = 1;
    }

    public void setData(TECPAddiblePortRecord portInfo, boolean bSave) {
        this.portNo = portInfo.portID;
        this.portInnerType = portInfo.portType;
        this.subFbgroup = portInfo.m_SubFBGroup;
        this.interfaceLevel = portInfo.m_interface;
        this.usageState = portInfo.portUsage;
        this.signalType = portInfo.signalType;
        this.dynType = portInfo.portDynType;
        if (bSave) {
            CommonDaoService.save(this);
        }
    }

    public int getLogicNeId() {
        return this.logicNeId;
    }

    public void setLogicNeId(int logicNeId) {
        this.logicNeId = logicNeId;
    }

    public int getSlotId() {
        return this.slotId;
    }

    public void setSlotId(int slotId) {
        this.slotId = slotId;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public int getDynType() {
        return this.dynType;
    }

    public void setDynType(int dynType) {
        this.dynType = dynType;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public int getInterfaceLevel() {
        return this.interfaceLevel;
    }

    public void setInterfaceLevel(int interfaceLevel) {
        this.interfaceLevel = interfaceLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getPortDynSn() {
        return this.portDynSn;
    }

    public void setPortDynSn(int portDynSn) {
        this.portDynSn = portDynSn;
    }

    public int getPortInnerType() {
        return this.portInnerType;
    }

    public void setPortInnerType(int portInnerType) {
        this.portInnerType = portInnerType;
    }

    public int getPortType() {
        int[] outerType = new int[1];
        if (TEPortDescription.getInstance().isInnerPortType(this.getPortInnerType(), outerType)) {
            return outerType[0];
        }
        return this.getPortInnerType();
    }

    public int getSignalType() {
        return this.signalType;
    }

    public void setSignalType(int signalType) {
        this.signalType = signalType;
    }

    public int getSubFbgroup() {
        return this.subFbgroup;
    }

    public void setSubFbgroup(int subFbgroup) {
        this.subFbgroup = subFbgroup;
    }

    public int getUsageState() {
        return this.usageState;
    }

    public void setUsageState(int usageState) {
        this.usageState = usageState;
    }

    public String getUserLable() {
        return this.userLable;
    }

    public void setUserLable(String userLable) {
        this.userLable = userLable;
    }

    public Set<TEPortAttrib> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set<TEPortAttrib> attributes) {
        this.attributes = attributes;
    }

    public Set<TETP> getTps() {
        return this.tps;
    }

    public void setTps(Set<TETP> tps) {
        this.tps = tps;
    }

    public boolean isSupportFB(int fbType) {
        ArrayList<TECPFb> ttpList = new ArrayList<TECPFb>();
        this.getTTPs(ttpList, fbType, false);
        return ttpList.size() > 0;
    }

    public List<TETP> getTTPs(int eFB) {
        TECircuitPack pCP = TECPDBMgr.getBoardPO(this.logicNeId, this.slotId);
        HashMap<Integer, List<TETP>> oMap = new HashMap<Integer, List<TETP>>();
        pCP.getTTPOIDs(oMap, this.portNo, eFB, false);
        return (List)oMap.get(this.portNo);
    }

    public void getTTPs(List<TECPFb> ttpList, int fbType, boolean bAllSubTP) {
        ttpList.clear();
        TECircuitPack pCP = TECPDBMgr.getBoardPO(this.logicNeId, this.slotId);
        pCP.getTTPs(ttpList, this.portNo, fbType, bAllSubTP);
    }

    public void getPortInfo(Map<Integer, Object> portInfo, boolean forCPInfo) {
        portInfo.clear();
        if (forCPInfo) {
            return;
        }
        TECircuitPack cp = new TECircuitPack(this.logicNeId, this.slotId);
        cp = (TECircuitPack)CommonDaoService.getById(TECircuitPack.class, cp);
        TENEPO ne = (TENEPO)CommonDaoService.getById(TENEPO.class, Integer.valueOf(this.logicNeId));
        portInfo.put(785, 7);
        portInfo.put(786, 7);
        if (cp != null && ne != null) {
            String defName = "";
            ArrayList<TEPhyPort2PPort> ports = new ArrayList<TEPhyPort2PPort>();
            TECPCorrelateContainer cc = (TECPCorrelateContainer)CommonDaoService.getById(TECPCorrelateContainer.class, Integer.valueOf(this.logicNeId));
            if (cc != null) {
                cc.getRelatePortByICP(ports, cp.getSlotId(), 0);
                for (TEPhyPort2PPort one : ports) {
                    if (this.portNo != one.pPort.m_PortID) continue;
                    int[] cpType = new int[1];
                    TEBoardUtil.getBoardType(ne.getNeid(), one.phySlotID, cpType);
                    defName = TEPortUtil.getPortDefaultName(this.getPortType(), this.portNo, cp.getTypeId(), one.phySlotID, cpType[0], one.phyPort.m_PortID);
                    break;
                }
            }
            if ("".equals(defName)) {
                defName = TEPortUtil.getPortDefaultName(this.getPortType(), this.portNo, cp.getTypeId(), 0, 0, 0);
            }
            portInfo.put(521, defName);
            if (!defName.equals(this.name)) {
                portInfo.put(515, this.name);
            }
        } else {
            portInfo.put(515, this.name);
        }
    }

    public int getFBCount(int eFB) {
        if (0 == eFB) {
            return 0;
        }
        int fb = eFB;
        TIntHashSet fbs = new TIntHashSet();
        TEFuncBlockDescription pFB = TEFuncBlockDescription.getInstance();
        if (pFB.isBiFBType(fb) && 0 != pFB.getFBTypeByBiType(fb, fbs)) {
            fb = fbs.toArray()[0];
        }
        ArrayList<TECPFb> ttpList = new ArrayList<TECPFb>();
        this.getTTPs(ttpList, fb, false);
        if (ttpList.size() > 0) {
            return ((TECPFb)ttpList.get((int)0)).ttpIDList.size();
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.logicNeId;
        result = 31 * result + this.portNo;
        result = 31 * result + this.slotId;
        result = 31 * result + this.portInnerType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEPortPO other = (TEPortPO)obj;
        if (this.logicNeId != other.logicNeId) {
            return false;
        }
        if (this.portNo != other.portNo) {
            return false;
        }
        if (this.slotId != other.slotId) {
            return false;
        }
        return this.portInnerType == other.portInnerType;
    }

    public int compareTo(Object o) {
        TEPortPO another = (TEPortPO)o;
        if (this.logicNeId != another.logicNeId) {
            return this.logicNeId - another.logicNeId;
        }
        if (this.slotId != another.slotId) {
            return this.slotId - another.slotId;
        }
        if (this.portNo != another.portNo) {
            return this.portNo - another.portNo;
        }
        return this.portInnerType - another.portInnerType;
    }
}

