/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po;

import com.huawei.nglct.cbb.datamanage.datasync.CompareOp;
import com.huawei.nglct.cbb.datamanage.datasync.TEDBCHGEventFile;
import com.huawei.nglct.cbb.datamanage.datasync.TEDataSyncUtil;
import com.huawei.nglct.cbb.datamanage.datasync.base.DBCHGEvent;
import com.huawei.nglct.cbb.datamanage.datasync.base.SortDBEvtPointBySEQ;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.po.TENEDBCHGEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TENEDataSyncInfo {
    private int neId = 0;
    private int lastDBCHGSEQ = 0;
    private int syncState = 0;
    private long lastSyncTime = 0L;
    private long lastDBCHGTime = 0L;
    private List<TENEDBCHGEvent> failedDBCHGEvents = new ArrayList<TENEDBCHGEvent>();

    public int getNeId() {
        return this.neId;
    }

    public void setNeId(int neId) {
        this.neId = neId;
    }

    public int getLastDBCHGSEQ() {
        return this.lastDBCHGSEQ;
    }

    public void setLastDBCHGSEQ(int lastDBCHGSEQ) {
        this.lastDBCHGSEQ = lastDBCHGSEQ;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public void setSyncState(int syncState) {
        this.syncState = syncState;
    }

    public long getLastSyncTime() {
        return this.lastSyncTime;
    }

    public void setLastSyncTime(long lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    public long getLastDBCHGTime() {
        return this.lastDBCHGTime;
    }

    public void setLastDBCHGTime(long lastDBCHGTime) {
        this.lastDBCHGTime = lastDBCHGTime;
    }

    public List<TENEDBCHGEvent> getFailedDBCHGEvents() {
        return this.failedDBCHGEvents;
    }

    public void setFailedDBCHGEvents(List<TENEDBCHGEvent> failedDBCHGEvents) {
        this.failedDBCHGEvents = failedDBCHGEvents;
    }

    public static TENEDataSyncInfo getNEDataSyncInfo(int neID) {
        return (TENEDataSyncInfo)CommonDaoService.getById(TENEDataSyncInfo.class, Integer.valueOf(neID));
    }

    public void makeFailedDBCHGEvents(List<DBCHGEvent> dbchgEventPtrVec) {
        if (null == this.failedDBCHGEvents) {
            return;
        }
        dbchgEventPtrVec.clear();
        dbchgEventPtrVec = new ArrayList<DBCHGEvent>(this.failedDBCHGEvents.size());
        int m = this.failedDBCHGEvents.size();
        for (int i = 0; i < m; ++i) {
            DBCHGEvent newEvent = new DBCHGEvent();
            this.failedDBCHGEvents.get(i).fillDBCHGEvent(newEvent);
            dbchgEventPtrVec.add(newEvent);
        }
        if (!this.failedDBCHGEvents.isEmpty()) {
            int neID = this.failedDBCHGEvents.get(0).getNeId();
            new TEDBCHGEventFile(neID).read(dbchgEventPtrVec);
        }
    }

    public void updateFailedDBCHGEvents(List<DBCHGEvent> failedEventPtrVec) {
        ArrayList<TENEDBCHGEvent> dbchgEventVec = new ArrayList<TENEDBCHGEvent>();
        int neID = 0;
        DBCHGEvent dbchgEvent = null;
        int m = failedEventPtrVec.size();
        for (int i = 0; i < m; ++i) {
            dbchgEvent = failedEventPtrVec.get(i);
            if (null == dbchgEvent) continue;
            dbchgEventVec.add(new TENEDBCHGEvent(dbchgEvent));
            if (0 == neID) {
                neID = dbchgEvent.getNeId();
                continue;
            }
            if (neID == dbchgEvent.getNeId()) continue;
            return;
        }
        if (!failedEventPtrVec.isEmpty() && 0 != neID) {
            ArrayList<TENEDBCHGEvent> tempVec = new ArrayList();
            if (null != this.failedDBCHGEvents) {
                tempVec = (List)((ArrayList)this.failedDBCHGEvents).clone();
            }
            Collections.sort(dbchgEventVec, new SortDBEvtPointBySEQ());
            Collections.sort(tempVec, new SortDBEvtPointBySEQ());
            this.updateDBCHGEventFailedTimes(tempVec, dbchgEventVec);
            if (new TEDBCHGEventFile(neID).write(failedEventPtrVec) && null != this.failedDBCHGEvents) {
                this.failedDBCHGEvents.clear();
                this.failedDBCHGEvents.addAll(dbchgEventVec);
            }
        }
        CommonDaoService.update(this);
    }

    public void updateDBCHGEventFailedTimes(List<TENEDBCHGEvent> oldEvents, List<TENEDBCHGEvent> newEvents) {
        TEDataSyncUtil.compareRange(newEvents, oldEvents, new SortDBEvtPointBySEQ(), new CompareOp());
    }

    public void clearFailedDBCHGEvents() {
        if (null != this.failedDBCHGEvents && !this.failedDBCHGEvents.isEmpty()) {
            int neID = this.failedDBCHGEvents.get(0).getNeId();
            this.failedDBCHGEvents.clear();
            CommonDaoService.update(this);
            new TEDBCHGEventFile(neID).clear();
        }
    }
}

