/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.po;

import com.huawei.nglct.bscfg.equipment.TECommuMgr;
import com.huawei.nglct.bscfg.equipment.TENEStateChangedMgr;
import com.huawei.nglct.consts.system.TESystemVariable;
import com.huawei.nglct.db.CommonDaoService;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.TEEthGne;
import com.huawei.nglct.po.TEGne;
import com.huawei.nglct.security.EncryptDes;
import com.huawei.nglct.util.string.TEConvertUtil;
import java.io.Serializable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TECommuNe
implements Serializable {
    private static final long serialVersionUID = -1226827192259408444L;
    private int logicNeId;
    private int neId;
    private String neuser;
    private String encryptPassword;
    private int mainGneId;
    private int backup1gneId;
    private int backup2gneId;
    private int backup3gneId;
    private int commuNeType;
    private int dcnxpos;
    private int dcnypos;
    private boolean isDcnAutoRestore;
    private boolean isDcnLocked;
    private int m_NeGneState = 0;
    private int m_connStateMain;
    private int[] m_connStateBackup = new int[3];
    private int m_nMainUnReachTimeCount;
    private int[] m_nBackupUnReachTimeCount = new int[3];
    private int m_iLogined;
    private boolean isAutoLogin;
    private ReadWriteLock m_rwNeMutex = new ReentrantReadWriteLock();
    private boolean m_bReceiveDataFlag;

    public TECommuNe() {
        this.setNeId(-1);
        this.setLogicNeId(-1);
        this.mainGneId = -1;
        this.commuNeType = 1;
        this.backup1gneId = -1;
        this.backup2gneId = -1;
        this.backup3gneId = -1;
        this.isDcnLocked = false;
        this.isDcnAutoRestore = true;
        this.setDcnxpos(0);
        this.setDcnypos(0);
        this.setNeuser("");
        this.setEncryptPassword("");
        if (TESystemVariable.g_bImapNoNeLogin) {
            this.setAutoLogin(false);
        } else {
            this.setAutoLogin(true);
        }
        this.m_NeGneState = 4;
        this.m_connStateMain = 1;
        int i = 0;
        for (i = 0; i < 3; ++i) {
            this.m_connStateBackup[i] = 2;
            this.m_nBackupUnReachTimeCount[i] = 0;
        }
        this.m_nMainUnReachTimeCount = 0;
        this.m_iLogined = -1;
    }

    public int getLogicNeId() {
        return this.logicNeId;
    }

    public void setLogicNeId(int logicNeId) {
        this.logicNeId = logicNeId;
    }

    public int getNeId() {
        return this.neId;
    }

    public void setNeId(int neId) {
        this.neId = neId;
    }

    public String getNeuser() {
        return this.neuser;
    }

    public void setNeuser(String neuser) {
        this.neuser = neuser;
    }

    public String getEncryptPassword() {
        return this.encryptPassword;
    }

    public void setEncryptPassword(String encryptPassword) {
        this.encryptPassword = encryptPassword;
    }

    public int getMainGneId() {
        return this.mainGneId;
    }

    public void setMainGneId(int mainGneId) {
        this.mainGneId = mainGneId;
    }

    public int getBackup1gneId() {
        return this.backup1gneId;
    }

    public void setBackup1gneId(int backup1gneId) {
        this.backup1gneId = backup1gneId;
    }

    public int getBackup2gneId() {
        return this.backup2gneId;
    }

    public void setBackup2gneId(int backup2gneId) {
        this.backup2gneId = backup2gneId;
    }

    public int getBackup3gneId() {
        return this.backup3gneId;
    }

    public void setBackup3gneId(int backup3gneId) {
        this.backup3gneId = backup3gneId;
    }

    public int getCommuNeType() {
        return this.commuNeType;
    }

    public void setCommuNeType(int commuNeType) {
        this.commuNeType = commuNeType;
    }

    public int getDcnxpos() {
        return this.dcnxpos;
    }

    public void setDcnxpos(int dcnxpos) {
        this.dcnxpos = dcnxpos;
    }

    public int getDcnypos() {
        return this.dcnypos;
    }

    public void setDcnypos(int dcnypos) {
        this.dcnypos = dcnypos;
    }

    public boolean isIsDcnAutoRestore() {
        return this.isDcnAutoRestore;
    }

    public void setIsDcnAutoRestore(boolean isDcnAutoRestore) {
        this.isDcnAutoRestore = isDcnAutoRestore;
    }

    public boolean isIsDcnLocked() {
        return this.isDcnLocked;
    }

    public void setIsDcnLocked(boolean isDcnLocked) {
        this.isDcnLocked = isDcnLocked;
    }

    public int getNeGneState() {
        return this.m_NeGneState;
    }

    public boolean isAutoLogin() {
        return this.isAutoLogin;
    }

    public void setAutoLogin(boolean isAutoLogin) {
        this.isAutoLogin = isAutoLogin;
    }

    public void initialize(int ulNeId, int ulLogicId, String strNEUser, int ulMainGneId, int nCommuNeType, int ulBackup1GneId, int ulBackup2GneId, int ulBackup3GneId, boolean bIsDcnLocked, boolean bIsDcnAutoRestore, int eNeGneState) {
        this.setNeId(ulNeId);
        this.setLogicNeId(ulLogicId);
        this.commuNeType = nCommuNeType;
        this.mainGneId = ulMainGneId;
        this.backup1gneId = ulBackup1GneId;
        this.backup2gneId = ulBackup2GneId;
        this.backup3gneId = ulBackup3GneId;
        this.isDcnLocked = bIsDcnLocked;
        this.isDcnAutoRestore = bIsDcnAutoRestore;
        this.setNeuser(strNEUser);
        if (TESystemVariable.g_bImapNoNeLogin) {
            this.setAutoLogin(false);
        } else {
            this.setAutoLogin(true);
        }
        this.setNeGneState(eNeGneState);
        this.m_connStateMain = 1;
        this.m_nMainUnReachTimeCount = 0;
        int i = 0;
        for (i = 0; i < 3; ++i) {
            this.m_connStateBackup[i] = 2;
            this.m_nBackupUnReachTimeCount[i] = 0;
        }
        this.m_bReceiveDataFlag = false;
        this.m_iLogined = -1;
        this.init();
    }

    public int init() {
        TECommuMgr pCommuMgrImpl = TECommuMgr.getInstance();
        pCommuMgrImpl.UpdateGneUsedCount(-1, this.mainGneId);
        pCommuMgrImpl.UpdateGneUsedCount(-1, this.backup1gneId);
        pCommuMgrImpl.UpdateGneUsedCount(-1, this.backup2gneId);
        pCommuMgrImpl.UpdateGneUsedCount(-1, this.backup3gneId);
        TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(this.getNeId(), this.getCurConnState() == 1);
        TENEStateChangedMgr.getInstance().getQueueLoginState().pushChangedNEID(this.getNeId(), this.getLogined() != 0);
        return 0;
    }

    public void setNeGneState(int eNeGneState) {
        int neID = this.getNeId();
        int newGneId = this.getCurGneId();
        if (this.m_NeGneState == eNeGneState) {
            TECommuMgr.getInstance().refreshMapGneMgrState(neID, newGneId);
            return;
        }
        int oldstate = this.getCurConnState();
        this.m_NeGneState = eNeGneState;
        int newstate = this.getCurConnState();
        newGneId = this.getCurGneId();
        TENE ne = TENEListMgr.getInstance().getNE(this.getLogicNeId());
        TEGne gne = (TEGne)CommonDaoService.getById(TEGne.class, Integer.valueOf(newGneId));
        if (null != ne && null != gne) {
            int gneType = gne.getGneType();
            ne.setNEGWType(gneType);
            switch (gneType) {
                case 1: {
                    TEEthGne ethGne = (TEEthGne)gne;
                    ne.setNEGWAddress(TEConvertUtil.ipToString(ethGne.getIp()));
                    ne.setPort("" + ethGne.getPort());
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        if (newstate != oldstate) {
            if (newstate == 2) {
                TECommuMgr.getInstance().NeConnBreakRpt(this.getNeId(), neID == newGneId);
                this.setLogined(false);
            } else if (newstate == 1) {
                TECommuMgr.getInstance().NeConnResumeRpt(this.getNeId(), neID == newGneId);
            }
        }
        TECommuMgr.getInstance().refreshMapGneMgrState(neID, newGneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnState(int gneId, int state) {
        this.setNEComState(state);
        int oldstate = this.getCurConnState();
        boolean bIsGne = false;
        this.m_rwNeMutex.writeLock().lock();
        try {
            if (gneId == this.getMainGneId()) {
                this.m_connStateMain = state;
                this.m_nMainUnReachTimeCount = 0;
            }
            if (gneId == this.getBackup1gneId()) {
                this.m_connStateBackup[0] = state;
                this.m_nBackupUnReachTimeCount[0] = 0;
            }
            if (gneId == this.getBackup2gneId()) {
                this.m_connStateBackup[1] = state;
                this.m_nBackupUnReachTimeCount[1] = 0;
            }
            if (gneId == this.getBackup3gneId()) {
                this.m_connStateBackup[2] = state;
                this.m_nBackupUnReachTimeCount[2] = 0;
            }
            bIsGne = this.getNeId() == this.getMainGneId();
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
        int newstate = this.getCurConnState();
        if (newstate != oldstate) {
            TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(this.getNeId(), newstate == 1);
        }
        if (newstate != oldstate) {
            if (newstate == 2) {
                TECommuMgr.getInstance().NeConnBreakRpt(this.getNeId(), bIsGne);
                this.setLogined(false);
            } else if (newstate == 1) {
                TECommuMgr.getInstance().NeConnResumeRpt(this.getNeId(), bIsGne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCurConnState() {
        int state = 2;
        this.m_rwNeMutex.readLock().lock();
        try {
            switch (this.m_NeGneState) {
                case 0: {
                    state = this.m_connStateMain;
                    return state;
                }
                case 1: {
                    state = this.m_connStateBackup[0];
                    return state;
                }
                case 2: {
                    state = this.m_connStateBackup[1];
                    return state;
                }
                case 3: {
                    state = this.m_connStateBackup[2];
                    return state;
                }
            }
            return state;
        }
        finally {
            this.m_rwNeMutex.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurConnState(int state1) {
        boolean bIsGne1;
        this.setNEComState(state1);
        int oldstate = this.getCurConnState();
        this.m_rwNeMutex.writeLock().lock();
        try {
            switch (this.m_NeGneState) {
                case 0: {
                    this.m_connStateMain = state1;
                    this.m_nMainUnReachTimeCount = 0;
                    break;
                }
                case 1: {
                    this.m_connStateBackup[0] = state1;
                    this.m_nBackupUnReachTimeCount[0] = 0;
                    break;
                }
                case 2: {
                    this.m_connStateBackup[1] = state1;
                    this.m_nBackupUnReachTimeCount[1] = 0;
                    break;
                }
                case 3: {
                    this.m_connStateBackup[2] = state1;
                    this.m_nBackupUnReachTimeCount[2] = 0;
                    break;
                }
            }
            bIsGne1 = this.getNeId() == this.getMainGneId();
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
        int newstate1 = this.getCurConnState();
        if (newstate1 != oldstate) {
            TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(this.getNeId(), newstate1 == 1);
        }
        if (newstate1 != oldstate) {
            if (newstate1 == 2) {
                TECommuMgr.getInstance().NeConnBreakRpt(this.getNeId(), bIsGne1);
                this.setLogined(false);
            } else if (newstate1 == 1) {
                TECommuMgr.getInstance().NeConnResumeRpt(this.getNeId(), bIsGne1);
            }
        }
    }

    private void setNEComState(int state) {
        TENE ne = TENEListMgr.getInstance().getNE(this.getLogicNeId());
        ne.setComStatus(state);
    }

    public int getCurGneId() {
        switch (this.getNeGneState()) {
            case 0: {
                return this.getMainGneId();
            }
            case 1: {
                return this.getBackup1gneId();
            }
            case 2: {
                return this.getBackup2gneId();
            }
            case 3: {
                return this.getBackup3gneId();
            }
        }
        return 0;
    }

    public int getMainConnState() {
        int state = 2;
        this.m_rwNeMutex.readLock().lock();
        state = this.m_connStateMain;
        this.m_rwNeMutex.readLock().unlock();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainConnState(int state) {
        boolean bIsGne;
        int oldstate = this.getCurConnState();
        this.m_rwNeMutex.writeLock().lock();
        try {
            this.m_connStateMain = state;
            bIsGne = this.getNeId() == this.getMainGneId();
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
        int newstate = this.getCurConnState();
        if (newstate != oldstate) {
            TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(this.getLogicNeId(), newstate == 1);
        }
        if (newstate != oldstate) {
            if (newstate == 2) {
                TECommuMgr.getInstance().NeConnBreakRpt(this.getLogicNeId(), bIsGne);
                this.setLogined(false);
            } else if (newstate == 1) {
                TECommuMgr.getInstance().NeConnResumeRpt(this.getLogicNeId(), bIsGne);
            }
        }
    }

    public int getMainUnReachTimeCount() {
        int nCount = 0;
        this.m_rwNeMutex.readLock().lock();
        nCount = this.m_nMainUnReachTimeCount;
        this.m_rwNeMutex.readLock().unlock();
        return nCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainUnReachTimeCount(int nCount) {
        this.m_rwNeMutex.writeLock().lock();
        try {
            this.m_nMainUnReachTimeCount = nCount;
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMainUnReachTimeCount(int nCount) {
        this.m_rwNeMutex.writeLock().lock();
        try {
            this.m_nMainUnReachTimeCount += nCount;
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBackupConnState(int nWhichBackupGne) {
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return 2;
        }
        int state = 2;
        this.m_rwNeMutex.readLock().lock();
        try {
            state = this.m_connStateBackup[nWhichBackupGne - 1];
        }
        finally {
            this.m_rwNeMutex.readLock().unlock();
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupConnState(int state, int nWhichBackupGne) {
        boolean bIsGne;
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return;
        }
        int oldstate = this.getCurConnState();
        this.m_rwNeMutex.writeLock().lock();
        try {
            this.m_connStateBackup[nWhichBackupGne - 1] = state;
            bIsGne = this.getNeId() == this.getMainGneId();
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
        int newstate = this.getCurConnState();
        if (newstate != oldstate) {
            TENEStateChangedMgr.getInstance().getQueueCommuState().pushChangedNEID(this.getLogicNeId(), newstate == 1);
        }
        if (newstate != oldstate) {
            if (newstate == 2) {
                TECommuMgr.getInstance().NeConnBreakRpt(this.getLogicNeId(), bIsGne);
                this.setLogined(false);
            } else if (newstate == 1) {
                TECommuMgr.getInstance().NeConnResumeRpt(this.getLogicNeId(), bIsGne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBackupUnReachTimeCount(int nWhichBackupGne) {
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return 0;
        }
        int nCount = 0;
        this.m_rwNeMutex.readLock().lock();
        try {
            nCount = this.m_nBackupUnReachTimeCount[nWhichBackupGne - 1];
        }
        finally {
            this.m_rwNeMutex.readLock().unlock();
        }
        return nCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupUnReachTimeCount(int nCount, int nWhichBackupGne) {
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return;
        }
        this.m_rwNeMutex.writeLock().lock();
        try {
            this.m_nBackupUnReachTimeCount[nWhichBackupGne - 1] = nCount;
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupUnReachTimeCount(int nCount, int nWhichBackupGne) {
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return;
        }
        this.m_rwNeMutex.writeLock().lock();
        try {
            int n = nWhichBackupGne - 1;
            this.m_nBackupUnReachTimeCount[n] = this.m_nBackupUnReachTimeCount[n] + nCount;
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
    }

    public boolean isMainGneHandleValid(int[] hMainGne) {
        hMainGne[0] = -1;
        boolean bRtn = false;
        int handle = -1;
        if (this.getMainGneId() != 0 && (handle = TECommuMgr.getInstance().getGneHandle(this.getMainGneId(), 0)) != -1) {
            hMainGne[0] = handle;
            bRtn = true;
        }
        return bRtn;
    }

    public boolean isBackupGneHandleValid(int[] hBackupGne, int nWhichBackupGne) {
        if (nWhichBackupGne <= 0 || nWhichBackupGne >= 4) {
            return false;
        }
        boolean bRtn = false;
        int handle = -1;
        int nBackupGneId = 0;
        switch (nWhichBackupGne) {
            case 1: {
                nBackupGneId = this.getBackup1gneId();
                break;
            }
            case 2: {
                nBackupGneId = this.getBackup2gneId();
                break;
            }
            case 3: {
                nBackupGneId = this.getBackup3gneId();
                break;
            }
        }
        if (nBackupGneId != 0 && (handle = TECommuMgr.getInstance().getGneHandle(nBackupGneId, 0)) != -1) {
            hBackupGne[0] = handle;
            bRtn = true;
        }
        return bRtn;
    }

    public int getCurrGneUnReachTimeCount() {
        int reachTimeCount = 0;
        switch (this.getNeGneState()) {
            case 0: {
                reachTimeCount = this.getMainUnReachTimeCount();
                break;
            }
            case 1: {
                reachTimeCount = this.getBackupUnReachTimeCount(1);
                break;
            }
            case 2: {
                reachTimeCount = this.getBackupUnReachTimeCount(2);
                break;
            }
            case 3: {
                reachTimeCount = this.getBackupUnReachTimeCount(3);
                break;
            }
        }
        return reachTimeCount;
    }

    public void setCurrGneUnReachTimeCount(int nCount) {
        switch (this.getNeGneState()) {
            case 0: {
                this.setMainUnReachTimeCount(nCount);
                break;
            }
            case 1: {
                this.setBackupUnReachTimeCount(nCount, 1);
                break;
            }
            case 2: {
                this.setBackupUnReachTimeCount(nCount, 2);
                break;
            }
            case 3: {
                this.setBackupUnReachTimeCount(nCount, 3);
                break;
            }
        }
    }

    public void addCurrGneUnReachTimeCount(int nCount) {
        switch (this.getNeGneState()) {
            case 0: {
                this.addMainUnReachTimeCount(nCount);
                break;
            }
            case 1: {
                this.addBackupUnReachTimeCount(nCount, 1);
                break;
            }
            case 2: {
                this.addBackupUnReachTimeCount(nCount, 2);
                break;
            }
            case 3: {
                this.addBackupUnReachTimeCount(nCount, 3);
                break;
            }
        }
    }

    public boolean isCurrGneHandleValid(int[] hGne) {
        hGne[0] = -1;
        switch (this.getNeGneState()) {
            case 0: {
                return this.isMainGneHandleValid(hGne);
            }
            case 1: {
                return this.isBackupGneHandleValid(hGne, 1);
            }
            case 2: {
                return this.isBackupGneHandleValid(hGne, 2);
            }
            case 3: {
                return this.isBackupGneHandleValid(hGne, 3);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveDataFlag(boolean bFlag) {
        int state = 2;
        this.m_rwNeMutex.writeLock().lock();
        try {
            if (bFlag) {
                if (this.m_NeGneState == 0) {
                    state = this.m_connStateMain;
                } else if (this.m_NeGneState == 1) {
                    state = this.m_connStateBackup[0];
                } else if (this.m_NeGneState == 2) {
                    state = this.m_connStateBackup[1];
                } else if (this.m_NeGneState == 3) {
                    state = this.m_connStateBackup[2];
                }
                if (state == 2) {
                    this.m_bReceiveDataFlag = false;
                } else {
                    if (this.m_NeGneState == 0) {
                        this.m_nMainUnReachTimeCount = 0;
                    } else if (this.m_NeGneState == 1) {
                        this.m_nBackupUnReachTimeCount[0] = 0;
                    } else if (this.m_NeGneState == 2) {
                        this.m_nBackupUnReachTimeCount[1] = 0;
                    } else if (this.m_NeGneState == 3) {
                        this.m_nBackupUnReachTimeCount[2] = 0;
                    }
                    this.m_bReceiveDataFlag = true;
                }
            } else {
                this.m_bReceiveDataFlag = false;
            }
        }
        finally {
            this.m_rwNeMutex.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiveData() {
        boolean bFlag;
        this.m_rwNeMutex.readLock().lock();
        try {
            bFlag = this.m_bReceiveDataFlag;
        }
        finally {
            this.m_rwNeMutex.readLock().unlock();
        }
        return bFlag;
    }

    public int getLogined() {
        return this.m_iLogined;
    }

    public void setLogined(boolean value) {
        if (value) {
            this.setLogined(1);
        } else {
            this.setLogined(0);
        }
    }

    public void setLogined(int value) {
        int iOldState = this.getLogined();
        this.m_iLogined = value;
        int iNewState = this.getLogined();
        if (iOldState != iNewState) {
            TENEStateChangedMgr.getInstance().getQueueLoginState().pushChangedNEID(this.getNeId(), iNewState != 0);
            if (1 == iNewState) {
                this.setCurConnState(1);
                TECommuMgr.getInstance().NeLoginResumeRpt(this.getLogicNeId());
            } else {
                TECommuMgr.getInstance().NeLogoutRpt(this.getLogicNeId());
            }
        }
    }

    public String getPassword() {
        EncryptDes des = new EncryptDes();
        byte[] bytePassword = des.hex2byte(this.encryptPassword);
        return des.doDecrypt(bytePassword);
    }

    public void setPassword(String value) {
    }
}

