/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ngwdm_pub.serv.cpadpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEChannelKey;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TELineModel;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TELineModelIndexInfo;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEPortKey;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TEPortModel;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TETimeSlotModel;
import com.huawei.nglct.ngwdm_pub.serv.cpadpt.TETimeslot;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEOpticalPortModelAdpt {
    private static final Logger LOGGER = TELogFactory.getNormalLogger();
    private static TEOpticalPortModelAdpt instance;
    private static String linemodeFilePath;
    private static String indexmodelFilePath;
    private static String lpMapFilePath;
    private static String velocityFilePath;
    private Map<Integer, TELineModel> linemodelRes = new HashMap<Integer, TELineModel>();
    private Map<TEPortKey, List<Integer>> indexMap = new HashMap<TEPortKey, List<Integer>>();
    private Map<TEChannelKey, List<TETimeslot>> timeslotMap = new HashMap<TEChannelKey, List<TETimeslot>>();
    private Map<Integer, List<Integer>> velocityMap = new HashMap<Integer, List<Integer>>();
    public static final int NM_PATH_ODU1 = 1409;
    public static final int NM_PATH_ODU2 = 1665;
    public static final int NM_PATH_ODU3 = 1921;
    public static final int NM_PATH_ODU4 = 2177;

    private TEOpticalPortModelAdpt() {
        this.loadVelocity();
        this.loadLineModel();
        this.loadmodelIndexMap();
        this.loadLPMap();
    }

    public static synchronized TEOpticalPortModelAdpt getInstance() {
        if (null == instance) {
            instance = new TEOpticalPortModelAdpt();
        }
        return instance;
    }

    private List<TETimeSlotModel> parseTsListUnderIndex(NodeList tss) {
        ArrayList<TETimeSlotModel> tsList = new ArrayList<TETimeSlotModel>();
        int tsLen = tss.getLength();
        for (int m = 0; m < tsLen; ++m) {
            Node ts = tss.item(m);
            if (!ts.getNodeName().equals("ts")) continue;
            TETimeSlotModel tsm = new TETimeSlotModel();
            NamedNodeMap tmnm = ts.getAttributes();
            tsm.setcSignal(tmnm.getNamedItem("signal").getNodeValue());
            tsm.setcUsage(tmnm.getNamedItem("usage").getNodeValue());
            tsm.setcTs(ts.getTextContent());
            tsList.add(tsm);
        }
        return tsList;
    }

    private TEPortModel parsePortModelUnderBoard(NodeList idxs) {
        TEPortModel pm = new TEPortModel();
        HashMap<Integer, List<TETimeSlotModel>> cTimeSlotModelMap = new HashMap<Integer, List<TETimeSlotModel>>();
        HashMap<Integer, TELineModelIndexInfo> cIndexInfoMap = new HashMap<Integer, TELineModelIndexInfo>();
        int idxLen = idxs.getLength();
        for (int l = 0; l < idxLen; ++l) {
            Node idx = idxs.item(l);
            if (!idx.getNodeName().equals("index")) continue;
            NamedNodeMap imnm = idx.getAttributes();
            int idxID = Integer.parseInt(imnm.getNamedItem("idx").getNodeValue());
            String workModel = imnm.getNamedItem("modeltype").getNodeValue();
            String idxName = imnm.getNamedItem("name").getNodeValue();
            TELineModelIndexInfo lii = new TELineModelIndexInfo();
            lii.setcMode(workModel);
            lii.setcIdxName(idxName);
            NodeList tss = idx.getChildNodes();
            cTimeSlotModelMap.put(idxID, this.parseTsListUnderIndex(tss));
            cIndexInfoMap.put(idxID, lii);
        }
        pm.setcTimeSlotModelMap(cTimeSlotModelMap);
        pm.setcIndexInfoMap(cIndexInfoMap);
        return pm;
    }

    private void loadmodelIndexMap() {
        Node doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + indexmodelFilePath);
        }
        catch (Exception e) {
            LOGGER.error("parse indexmodelFilePath fail", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse XML Fail: " + indexmodelFilePath);
            return;
        }
        NodeList schemas = doc.getChildNodes();
        int len = schemas.getLength();
        for (int i = 0; i < len; ++i) {
            Node schema = schemas.item(i);
            NodeList boards = schema.getChildNodes();
            int boardLen = boards.getLength();
            for (int j = 0; j < boardLen; ++j) {
                Node board = boards.item(j);
                if (!board.getNodeName().equals("board")) continue;
                NamedNodeMap bmnm = board.getAttributes();
                ArrayList<Integer> portArray = new ArrayList<Integer>();
                ArrayList<Integer> indexArray = new ArrayList<Integer>();
                int cpType = Integer.parseInt(bmnm.getNamedItem("typeid").getNodeValue());
                String portlist = bmnm.getNamedItem("portlist").getNodeValue();
                int portmode = Integer.parseInt(bmnm.getNamedItem("portmode").getNodeValue());
                int timeslotmode = Integer.parseInt(bmnm.getNamedItem("timeslotmode").getNodeValue());
                String indexList = bmnm.getNamedItem("idxlist").getNodeValue();
                TEStringUtils.strToNumList(portlist, portArray);
                TEStringUtils.strToNumList(indexList, indexArray);
                for (Integer port : portArray) {
                    this.indexMap.put(new TEPortKey(cpType, port, portmode, timeslotmode), indexArray);
                    if (!this.velocityMap.containsKey(cpType)) continue;
                    Iterator<Integer> it = this.velocityMap.get(cpType).iterator();
                    while (it.hasNext()) {
                        this.indexMap.put(new TEPortKey(it.next(), port, portmode, timeslotmode), indexArray);
                    }
                }
            }
        }
    }

    private void loadLPMap() {
        Node doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + lpMapFilePath);
        }
        catch (Exception e) {
            LOGGER.error("parse lpMapFilePath fail", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse XML Fail: " + lpMapFilePath);
            return;
        }
        NodeList schemas = doc.getChildNodes();
        int len = schemas.getLength();
        for (int i = 0; i < len; ++i) {
            Node schema = schemas.item(i);
            NodeList boards = schema.getChildNodes();
            int boardLen = boards.getLength();
            for (int j = 0; j < boardLen; ++j) {
                Node board = boards.item(j);
                if (!board.getNodeName().equals("board")) continue;
                NamedNodeMap bmnm = board.getAttributes();
                int cpType = Integer.parseInt(bmnm.getNamedItem("typeid").getNodeValue());
                NodeList ports = board.getChildNodes();
                int portLen = ports.getLength();
                for (int k = 0; k < portLen; ++k) {
                    Node port = ports.item(k);
                    if (!port.getNodeName().equals("logicalport")) continue;
                    NamedNodeMap portAttr = port.getAttributes();
                    int portid = Integer.parseInt(portAttr.getNamedItem("portid").getNodeValue());
                    NodeList channels = port.getChildNodes();
                    this.getLPMapChannel(cpType, portid, channels);
                }
            }
        }
    }

    private void getLPMapChannel(int cpType, int portid, NodeList channels) {
        int channelLen = channels.getLength();
        for (int i = 0; i < channelLen; ++i) {
            Node channel = channels.item(i);
            if (!channel.getNodeName().equals("channel")) continue;
            NamedNodeMap channelAttr = channel.getAttributes();
            int channelid = Integer.parseInt(channelAttr.getNamedItem("id").getNodeValue());
            NodeList operList = channel.getChildNodes();
            ArrayList<TETimeslot> tsList = new ArrayList<TETimeslot>();
            int jLen = operList.getLength();
            for (int j = 0; j < jLen; ++j) {
                Node oper = operList.item(j);
                if (!oper.getNodeName().equals("operation")) continue;
                NodeList tsNodeList = oper.getChildNodes();
                int kLen = tsNodeList.getLength();
                for (int k = 0; k < kLen; ++k) {
                    Node tsNode = tsNodeList.item(k);
                    if (!tsNode.getNodeName().equals("ts")) continue;
                    NamedNodeMap tsMap = tsNode.getAttributes();
                    TETimeslot timeslot = new TETimeslot(tsMap.getNamedItem("signal").getNodeValue(), tsNode.getFirstChild().getNodeValue());
                    tsList.add(timeslot);
                }
            }
            TEChannelKey key = new TEChannelKey(cpType, portid, channelid);
            this.timeslotMap.put(key, tsList);
            if (!this.velocityMap.containsKey(cpType)) continue;
            Iterator<Integer> it = this.velocityMap.get(cpType).iterator();
            while (it.hasNext()) {
                key = new TEChannelKey(it.next(), portid, channelid);
                this.timeslotMap.put(key, tsList);
            }
        }
    }

    private void loadVelocity() {
        Node doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + velocityFilePath);
        }
        catch (Exception e) {
            LOGGER.error("parse velocityFilePath fail", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse XML Fail: " + velocityFilePath);
            return;
        }
        NodeList schemas = doc.getChildNodes();
        int len = schemas.getLength();
        for (int i = 0; i < len; ++i) {
            Node schema = schemas.item(i);
            NodeList boards = schema.getChildNodes();
            int boardLen = boards.getLength();
            for (int j = 0; j < boardLen; ++j) {
                Node board = boards.item(j);
                if (!board.getNodeName().equals("board")) continue;
                NamedNodeMap bmnm = board.getAttributes();
                int cpType = Integer.parseInt(bmnm.getNamedItem("typeid").getNodeValue());
                NodeList similaritys = board.getChildNodes();
                ArrayList<Integer> simiList = new ArrayList<Integer>();
                int kLength = similaritys.getLength();
                for (int k = 0; k < kLength; ++k) {
                    Node simi = similaritys.item(k);
                    if (!simi.getNodeName().equals("similarity")) continue;
                    NamedNodeMap pmnm = simi.getAttributes();
                    simiList.add(Integer.parseInt(pmnm.getNamedItem("typeid").getNodeValue()));
                }
                this.velocityMap.put(cpType, simiList);
            }
        }
    }

    private void loadLineModel() {
        Node doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + linemodeFilePath);
        }
        catch (Exception e) {
            LOGGER.error("parse transxlinemodel.xml fail", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().error("Parse XML Fail: " + linemodeFilePath);
            return;
        }
        NodeList schemas = doc.getChildNodes();
        int len = schemas.getLength();
        for (int i = 0; i < len; ++i) {
            Node schema = schemas.item(i);
            NodeList boards = schema.getChildNodes();
            int boardLen = boards.getLength();
            for (int j = 0; j < boardLen; ++j) {
                Node board = boards.item(j);
                if (!board.getNodeName().equals("board")) continue;
                TELineModel lm = new TELineModel();
                NamedNodeMap bmnm = board.getAttributes();
                int cpType = Integer.parseInt(bmnm.getNamedItem("typeid").getNodeValue());
                lm.setcCPName(bmnm.getNamedItem("name").getNodeValue());
                lm.setcCPType(cpType);
                lm.setcVendor(bmnm.getNamedItem("vendor").getNodeValue());
                NodeList ports = board.getChildNodes();
                int portLen = ports.getLength();
                HashMap<Integer, TEPortModel> portMap = new HashMap<Integer, TEPortModel>(portLen);
                for (int k = 0; k < portLen; ++k) {
                    Node port = ports.item(k);
                    if (!port.getNodeName().equals("hostport")) continue;
                    NamedNodeMap pmnm = port.getAttributes();
                    int portID = Integer.parseInt(pmnm.getNamedItem("portid").getNodeValue());
                    TEPortModel pm = this.parsePortModelUnderBoard(port.getChildNodes());
                    pm.setcPortID(portID);
                    portMap.put(portID, pm);
                }
                lm.setPortMap(portMap);
                this.linemodelRes.put(cpType, lm);
                if (!this.velocityMap.containsKey(cpType)) continue;
                Iterator<Integer> it = this.velocityMap.get(cpType).iterator();
                while (it.hasNext()) {
                    this.linemodelRes.put(it.next(), lm);
                }
            }
        }
    }

    public List<TETimeSlotModel> getMappedTimeSlotModelList(int bdType, int opticalPortNum, int index) {
        TELineModel lm = this.linemodelRes.get(bdType);
        if (lm == null) {
            return new ArrayList<TETimeSlotModel>();
        }
        Map<Integer, TEPortModel> portMap = lm.getPortMap();
        if (portMap == null) {
            return new ArrayList<TETimeSlotModel>();
        }
        TEPortModel pm = portMap.get(opticalPortNum);
        if (pm == null) {
            return new ArrayList<TETimeSlotModel>();
        }
        List<TETimeSlotModel> timeSLotList = pm.getcTimeSlotModelMap().get(index);
        return timeSLotList;
    }

    public List<TETimeSlotModel> getMappedTimeSlotModelList(TEPortKey port) {
        ArrayList<TETimeSlotModel> timeSLotList = new ArrayList<TETimeSlotModel>();
        List<Integer> indexList = this.indexMap.get(port);
        if (indexList == null) {
            LOGGER.error("timeslot model not found: " + port);
            return new ArrayList<TETimeSlotModel>();
        }
        for (Integer index : indexList) {
            List<TETimeSlotModel> subList = this.getMappedTimeSlotModelList(port.getBoardType(), port.getPortNo(), index);
            timeSLotList.addAll(subList);
        }
        return timeSLotList;
    }

    public List<TETimeSlotModel> getAllTimeSlotModelList(int bdType, int opticalPortNum) {
        TELineModel lm = this.linemodelRes.get(bdType);
        Map<Integer, TEPortModel> portMap = lm.getPortMap();
        TEPortModel pm = portMap.get(opticalPortNum);
        ArrayList<TETimeSlotModel> timeSLotList = new ArrayList<TETimeSlotModel>();
        for (Map.Entry<Integer, List<TETimeSlotModel>> entry : pm.getcTimeSlotModelMap().entrySet()) {
            timeSLotList.addAll((Collection<TETimeSlotModel>)entry.getValue());
        }
        return timeSLotList;
    }

    public List<Integer> getAllPortList(int boardType) {
        ArrayList<Integer> portList = new ArrayList<Integer>();
        if (this.linemodelRes.get(boardType) == null) {
            LOGGER.info("boardType " + boardType + "not fount!");
            return portList;
        }
        Map<Integer, TEPortModel> portMap = this.linemodelRes.get(boardType).getPortMap();
        for (Map.Entry<Integer, TEPortModel> e : portMap.entrySet()) {
            portList.add(e.getKey());
        }
        Collections.sort(portList);
        return portList;
    }

    public List<TETimeslot> getTimeslotByChannel(TEChannelKey key) {
        if (key.getChannelid() == 1409 || key.getChannelid() == 1665 || key.getChannelid() == 1921 || key.getChannelid() == 2177) {
            return this.timeslotMap.get(new TEChannelKey(key.getBoardType(), key.getPortid(), 1));
        }
        return this.timeslotMap.get(key);
    }

    public int getPathByTimeslot(int cptype, int portid, TETimeSlotModel ts) {
        int pathid = 1;
        for (Map.Entry<TEChannelKey, List<TETimeslot>> entry : this.timeslotMap.entrySet()) {
            TEChannelKey key = entry.getKey();
            if (key.getBoardType() != cptype || key.getPortid() != portid) continue;
            List<TETimeslot> tsList = entry.getValue();
            for (TETimeslot timeslot : tsList) {
                if (!timeslot.getValue().equals(ts.getcTs())) continue;
                return key.getChannelid();
            }
        }
        return pathid;
    }

    public int getLineBoardPathByTimeslot(int cptype, int portid, TETimeSlotModel ts) {
        int tempPathId;
        int grade;
        int pathid = this.getPathByTimeslot(cptype, portid, ts);
        if (pathid == 1 && (grade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(cptype)) != -1 && (tempPathId = TEOTNModelDataMgr.getInstance().getNmPath(1, grade, pathid, cptype)) != -1) {
            pathid = tempPathId;
        }
        return pathid;
    }

    static {
        linemodeFilePath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "transxlinemodel.xml";
        indexmodelFilePath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "indexmodelmap.xml";
        lpMapFilePath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "lpmap_155.xml";
        velocityFilePath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "velocity.xml";
    }
}

