/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ngwdm_pub;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TETL1AIDTranslateRuleMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;

public class TETL1SimpleAID {
    private int nmSlotID = -1;
    private int portID = -1;
    private int shelfID = -1;
    private String tl1Path = "";
    private String aidPre = "";
    private String fullAid = "";
    private int neSlotID = -1;
    private int neID = -1;
    private boolean hasShelf = false;
    public static final int INVALIDPATH = 65535;
    private TETL1AIDTranslateRuleMgr instance = TETL1AIDTranslateRuleMgr.getInstance();

    public TETL1SimpleAID(String _fullAid, int _neID) {
        this.fullAid = _fullAid;
        this.neID = _neID;
        this.initAid();
    }

    private void initAid() {
        this.hasShelf = TETL1CommonUtil.hasShelfNE(this.neID);
        String[] aidArr = this.fullAid.split("-");
        int len = aidArr.length;
        int pathBeginIndex = 4;
        if (this.hasShelf) {
            if (len < 4) {
                return;
            }
            this.shelfID = Integer.parseInt(aidArr[1]);
            this.neSlotID = Integer.parseInt(aidArr[2]);
            this.nmSlotID = this.shelfID * 65536 + this.neSlotID;
            this.portID = Integer.parseInt(aidArr[3]);
        } else {
            if (len < 3) {
                return;
            }
            this.neSlotID = Integer.parseInt(aidArr[1]);
            this.nmSlotID = Integer.parseInt(aidArr[1]);
            this.portID = Integer.parseInt(aidArr[2]);
            pathBeginIndex = 3;
        }
        this.aidPre = aidArr[0];
        this.tl1Path = this.handleTL1Path(aidArr, pathBeginIndex);
    }

    private String handleTL1Path(String[] aidArr, int pathBeginIndex) {
        StringBuffer sb = new StringBuffer();
        int len = aidArr.length;
        for (int i = pathBeginIndex; i < len; ++i) {
            sb.append(aidArr[i]);
            if (i == len - 1) continue;
            sb.append("-");
        }
        if (sb.toString().equals("")) {
            sb.append(65535);
        }
        return sb.toString();
    }

    public int getNmSlotID() {
        return this.nmSlotID;
    }

    public int getPortID() {
        return this.portID;
    }

    public String getTl1Path() {
        return this.tl1Path;
    }

    public String getAidPre() {
        return this.aidPre;
    }

    public int getNmPath(String mod2) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.getNmSlotID());
        int path = this.instance.getSimplePath(boardType, mod2, this.aidPre, this.getTl1Path());
        if (path == 65535) {
            return -1;
        }
        return path;
    }

    public boolean hasShelf() {
        return this.hasShelf;
    }

    public int getShelfID() {
        return this.shelfID;
    }

    public boolean isSimplesBoard() {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neID, this.getNmSlotID());
        return this.instance.isSimpleBoard(boardType);
    }

    public int getSlotID() {
        return this.neSlotID;
    }

    public int getNMPortID() {
        return TETL1CommonUtil.getNMPortNOFromNEPort(this.aidPre, this.nmSlotID, this.portID, this.neID);
    }
}

