/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.ngwdm_pub;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.ngwdm_pub.TEAIDPathRuleData;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TETL1AIDTranslateRuleMgr {
    private static TETL1AIDTranslateRuleMgr instance = null;
    private HashMap<Integer, ArrayList<TEAIDPathRuleData>> aidRuleMap = new HashMap();
    private HashMap<String, String> pathModeMap = new HashMap();

    private TETL1AIDTranslateRuleMgr() {
        this.parseXML();
    }

    public static synchronized TETL1AIDTranslateRuleMgr getInstance() {
        if (instance == null) {
            instance = new TETL1AIDTranslateRuleMgr();
        }
        return instance;
    }

    private void parseXML() {
        String filepath = "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "ngwdm_pub" + File.separator + "tl1wdm_aid_tranlation.xml";
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.common", TEResourceManager.getPath() + File.separator + filepath);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1AIDTranslateRuleMgr.parseXML fail!", (Throwable)e);
        }
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse XML Fail: " + filepath);
            return;
        }
        NodeList nodeList = doc.getElementsByTagName("param");
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element node = (Element)nodeList.item(i);
            String boardName = node.getAttribute("bdName");
            int cptype = instance.parseInt(boardName);
            if (cptype == 0) continue;
            StringBuffer keyPathSb = new StringBuffer();
            String mod2Type = node.getAttribute("mod2Type");
            String aidPre = node.getAttribute("AIDPre");
            String tl1Path = node.getAttribute("TL1Path");
            String path = node.getAttribute("Path");
            int tenPathValue = Integer.decode(path);
            keyPathSb.append(cptype);
            keyPathSb.append("-");
            keyPathSb.append(tenPathValue);
            this.pathModeMap.put(keyPathSb.toString(), mod2Type);
            TEAIDPathRuleData aidData = new TEAIDPathRuleData(mod2Type, aidPre, tl1Path, path);
            ArrayList<TEAIDPathRuleData> tempList = this.aidRuleMap.get(cptype);
            if (tempList != null) {
                tempList.add(aidData);
                continue;
            }
            ArrayList<TEAIDPathRuleData> list = new ArrayList<TEAIDPathRuleData>();
            list.add(aidData);
            this.aidRuleMap.put(cptype, list);
        }
    }

    public int getSimplePath(int boardType, String mod2, String aidPre, String tl1Path) {
        int tcmIndex;
        ArrayList<TEAIDPathRuleData> pathList = this.aidRuleMap.get(boardType);
        if (pathList == null || !aidPre.equalsIgnoreCase("FAC")) {
            return this.parsePath(tl1Path);
        }
        String hexTl1Path = tl1Path;
        if (tl1Path.equals("65535")) {
            hexTl1Path = "0xFFFF";
        }
        if ((tcmIndex = mod2.indexOf("TCM")) != -1) {
            mod2 = mod2.substring(0, tcmIndex);
        }
        int size = pathList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDPathRuleData data = pathList.get(i);
            if (!data.getMod2Type().equalsIgnoreCase(mod2) || !data.getAidPre().equalsIgnoreCase(aidPre) || !data.getTL1Path().equalsIgnoreCase(hexTl1Path)) continue;
            int tenValue = Integer.decode(data.getPath());
            return tenValue;
        }
        return -1;
    }

    private int parsePath(String tl1Path) {
        int path = -1;
        if (tl1Path.equals("65535")) {
            return -1;
        }
        try {
            path = Integer.parseInt(tl1Path);
        }
        catch (Exception e) {
            path = -1;
        }
        return path;
    }

    public String getTL1Path(int boardType, String mod2, String aidPre, String path) {
        ArrayList<TEAIDPathRuleData> pathList = this.aidRuleMap.get(boardType);
        if (pathList == null) {
            return path;
        }
        int tcmIndex = mod2.indexOf("TCM");
        if (tcmIndex != -1) {
            mod2 = mod2.substring(0, tcmIndex);
        }
        int size = pathList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDPathRuleData data = pathList.get(i);
            int tenValue = Integer.decode(data.getPath());
            if (!data.getMod2Type().equalsIgnoreCase(mod2) || !data.getAidPre().equalsIgnoreCase(aidPre) || tenValue != Integer.parseInt(path)) continue;
            if (data.getTL1Path().equals("0xFFFF")) {
                return "";
            }
            return data.getTL1Path();
        }
        return path;
    }

    public String getTL1Path(int boardType, String path) {
        ArrayList<TEAIDPathRuleData> pathList = this.aidRuleMap.get(boardType);
        if (pathList == null) {
            return path;
        }
        int size = pathList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDPathRuleData data = pathList.get(i);
            int tenValue = Integer.decode(data.getPath());
            if (tenValue != Integer.parseInt(path)) continue;
            if (data.getTL1Path().equals("0xFFFF")) {
                return "";
            }
            return data.getTL1Path();
        }
        return path;
    }

    public String getCurMod2(int boardType, String path) {
        String key = boardType + "-" + path;
        String mod2 = this.pathModeMap.get(key);
        if (mod2 == null) {
            return "";
        }
        return mod2;
    }

    public List<Integer> getPathListFromMod2(int boardType, String mod2) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        ArrayList<TEAIDPathRuleData> pathList = this.aidRuleMap.get(boardType);
        if (pathList == null) {
            return tmpList;
        }
        int size = pathList.size();
        for (int i = 0; i < size; ++i) {
            TEAIDPathRuleData data = pathList.get(i);
            int tenValue = Integer.decode(data.getPath());
            if (!data.getMod2Type().equalsIgnoreCase(mod2)) continue;
            tmpList.add(tenValue);
        }
        return tmpList;
    }

    public boolean isSimpleBoard(int boardType) {
        ArrayList<TEAIDPathRuleData> pathList = this.aidRuleMap.get(boardType);
        return pathList != null;
    }
}

